/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Queue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object[] elements;
    private int initialCapacity;
    private int capacityIncrement;
    private int startPos;
    private int endPos;

    public boolean isEmpty() {
        return this.startPos == this.endPos;
    }

    public synchronized void push(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object can't be null");
        }
        this.elements[this.endPos] = object;
        if (++this.endPos == this.elements.length) {
            this.endPos = 0;
        }
        if (this.endPos == this.startPos) {
            Object[] newElements = new Object[this.elements.length + this.capacityIncrement];
            System.arraycopy(this.elements, 0, newElements, 0, this.endPos);
            System.arraycopy(this.elements, this.startPos, newElements, this.startPos + this.capacityIncrement, this.elements.length - this.startPos);
            this.startPos += this.capacityIncrement;
            this.elements = newElements;
        }
        this.notify();
    }

    public synchronized Object popNoWait() {
        if (this.startPos != this.endPos) {
            Object obj = this.elements[this.startPos];
            this.elements[this.startPos] = null;
            if (++this.startPos == this.elements.length) {
                this.startPos = 0;
            }
            return obj;
        }
        return null;
    }

    public synchronized Object pop(long timeout) {
        if (this.isEmpty()) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.popNoWait();
    }

    public synchronized Object pop() {
        return this.pop(0L);
    }

    public synchronized void empty() {
        while (this.startPos != this.endPos) {
            this.elements[this.startPos] = null;
            if (++this.startPos != this.elements.length) continue;
            this.startPos = 0;
        }
    }

    public synchronized Enumeration elements() {
        return new Enumerator();
    }

    public Queue(int initialCapacity, int capacityIncrement) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity must be >= 1");
        }
        if (capacityIncrement < 1) {
            throw new IllegalArgumentException("capacityIncrement must be >= 1");
        }
        this.initialCapacity = initialCapacity;
        this.capacityIncrement = capacityIncrement;
        this.elements = new Object[initialCapacity];
        this.startPos = 0;
        this.endPos = 0;
    }

    public Queue(int initialCapacity) {
        this(initialCapacity, 10);
    }

    public Queue() {
        this(10, 10);
    }

    private class Enumerator
    implements Enumeration {
        int pos;

        public boolean hasMoreElements() {
            return this.pos != Queue.this.endPos;
        }

        public Object nextElement() {
            Queue queue = Queue.this;
            synchronized (queue) {
                if (this.pos != Queue.this.endPos) {
                    Object obj = Queue.this.elements[this.pos];
                    if (++this.pos == Queue.this.elements.length) {
                        this.pos = 0;
                    }
                    return obj;
                }
            }
            throw new NoSuchElementException("QueueEnumerator");
        }

        Enumerator() {
            this.pos = Queue.this.startPos;
        }
    }
}

