/*
 Copyright (c) 1995-2021  by Arkkra Enterprises.
 All rights reserved.

 Redistribution and use in source and binary forms,
 with or without modification, are permitted provided that
 the following conditions are met:

 1. Redistributions of source code must retain
 the above copyright notice, this list of conditions
 and the following DISCLAIMER.

 2. Redistributions in binary form must reproduce the above
 copyright notice, this list of conditions and
 the following DISCLAIMER in the documentation and/or
 other materials provided with the distribution.

 3. Any additions, deletions, or changes to the original files
 must be clearly indicated in accompanying documentation,
 including the reasons for the changes,
 and the names of those who made the modifications.

	DISCLAIMER

 THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS
 OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 THE IMPLIED WARRANTIES OF MERCHANTABILITY
 AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
 INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO
 PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE)
 ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
 * Define the list of all the special music symbols.
 */

/* The following set of symbols is in font FONT_MUSIC.
 * Mapping between name and number is done via Sym2code_table[0][].
 */
#define C_GCLEF		(32)	/* G clef (treble clef) */
#define C_FCLEF		(33)	/* F clef (bass clef) */
#define C_CCLEF		(34)	/* C clef (alto, tenor, etc. clef) */
#define C_OCTWHOLE	(35)	/* octuple whole note (maxima) */
#define C_QUADWHOLE	(36)	/* quadruple whole note (longa) */
#define C_DBLWHOLE	(37)	/* double whole note */
#define C_ALTDBLWHOLE	(38)	/* alternate form of double whole note */
#define C_1N		(39)	/* whole note */
#define C_2N		(40)	/* half note head */
#define C_4N		(41)	/* quarter (and shorter) note head */
#define C_UPFLAG	(42)	/* upward flag */
#define C_DNFLAG	(43)	/* downward flag */
#define C_OWHREST	(44)	/* octuple whole rest */
#define C_QWHREST	(45)	/* quad rest */
#define C_DWHREST	(46)	/* double whole rest */
#define C_1REST		(47)	/* whole rest */
#define C_2REST		(48)	/* half rest */
#define C_4REST		(49)	/* quarter rest */
#define C_8REST		(50)	/* eighth rest */
#define C_16REST	(51)	/* sixteenth rest */
#define C_32REST	(52)	/* thirty-second rest */
#define C_64REST	(53)	/* sixty-fourth rest */
#define C_128REST	(54)	/* 128th rest */
#define C_256REST	(55)	/* 256th rest */
#define C_LL1REST	(56)	/* legerline-less version of whole rest */
#define C_LL2REST	(57)	/* legerline-less version of half rest */
#define C_DOT		(58)	/* dot, as for after a note */
#define C_NAT		(59)	/* natural sign (n) */
#define C_SHARP		(60)	/* sharp sign (#) */
#define C_FLAT		(61)	/* flat sign (&) */
#define C_DBLSHARP	(62)	/* double sharp */
#define C_DBLFLAT	(63)	/* double flat */
#define C_XNOTE		(64)	/* X-shaped note head */
#define C_DWHDIAMOND	(65)	/* double-whole diamond shaped note */
#define C_DIAMOND	(66)	/* diamond-shaped note head */
#define C_FILLDIAMOND	(67)	/* filled diamond note head */
#define C_UP2N		(68)	/* half note with stem up */
#define C_DN2N		(69)	/* half note with stem down */
#define C_UP4N		(70)	/* quarter note with stem up */
#define C_DN4N		(71)	/* quarter note with stem down */
#define C_COM		(72)	/* common time */
#define C_CUT		(73)	/* cut time */
#define C_BEGPED	(74)	/* begin pedal */
#define C_PEDAL		(75)	/* pedal up/down */
#define C_ENDPED	(76)	/* end pedal */
#define C_DNBOW		(77)	/* down bow */
#define C_UPBOW		(78)	/* up bow */
#define C_WEDGE		(79)	/* wedge mark */
#define C_UWEDGE	(80)	/* upside-down wedge */
#define C_FERM		(81)	/* fermata */
#define C_UFERM		(82)	/* upside-down fermata */
#define C_SIGN		(83)	/* for D.S. */
#define C_CODA		(84)	/* the + over circle for jumping to coda */
#define C_MOR		(85)	/* mordent */
#define C_INVMOR	(86)	/* inverted mordent */
#define C_TURN		(87)	/* "turn" ornament */
#define C_INVTURN	(88)	/* inverted turn */
#define C_ACC_GT	(89)	/* accent that looks like > */
#define C_ACC_HAT	(90)	/* accent that looks like ^ */
#define C_ACC_UHAT	(91)	/* upside down hat accent */
#define C_TR		(92)	/* trill */
#define C_LEG		(93)	/* legato mark */
#define C_RR		(94)	/* railroad tracks */
#define C_DIM		(95)	/* diminished (small circle) */
#define C_HALFDIM	(96)	/* half diminished (small circle with slash) */
#define C_TRIANGLE	(97)	/* triangle, as for a major 7th chord */
#define C_MEASRPT	(98)	/* measure repeat */
#define C_COPYRIGHT	(99)	/* c in circle */
#define C_UP8N		(100)	/* 1/8 note with stem up */
#define C_DN8N		(101)	/* 1/8 note with stem down */
#define C_UP16N		(102)	/* 1/16 note with stem up */
#define C_DN16N		(103)	/* 1/16 note with stem down */
#define C_UP32N		(104)	/* 1/32 note with stem up */
#define C_DN32N		(105)	/* 1/32 note with stem down */
#define C_UP64N		(106)	/* 1/64 note with stem up */
#define C_DN64N		(107)	/* 1/64 note with stem down */
#define C_UP128N	(108)	/* 1/128 note with stem up */
#define C_DN128N	(109)	/* 1/128 note with stem down */
#define C_UP256N	(110)	/* 1/256 note with stem up */
#define C_DN256N	(111)	/* 1/256 note with stem down */

/* The following set of symbols is in font FONT_MUSIC2.
 * Mapping between name and number is done via Sym2code_table[1][].
 */
#define C_DWHRIGHTTRIANGLE	(32)	/* double whole right triangle */
#define C_RIGHTTRIANGLE		(33)	/* hollow right triangle */
#define C_FILLRIGHTTRIANGLE	(34)	/* filled right triangle */
#define C_UDWHRIGHTTRIANGLE	(35)	/* upside down double whole right tri*/
#define C_URIGHTTRIANGLE	(36)	/* upside down hollow right triangle */
#define C_UFILLRIGHTTRIANGLE	(37)	/* upside down filled right triangle */
#define C_DWHRECTANGLE		(38)	/* double whole rectangle */
#define C_RECTANGLE		(39)	/* hollow rectangle */
#define C_FILLRECTANGLE		(40)	/* filled rectangle */
#define C_DWHISOSTRIANGLE	(41)	/* double whole isosceles triangle */
#define C_ISOSTRIANGLE		(42)	/* hollow isosceles triangle */
#define C_FILLISOSTRIANGLE	(43)	/* filled isosceles triangle */
#define C_DWHPIEWEDGE		(44)	/* double whole pie wedge */
#define C_PIEWEDGE		(45)	/* hollow pie wedge */
#define C_FILLPIEWEDGE		(46)	/* filled pie wedge */
#define C_DWHSEMICIRCLE		(47)	/* double whole semicircle */
#define C_SEMICIRCLE		(48)	/* hollow semicircle */
#define C_FILLSEMICIRCLE	(49)	/* filled semicircle */
#define C_DWHSLASHHEAD		(50)	/* double whole slash note head */
#define C_SLASHHEAD		(51)	/* hollow slash note head */
#define C_FILLSLASHHEAD		(52)	/* filled slash note head */
#define C_BLANKHEAD		(53)	/* blank note head */
#define C_PERFMAIOR		(54)	/* perfectum maior */
#define C_PERFMINOR		(55)	/* perfectum minor */
#define C_IMPERFMAIOR		(56)	/* imperfectum maior */
#define C_IMPERFMINOR		(57)	/* imperfectum minor */
#define C_PERFMAIORDIM		(58)	/* perfectum maior diminutum */
#define C_PERFMINORDIM		(59)	/* perfectum minor diminutum */
#define C_IMPERFMAIORDIM	(60)	/* imperfectum maior diminutum */
#define C_IMPERFMINORDIM	(61)	/* imperfectum minor diminutum */
#define C_DBLMEASRPT		(62)	/* double measure repeat */
#define C_QUADMEASRPT		(63)	/* quadruple measure repeat */
