/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.facebook.thrift.metrics.distribution;

public enum Quantile {
  P50("p50", 50),
  P75("p75", 75),
  P90("p90", 90),
  P95("p95", 95),
  P99("p99", 99),
  AVG("avg", -1),
  MIN("min", -1),
  MAX("max", -1),
  SUM("sum", -1);

  private final String key;
  private final double quantile;

  private Quantile(String key, double quantile) {
    this.key = key;
    this.quantile = quantile;
  }

  public String getKey() {
    return key;
  }

  public double getQuantile() {
    return quantile;
  }
}
