use simba::simd::SimdValue;

use crate::base::OVector;
use crate::Scalar;

use crate::geometry::Scale;

impl<T: Scalar + SimdValue, const D: usize> SimdValue for Scale<T, D>
where
    T::Element: Scalar,
{
    type Element = Scale<T::Element, D>;
    type SimdBool = T::SimdBool;

    #[inline]
    fn lanes() -> usize {
        T::lanes()
    }

    #[inline]
    fn splat(val: Self::Element) -> Self {
        OVector::splat(val.vector).into()
    }

    #[inline]
    fn extract(&self, i: usize) -> Self::Element {
        self.vector.extract(i).into()
    }

    #[inline]
    unsafe fn extract_unchecked(&self, i: usize) -> Self::Element {
        self.vector.extract_unchecked(i).into()
    }

    #[inline]
    fn replace(&mut self, i: usize, val: Self::Element) {
        self.vector.replace(i, val.vector)
    }

    #[inline]
    unsafe fn replace_unchecked(&mut self, i: usize, val: Self::Element) {
        self.vector.replace_unchecked(i, val.vector)
    }

    #[inline]
    fn select(self, cond: Self::SimdBool, other: Self) -> Self {
        self.vector.select(cond, other.vector).into()
    }
}
