<p align="center">
  <a href="https://github.com/get-woke/woke">
    <img alt="woke logo" src="https://raw.githubusercontent.com/get-woke/woke/main/assets/default-monochrome.svg" height="80" />
  </a>
  <h3 align="center">
    Detect non-inclusive language in your source code.
  </h3>
  <p align="center"><em>I stay woke - Erykah Badu</em></p>
</p>

---
<br />

[![GitHub release (latest SemVer)](https://img.shields.io/github/v/release/get-woke/woke?logo=github&sort=semver)](https://github.com/get-woke/woke/releases)
![GitHub All Releases](https://img.shields.io/github/downloads/get-woke/woke/total)
[![Build](https://github.com/get-woke/woke/workflows/Build/badge.svg?branch=main)](https://github.com/get-woke/woke/actions)
[![MIT License](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)
[![Go Report Card](https://goreportcard.com/badge/github.com/get-woke/woke)](https://goreportcard.com/report/github.com/get-woke/woke)
[![codecov](https://codecov.io/gh/get-woke/woke/branch/main/graph/badge.svg?token=BP133BM3HP)](https://codecov.io/gh/get-woke/woke/branch/main)

[![PkgGoDev](https://pkg.go.dev/badge/github.com/get-woke/woke)](https://pkg.go.dev/github.com/get-woke/woke)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)
![GitHub go.mod Go version](https://img.shields.io/github/go-mod/go-version/get-woke/woke)
[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2Fget-woke%2Fwoke.svg?type=shield)](https://app.fossa.com/projects/git%2Bgithub.com%2Fget-woke%2Fwoke?ref=badge_shield)
[![Mentioned in Awesome Go](https://awesome.re/mentioned-badge.svg)](https://github.com/avelino/awesome-go#other-software)

---

Creating an inclusive work environment is imperative to a healthy, supportive, and
productive culture, and an environment where everyone feels welcome and included.

`woke` is a text file analysis tool that finds places within your source code that contain
non-inclusive language and suggests replacing them with more inclusive alternatives.

Companies like [GitHub](https://github.com/github/renaming), [Twitter](https://twitter.com/TwitterEng/status/1278733303508418560), and [Apple](https://developer.apple.com/news/?id=1o9zxsxl) are actively supporting a move to inclusive language.

![woke.gif](https://raw.githubusercontent.com/get-woke/get-woke.github.io/main/img/woke.gif)

## Why is this named `woke`?

> When [I](https://github.com/caitlinelfring) started writing `woke` in August 2020, my goal was to build a
> tool that would shed light on non-inclusive language in source code and that would enable a long-term commitment to using inclusive language.
>
> `woke` is a reference to an awareness of social and political issues, especially racial prejudice and discrimination,
> and has a historic use within the African-American community.
> This tool aims to push this kind of awareness even further into the software development community.
>
> I named this project `woke` because I saw it as a tool to awaken our code to non-inclusive language.
>
> You can read more about the origins and history of the word on [Wikipedia](https://en.wikipedia.org/wiki/Woke).

## Install `woke`

- [On my machine](https://docs.getwoke.tech/installation)
- [On CI/CD systems](https://docs.getwoke.tech/installation/#ci)

## Documentation

Documentation is hosted at <https://docs.getwoke.tech>.

## Contributing

Please read [CONTRIBUTING.md](https://github.com/get-woke/woke/blob/main/CONTRIBUTING.md) for details on our code of conduct, and the process for submitting pull requests to us.

[![GitHub contributors](https://img.shields.io/github/contributors/get-woke/woke)](https://github.com/get-woke/woke/graphs/contributors)

## Authors

- **Caitlin Elfring** - [caitlinelfring](https://github.com/caitlinelfring)

See also the list of [contributors](https://github.com/get-woke/woke/contributors) who have participated in this project.

## License

This application is licensed under the MIT License, you may obtain a copy of it
[here](https://github.com/get-woke/woke/blob/main/LICENSE).

[![FOSSA Status](https://app.fossa.com/api/projects/git%2Bgithub.com%2Fget-woke%2Fwoke.svg?type=large)](https://app.fossa.com/projects/git%2Bgithub.com%2Fget-woke%2Fwoke?ref=badge_large)
