#

<p align="center">
<img alt="woke logo" src="https://raw.githubusercontent.com/get-woke/woke/main/assets/default-monochrome.svg" width="200" />
<p align="center">{{ config.site_description }}</p>
</p>

<div align="center">
  <a href="{{config.repo_url}}releases">
    <img alt="GitHub latest release" src="https://img.shields.io/github/v/release/get-woke/woke?logo=github&sort=semver">
  </a>
  <a href="{{config.repo_url}}releases">
    <img alt="GitHub Downloads" src="https://img.shields.io/github/downloads/get-woke/woke/total">
  </a>
  <a href="{{config.repo_url}}blob/main/LICENSE">
    <img alt="License" src="https://img.shields.io/badge/license-MIT-blue.svg">
  </a>
  <a href="https://codecov.io/gh/get-woke/woke/branch/main">
    <img alt="Code Coverage" src="https://codecov.io/gh/get-woke/woke/branch/main/graph/badge.svg?token=BP133BM3HP">
  </a>
  <a href="https://github.com/avelino/awesome-go#other-software">
    <img alt="Mentioned in Awesome Go" src="https://awesome.re/mentioned-badge.svg">
  </a>
</div>

---

## About

Creating an inclusive work environment is imperative to a healthy, supportive, and
productive culture, and an environment where everyone feels welcome and included.

`woke` is a text file analysis tool that finds places within your source code that contain
non-inclusive language and suggests replacing them with more inclusive alternatives.

Companies like [GitHub](https://github.com/github/renaming), [Twitter](https://twitter.com/TwitterEng/status/1278733303508418560), and [Apple](https://developer.apple.com/news/?id=1o9zxsxl) are actively supporting a move to inclusive language.

## Demo

![woke.gif](https://raw.githubusercontent.com/get-woke/get-woke.github.io/main/img/woke.gif)

## Why is this named `woke`?

> When [I](https://github.com/caitlinelfring) started writing `woke` in August 2020, my goal was to build a
> tool that would shed light on non-inclusive language in source code and that would enable a long-term commitment to using inclusive language.
>
> `woke` is a reference to an awareness of social and political issues, especially racial prejudice and discrimination,
> and has a historic use within the African-American community.
> This tool aims to push this kind of awareness even further into the software development community.
>
> I named this project `woke` because I saw it as a tool to awaken our code to non-inclusive language.
>
> You can read more about the origins and history of the word on [Wikipedia](https://en.wikipedia.org/wiki/Woke).

{% include "about.md" %}
