/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef OUTSTREAM_H
#define OUTSTREAM_H
#include <iostream>
#include <fstream>

#include "vec.h"
#include "mat.h"

#include "br.h"
#include "brarr.h"

#include "innd.h"
#include "inndarr.h"

#include "exnd.h"
#include "exndarr.h"


#include "librarr.h"
#include "seqpair.h"

using namespace std;


extern std::ostream &operator << (std::ostream &out, Vec<char> &vec);
extern std::ofstream &operator << (std::ofstream &out, Vec<char> &vec);


class OutStream {
public :

	//=================================================================
	//write a vector
	template <class T, class Tout>
	static Tout &write (Vec<T> &vec, Tout &out) {
		if (sizeof (T) == 1) {
			for (int count_ = 0; count_ < vec.getSize (); count_ ++)
				out << vec[count_];
		} else {
			for (int count_ = 0; count_ < vec.getSize (); count_ ++) {
				out.precision (3);
				out.width (10);
				out << vec[count_];
			}
		}

		return out;
	}

	//=================================================================
	//write a matrix
	template <class T, class Tout>
	static Tout &write (Mat<T> &mat, Tout &out) {
		int row_, col_;
		for (row_ = 0; row_ < mat.getNRow (); row_ ++) {
			for (col_ = 0; col_ < mat.getNCol (); col_ ++) {
				if (sizeof (T) > sizeof (char) ) {
					out.precision (5);
					out.width (10);
				}
				out << mat[row_][col_];
			}
			out << endl;
		}
		out << endl;
		return out;
	}


	//=================================================================
	//write a matrix
	template <class Tout>
	static Tout &write (DMat20 &mat, int nState, Tout &out) {
		int row_, col_;
		for (row_ = 0; row_ < nState; row_ ++) {
			for (col_ = 0; col_ < nState; col_ ++) {
				out.precision (5);
				out.width (10);
				out << mat[row_][col_];
			}

			out << endl;
		}
		out << "===============end of matrix===============" << endl;
		return out;
	}

	//=================================================================
	//write the genetic distances of all two different sequences
	template <class T, class Tout>
	static Tout &writeGenDis (Mat<T> &mat, Tout &out) {
		int seqNo1_, seqNo2_;
		out << mat.getNRow () << endl;
		for (seqNo1_ = 0; seqNo1_ < mat.getNRow (); seqNo1_ ++) {
			out << alignment.getName (seqNo1_) << "         ";
			for (seqNo2_ = 0; seqNo2_ < mat.getNCol (); seqNo2_ ++) {
				out.precision (5);
				//out.width (20);
				out << " " << mat[seqNo1_][seqNo2_];
			}
			out << endl;
		}
		//  out << "===============end of genetic distance matrix===============" << endl;
		return out;
	}

	//-----------------------------------------------------------
	//write all information about this unrooted tree
	template <class T, class Tout>
	static Tout &write (ExNdArr *exNdArr, InNdArr *inNdArr, BrArr<T> *brArr, Tout &out) {
		out << "There are all information of this unrooted tree ..." << endl;
		write (*exNdArr, out);
		write (*inNdArr, out);
		write (*brArr, out);
		out <<"===============end of unrooted tree========================" << endl;
		return out;
	}

	//-----------------------------------------------------------
	//write all information about this optimal unrooted tree
	template <class Tout>
	static Tout &write (ExNdArr *exNdArr, InNdArr *inNdArr, LiBrArr *liBrArr, Tout &out) {
		out << "there are all information of this optimal urooted tree ..." << endl;
		write (*exNdArr, out);
		write (*inNdArr, out);
		write (*liBrArr, out);
		out <<"===============FINISH WRITING THIS OPTIMAL UNROOTED TREE========================" << endl;
		return out;
	}

	//=================================================================
	//write all information of this branch
	template <class T, class Tout>
	static Tout &write (Br<T> &br, Tout &out) {
		/*
		  out << "branch : " << br.getId ();
		  if (br.isEx() == 1)
		    out << "    EX" << endl;
		  else
		    out << "    IN" << endl;
		*/
		int longestSeqNameLen_ = alignment.getLongestSeqNameLen ();

		int headNdNo_ = br.getHeadNd ();
		int tailNdNo_ = br.getTailNd ();
		Vec<char> headSeqName_;
		Vec<char> tailSeqName_;

		alignment.getName (headNdNo_, headSeqName_);
		alignment.getName (tailNdNo_, tailSeqName_);

		int headSeqNameLen_ = headSeqName_.getSize ();
		int tailSeqNameLen_ = tailSeqName_.getSize ();

		out << "(" << headSeqName_<<", ";
		int count_;
		for (count_ = 1; count_ < longestSeqNameLen_ - headSeqNameLen_; count_ ++)
			out << ' ';

		out <<  tailSeqName_<< "):     ";
		for (count_ = 1; count_ < longestSeqNameLen_ - tailSeqNameLen_; count_ ++)
			out << ' ';

		out.precision (7);
		out << br.getLen () << endl;
		return out;
	}

	//=================================================================
	//write all information of this branch
	template <class Tout>
	static Tout &write (LiBr &liBr, Tout &out) {
		/*  out << "branch : " << liBr.getId ();
		  if (liBr.isEx() == 1)
		    out << "    EX";
		  else
		    out << "    IN";
		 
		  if (liBr.isStG () == 1)
		    out << "    StG" << endl;
		  else
		    out << "    GtS" << endl;
		*/
		out << "(" << alignment.getName (liBr.getSmaNd ());

		out << ",  " << alignment.getName (liBr.getGreNd ());
		//  out << ") : " << liBr.getLen () / COF_BR << endl;
		out << ") : " << liBr.getLen ()  << endl;
		return out;
	}

	//=================================================================
	//write all information of this brArr
	template <class T, class Tout>
	static Tout &write (BrArr<T> &brArr, Tout &out) {
		out << "Number of branches: " << brArr.getCurNBr () << endl;
		for (int count_ = 0; count_ < brArr.getMaxNBr (); count_ ++)
			if (brArr[count_].getId () != -1)
				write (brArr[count_], out);
		out << endl;
		return out;
	}

	//=================================================================
	//write all information of this brArr
	template <class Tout>
	static Tout &writeBrLen (LiBrArr &liBrArr, Tout &out) {
		out << "the number of branches: " << liBrArr.getCurNBr () << endl;
		for (int count_ = 0; count_ < liBrArr.getMaxNBr (); count_ ++)
			if (liBrArr[count_].getId () != -1) {
				out.width (12);
				out.precision (5);
				if (liBrArr[count_].isEx () == 1)
					out << -liBrArr[count_].getLen ();
				else
					out << liBrArr[count_].getLen ();
			} // end of if

		out << endl << "==========================end of branch array============================" << endl;
		return out;
	}

	//=================================================================
	//write all information of this inNd
	template <class Tout>
	static Tout &write (InNd &inNd, Tout &out) {
		out << "internal node : " <<  alignment.getName (inNd.getId ()) << endl;

		out << "the neighbor nodes no : ";
		Vec<int> *neiNdNoLs_;
		neiNdNoLs_ = &inNd.getNeiNd ();

		int count_;
		for (count_ = 0; count_ < neiNdNoLs_->getSize (); count_ ++)
			out << alignment.getName ( (*neiNdNoLs_)[count_]) << "  ";
		out << endl;

		out << "the branches no : ";
		Vec<int> *brNoLs_;
		brNoLs_ = &inNd.getBr ();
		for (count_ = 0; count_ < brNoLs_->getSize (); count_ ++)
			out << (*brNoLs_)[count_] << "  ";
		out << endl;

		return out;
	}

	//=================================================================
	//write all information of this inNdArr
	template <class Tout>
	static Tout &write (InNdArr &inNdArr, Tout &out) {
		out << "the number of internal nodes: " << inNdArr.getCurNNd () << endl;
		int maxNExNd_ = inNdArr.getMaxNExNd ();
		int maxNInNd_ = inNdArr.getMaxNNd ();
		for (int count_ = 0; count_ < maxNInNd_; count_ ++)
			if (inNdArr[count_ + maxNExNd_].getId () != -1)
				write (inNdArr[count_ + maxNExNd_], out) << endl;

		out << "==========end of internal node array=====================" << endl;
		return out;
	}

	//=================================================================
	//write all information of this liInNd
	template <class Tout>
	static Tout &write (LiNd &liNd, Tout &out) {
		out << alignment.getName (liNd.getId ()) << endl;

		Vec<int> *exDesNdNoLs_;
		exDesNdNoLs_ = &liNd.getExDesNd ();
		int parNdNo_, parBrNo_;
		liNd.getPar (parNdNo_, parBrNo_);
		out << "par node " << parNdNo_ << " par br " << parBrNo_ << "  ";
		out << "the external descendant nodes : " << exDesNdNoLs_->getSize () << endl;
		for (int count_ = 0; count_ < exDesNdNoLs_->getSize (); count_ ++)
			out << (*exDesNdNoLs_)[count_] << "  ";
		out << endl;
		return out;
	}

	//=================================================================
	//write all information of this brArr
	template <class Tout>
	static Tout &write (LiBrArr &liBrArr, Tout &out) {
		out << "the number of branches: " << liBrArr.getCurNBr () << endl;
		for (int count_ = 0; count_ < liBrArr.getMaxNBr (); count_ ++) {
			LiBr *liBr_;
			liBr_ = &liBrArr[count_];
			if (liBr_->getId () != -1)
				write (*liBr_, out);
		}
		out << "=============end of branch array=====================" << endl;
		return out;
	}


	//=================================================================
	//write all information of this exNd
	template <class Tout>
	static Tout &write (ExNd &exNd, Tout &out) {
		Vec<char> exNdName_;
		exNdName_ = alignment.getName (exNd.getId ());

		Vec<char> inNdName_;
		inNdName_ = alignment.getName (exNd.getInNd ());


		int brNo_ = exNd.getBr ();
		out << exNdName_ << "   " << inNdName_ << "               " << brNo_ << endl;
		return out;
	}

	//=================================================================
	//write all information of this exNdArr
	template <class Tout>
	static Tout &write (ExNdArr &exNdArr, Tout &out) {
		out << "the number of external nodes: " << exNdArr.getCurNNd () << endl;
		int maxNExNd_ = exNdArr.getMaxNNd ();
		for (int count_ = 0; count_ < maxNExNd_; count_ ++)
			if (exNdArr[count_].getId () != -1)
				write (exNdArr[count_], out);
		out << "==========end of external node array======================" << endl;
		return out;
	}

	//=================================================================
	//write all information of this exNdArr
	template <class Tout>
	static Tout &write (Vec<SeqPair> &seqPairArr, Tout &out) {
		int nSeqPair_ = seqPairArr.getSize ();
		out << "The number of independent sequence pairs: " << nSeqPair_ << endl;
		for (int count_ = 0; count_ < nSeqPair_; count_ ++) {
			int seqXNo_ = seqPairArr[count_].seqXNo_;
			int seqYNo_ = seqPairArr[count_].seqYNo_;
			out << "(" << seqXNo_ << "," << seqYNo_ << ")  " << seqPairArr[count_].topDis_ << " : " << seqPairArr[count_].genDis_ << endl;
		}
		out << "==========end of independent sequence pairs======================" << endl;
		return out;
	}

	//--------------------------------------------------------------------
	//release the memory of this class
	void release () {}

	//=================================================================
	//the constructor functionn
	virtual ~OutStream () {
		release ();
		std::cout << "this is the constructor of OutStream class " << endl;


	}

}
; //end ofthe class


#endif
