/* SerialConnection.c generated by valac 0.54.3, the Vala compiler
 * generated from SerialConnection.vala, do not modify */

/*
 *  Copyright (C) 2009-2010 Michael J. Chudobiak.
 *
 *  This file is part of moserial.
 *
 *  moserial is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  moserial is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with moserial.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <glib/gi18n-lib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <sys/ioctl.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MOSERIAL_TYPE_SERIAL_CONNECTION (moserial_serial_connection_get_type ())
#define MOSERIAL_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection))
#define MOSERIAL_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))
#define MOSERIAL_IS_SERIAL_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_IS_SERIAL_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOSERIAL_TYPE_SERIAL_CONNECTION))
#define MOSERIAL_SERIAL_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnectionClass))

typedef struct _moserialSerialConnection moserialSerialConnection;
typedef struct _moserialSerialConnectionClass moserialSerialConnectionClass;
typedef struct _moserialSerialConnectionPrivate moserialSerialConnectionPrivate;
enum  {
	MOSERIAL_SERIAL_CONNECTION_0_PROPERTY,
	MOSERIAL_SERIAL_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* moserial_serial_connection_properties[MOSERIAL_SERIAL_CONNECTION_NUM_PROPERTIES];
typedef enum  {
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_CR,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_LF,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC,
	MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE
} moserialSerialConnectionLineEnd;

#define MOSERIAL_SERIAL_CONNECTION_TYPE_LINE_END (moserial_serial_connection_line_end_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

#define TYPE_SETTINGS (settings_get_type ())
#define SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS, Settings))
#define SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS, SettingsClass))
#define IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS))
#define IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS))
#define SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS, SettingsClass))

typedef struct _Settings Settings;
typedef struct _SettingsClass SettingsClass;
typedef enum  {
	SETTINGS_ACCESS_MODE_READWRITE,
	SETTINGS_ACCESS_MODE_READONLY,
	SETTINGS_ACCESS_MODE_WRITEONLY
} SettingsAccessMode;

#define SETTINGS_TYPE_ACCESS_MODE (settings_access_mode_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	SETTINGS_PARITY_NONE,
	SETTINGS_PARITY_ODD,
	SETTINGS_PARITY_EVEN,
	SETTINGS_PARITY_MARK,
	SETTINGS_PARITY_SPACE
} SettingsParity;

#define SETTINGS_TYPE_PARITY (settings_parity_get_type ())
typedef enum  {
	SETTINGS_HANDSHAKE_NONE,
	SETTINGS_HANDSHAKE_HARDWARE,
	SETTINGS_HANDSHAKE_SOFTWARE,
	SETTINGS_HANDSHAKE_BOTH
} SettingsHandshake;

#define SETTINGS_TYPE_HANDSHAKE (settings_handshake_get_type ())
enum  {
	MOSERIAL_SERIAL_CONNECTION_NEW_DATA_SIGNAL,
	MOSERIAL_SERIAL_CONNECTION_ON_ERROR_SIGNAL,
	MOSERIAL_SERIAL_CONNECTION_NUM_SIGNALS
};
static guint moserial_serial_connection_signals[MOSERIAL_SERIAL_CONNECTION_NUM_SIGNALS] = {0};

struct _moserialSerialConnection {
	GObject parent_instance;
	moserialSerialConnectionPrivate * priv;
	gulong tx;
	gulong rx;
	gulong nonprintable;
	gboolean forced_hex_view;
	gboolean lastRxCharWasCR;
	gchar* echoReference;
	gchar* echoCompare;
};

struct _moserialSerialConnectionClass {
	GObjectClass parent_class;
};

struct _moserialSerialConnectionPrivate {
	gboolean connected;
	struct termios newtio;
	gint m_fd;
	GIOChannel* IOChannelFd;
	gint flags;
	guint* sourceId;
	guint* sourceIdErr;
	guint* sourceIdHup;
	guint* sourceIdNval;
	gboolean localEcho;
};

static gint moserialSerialConnection_private_offset;
static gpointer moserial_serial_connection_parent_class = NULL;

VALA_EXTERN GType moserial_serial_connection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (moserialSerialConnection, g_object_unref)
VALA_EXTERN GType moserial_serial_connection_line_end_get_type (void) G_GNUC_CONST ;
#define MOSERIAL_SERIAL_CONNECTION_max_buf_size 128
VALA_EXTERN GType settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Settings, g_object_unref)
VALA_EXTERN gboolean moserial_serial_connection_doConnect (moserialSerialConnection* self,
                                               Settings* settings);
VALA_EXTERN GType settings_access_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsAccessMode settings_get_accessMode (Settings* self);
VALA_EXTERN const gchar* settings_get_device (Settings* self);
static void moserial_serial_connection_applySettings (moserialSerialConnection* self,
                                               Settings* settings);
static gboolean moserial_serial_connection_readBytes (moserialSerialConnection* self,
                                               GIOChannel* source,
                                               GIOCondition condition);
static gboolean _moserial_serial_connection_readBytes_gio_func (GIOChannel* source,
                                                         GIOCondition condition,
                                                         gpointer self);
static guint* _uint_dup (guint* self);
static gboolean moserial_serial_connection_onUnplugged (moserialSerialConnection* self,
                                                 GIOChannel* source,
                                                 GIOCondition condition);
static gboolean _moserial_serial_connection_onUnplugged_gio_func (GIOChannel* source,
                                                           GIOCondition condition,
                                                           gpointer self);
VALA_EXTERN gboolean settings_get_localEcho (Settings* self);
VALA_EXTERN void moserial_serial_connection_sendByte (moserialSerialConnection* self,
                                          guchar byte);
VALA_EXTERN void moserial_serial_connection_sendBytes (moserialSerialConnection* self,
                                           gchar* bytes,
                                           gint bytes_length1,
                                           gsize size);
VALA_EXTERN void moserial_serial_connection_doDisconnect (moserialSerialConnection* self);
VALA_EXTERN gboolean moserial_serial_connection_isConnected (moserialSerialConnection* self);
VALA_EXTERN gint settings_get_baudRate (Settings* self);
VALA_EXTERN gint settings_get_dataBits (Settings* self);
VALA_EXTERN GType settings_parity_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsParity settings_get_parity (Settings* self);
VALA_EXTERN gint settings_get_stopBits (Settings* self);
VALA_EXTERN GType settings_handshake_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SettingsHandshake settings_get_handshake (Settings* self);
VALA_EXTERN void moserial_serial_connection_controlDTR (moserialSerialConnection* self,
                                            gboolean y);
VALA_EXTERN void moserial_serial_connection_controlRTS (moserialSerialConnection* self,
                                            gboolean y);
VALA_EXTERN gboolean* moserial_serial_connection_getStatus (moserialSerialConnection* self,
                                                gint* result_length1);
static gboolean* _vala_array_dup1 (gboolean* self,
                            gssize length);
VALA_EXTERN gchar* moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self);
VALA_EXTERN moserialSerialConnection* moserial_serial_connection_new (void);
VALA_EXTERN moserialSerialConnection* moserial_serial_connection_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void moserial_serial_connection_finalize (GObject * obj);
static GType moserial_serial_connection_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gchar* MOSERIAL_SERIAL_CONNECTION_LineEndStrings[6] = {N_ ("CR+LF end"), N_ ("CR end"), N_ ("LF end"), N_ ("TAB end"), N_ ("ESC end"), N_ ("No end")};
const gchar* MOSERIAL_SERIAL_CONNECTION_LineEndValues[6] = {"\r\n", "\r", "\n", "\t", "\x1b", ""};

static inline gpointer
moserial_serial_connection_get_instance_private (moserialSerialConnection* self)
{
	return G_STRUCT_MEMBER_P (self, moserialSerialConnection_private_offset);
}

static GType
moserial_serial_connection_line_end_get_type_once (void)
{
	static const GEnumValue values[] = {{MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CRLF", "crlf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_CR, "MOSERIAL_SERIAL_CONNECTION_LINE_END_CR", "cr"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_LF, "MOSERIAL_SERIAL_CONNECTION_LINE_END_LF", "lf"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB, "MOSERIAL_SERIAL_CONNECTION_LINE_END_TAB", "tab"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC, "MOSERIAL_SERIAL_CONNECTION_LINE_END_ESC", "esc"}, {MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE, "MOSERIAL_SERIAL_CONNECTION_LINE_END_NONE", "none"}, {0, NULL, NULL}};
	GType moserial_serial_connection_line_end_type_id;
	moserial_serial_connection_line_end_type_id = g_enum_register_static ("moserialSerialConnectionLineEnd", values);
	return moserial_serial_connection_line_end_type_id;
}

GType
moserial_serial_connection_line_end_get_type (void)
{
	static volatile gsize moserial_serial_connection_line_end_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_serial_connection_line_end_type_id__volatile)) {
		GType moserial_serial_connection_line_end_type_id;
		moserial_serial_connection_line_end_type_id = moserial_serial_connection_line_end_get_type_once ();
		g_once_init_leave (&moserial_serial_connection_line_end_type_id__volatile, moserial_serial_connection_line_end_type_id);
	}
	return moserial_serial_connection_line_end_type_id__volatile;
}

static gboolean
_moserial_serial_connection_readBytes_gio_func (GIOChannel* source,
                                                GIOCondition condition,
                                                gpointer self)
{
	gboolean result;
	result = moserial_serial_connection_readBytes ((moserialSerialConnection*) self, source, condition);
	return result;
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static gboolean
_moserial_serial_connection_onUnplugged_gio_func (GIOChannel* source,
                                                  GIOCondition condition,
                                                  gpointer self)
{
	gboolean result;
	result = moserial_serial_connection_onUnplugged ((moserialSerialConnection*) self, source, condition);
	return result;
}

gboolean
moserial_serial_connection_doConnect (moserialSerialConnection* self,
                                      Settings* settings)
{
	SettingsAccessMode _tmp0_;
	SettingsAccessMode _tmp1_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	struct termios _tmp6_;
	GIOChannel* _tmp7_;
	GIOChannel* _tmp8_;
	guint _tmp9_;
	guint* _tmp10_;
	GIOChannel* _tmp11_;
	guint _tmp12_;
	guint* _tmp13_;
	GIOChannel* _tmp14_;
	guint _tmp15_;
	guint* _tmp16_;
	GIOChannel* _tmp17_;
	guint _tmp18_;
	guint* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (settings != NULL, FALSE);
	_tmp0_ = settings_get_accessMode (settings);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == SETTINGS_ACCESS_MODE_READWRITE) {
		self->priv->flags = O_RDWR;
	} else {
		SettingsAccessMode _tmp2_;
		SettingsAccessMode _tmp3_;
		_tmp2_ = settings_get_accessMode (settings);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == SETTINGS_ACCESS_MODE_READONLY) {
			self->priv->flags = O_RDONLY;
		} else {
			self->priv->flags = O_WRONLY;
		}
	}
	_tmp4_ = settings_get_device (settings);
	_tmp5_ = _tmp4_;
	self->priv->m_fd = open (_tmp5_, self->priv->flags | O_NONBLOCK, (mode_t) 0);
	if (self->priv->m_fd < 0) {
		self->priv->m_fd = -1;
		result = FALSE;
		return result;
	}
	tcflush (self->priv->m_fd, TCIOFLUSH);
	moserial_serial_connection_applySettings (self, settings);
	_tmp6_ = self->priv->newtio;
	tcsetattr (self->priv->m_fd, TCSANOW, &_tmp6_);
	self->priv->connected = TRUE;
	_tmp7_ = g_io_channel_unix_new (self->priv->m_fd);
	_g_io_channel_unref0 (self->priv->IOChannelFd);
	self->priv->IOChannelFd = _tmp7_;
	_tmp8_ = self->priv->IOChannelFd;
	_tmp9_ = g_io_add_watch (_tmp8_, G_IO_IN, _moserial_serial_connection_readBytes_gio_func, self);
	_tmp10_ = __uint_dup0 (&_tmp9_);
	_g_free0 (self->priv->sourceId);
	self->priv->sourceId = _tmp10_;
	_tmp11_ = self->priv->IOChannelFd;
	_tmp12_ = g_io_add_watch (_tmp11_, G_IO_ERR, _moserial_serial_connection_onUnplugged_gio_func, self);
	_tmp13_ = __uint_dup0 (&_tmp12_);
	_g_free0 (self->priv->sourceIdErr);
	self->priv->sourceIdErr = _tmp13_;
	_tmp14_ = self->priv->IOChannelFd;
	_tmp15_ = g_io_add_watch (_tmp14_, G_IO_HUP, _moserial_serial_connection_onUnplugged_gio_func, self);
	_tmp16_ = __uint_dup0 (&_tmp15_);
	_g_free0 (self->priv->sourceIdHup);
	self->priv->sourceIdHup = _tmp16_;
	_tmp17_ = self->priv->IOChannelFd;
	_tmp18_ = g_io_add_watch (_tmp17_, G_IO_NVAL, _moserial_serial_connection_onUnplugged_gio_func, self);
	_tmp19_ = __uint_dup0 (&_tmp18_);
	_g_free0 (self->priv->sourceIdNval);
	self->priv->sourceIdNval = _tmp19_;
	_tmp20_ = settings_get_localEcho (settings);
	_tmp21_ = _tmp20_;
	self->priv->localEcho = _tmp21_;
	result = TRUE;
	return result;
}

void
moserial_serial_connection_sendByte (moserialSerialConnection* self,
                                     guchar byte)
{
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		guchar* b = NULL;
		guchar* _tmp0_;
		gint b_length1;
		gint _b_size_;
		guchar* _tmp1_;
		gint _tmp1__length1;
		gsize x = 0UL;
		guchar* _tmp2_;
		gint _tmp2__length1;
		_tmp0_ = g_new0 (guchar, 1);
		b = _tmp0_;
		b_length1 = 1;
		_b_size_ = b_length1;
		_tmp1_ = b;
		_tmp1__length1 = b_length1;
		_tmp1_[0] = byte;
		_tmp2_ = b;
		_tmp2__length1 = b_length1;
		x = (gsize) write (self->priv->m_fd, _tmp2_, (gsize) 1);
		self->tx = self->tx + x;
		b = (g_free (b), NULL);
	}
}

void
moserial_serial_connection_sendBytes (moserialSerialConnection* self,
                                      gchar* bytes,
                                      gint bytes_length1,
                                      gsize size)
{
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		gsize x = 0UL;
		x = (gsize) write (self->priv->m_fd, bytes, size);
		tcdrain (self->priv->m_fd);
		self->tx = self->tx + x;
	}
}

void
moserial_serial_connection_doDisconnect (moserialSerialConnection* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->connected) {
		guint* _tmp0_;
		guint* _tmp1_;
		guint* _tmp2_;
		guint* _tmp3_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		struct termios _tmp9_;
		_tmp0_ = self->priv->sourceId;
		g_source_remove (*_tmp0_);
		_tmp1_ = self->priv->sourceIdHup;
		g_source_remove (*_tmp1_);
		_tmp2_ = self->priv->sourceIdErr;
		g_source_remove (*_tmp2_);
		_tmp3_ = self->priv->sourceIdNval;
		g_source_remove (*_tmp3_);
		_g_free0 (self->priv->sourceId);
		self->priv->sourceId = NULL;
		_g_free0 (self->priv->sourceIdHup);
		self->priv->sourceIdHup = NULL;
		_g_free0 (self->priv->sourceIdErr);
		self->priv->sourceIdErr = NULL;
		_g_free0 (self->priv->sourceIdNval);
		self->priv->sourceIdNval = NULL;
		{
			GIOChannel* _tmp4_;
			_tmp4_ = self->priv->IOChannelFd;
			g_io_channel_shutdown (_tmp4_, TRUE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_IO_CHANNEL_ERROR) {
					goto __catch0_g_io_channel_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_g_io_channel_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("SerialConnection.vala:130: %s", _tmp6_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_io_channel_unref0 (self->priv->IOChannelFd);
		self->priv->IOChannelFd = NULL;
		self->priv->connected = FALSE;
		self->forced_hex_view = FALSE;
		self->lastRxCharWasCR = FALSE;
		self->nonprintable = (gulong) 0;
		self->rx = self->nonprintable;
		self->tx = self->rx;
		_tmp7_ = g_strdup ("");
		_g_free0 (self->echoReference);
		self->echoReference = _tmp7_;
		_tmp8_ = g_strdup ("");
		_g_free0 (self->echoCompare);
		self->echoCompare = _tmp8_;
		_tmp9_ = self->priv->newtio;
		tcsetattr (self->priv->m_fd, TCSANOW, &_tmp9_);
		close (self->priv->m_fd);
	}
}

gboolean
moserial_serial_connection_isConnected (moserialSerialConnection* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->connected;
	return result;
}

static gboolean
moserial_serial_connection_onUnplugged (moserialSerialConnection* self,
                                        GIOChannel* source,
                                        GIOCondition condition)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_signal_emit (self, moserial_serial_connection_signals[MOSERIAL_SERIAL_CONNECTION_ON_ERROR_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
moserial_serial_connection_readBytes (moserialSerialConnection* self,
                                      GIOChannel* source,
                                      GIOCondition condition)
{
	guchar* m_buf = NULL;
	guchar* _tmp0_;
	gint m_buf_length1;
	gint _m_buf_size_;
	gint bytesRead = 0;
	guchar* _tmp1_;
	gint _tmp1__length1;
	guchar* sized_buf = NULL;
	guchar* _tmp3_;
	gint sized_buf_length1;
	gint _sized_buf_size_;
	guchar* _tmp9_;
	gint _tmp9__length1;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = g_new0 (guchar, MOSERIAL_SERIAL_CONNECTION_max_buf_size);
	m_buf = _tmp0_;
	m_buf_length1 = MOSERIAL_SERIAL_CONNECTION_max_buf_size;
	_m_buf_size_ = m_buf_length1;
	_tmp1_ = m_buf;
	_tmp1__length1 = m_buf_length1;
	bytesRead = (gint) read (self->priv->m_fd, _tmp1_, (gsize) MOSERIAL_SERIAL_CONNECTION_max_buf_size);
	self->rx = self->rx + ((gulong) bytesRead);
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		if (gtk_events_pending ()) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = gdk_events_pending ();
		}
		if (!_tmp2_) {
			break;
		}
		gtk_main_iteration_do (FALSE);
	}
	if (bytesRead < 0) {
		result = FALSE;
		m_buf = (g_free (m_buf), NULL);
		return result;
	}
	_tmp3_ = g_new0 (guchar, bytesRead);
	sized_buf = _tmp3_;
	sized_buf_length1 = bytesRead;
	_sized_buf_size_ = sized_buf_length1;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				guchar* _tmp6_;
				gint _tmp6__length1;
				guchar* _tmp7_;
				gint _tmp7__length1;
				guchar _tmp8_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = x;
					x = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(x < bytesRead)) {
					break;
				}
				_tmp6_ = sized_buf;
				_tmp6__length1 = sized_buf_length1;
				_tmp7_ = m_buf;
				_tmp7__length1 = m_buf_length1;
				_tmp8_ = _tmp7_[x];
				_tmp6_[x] = _tmp8_;
			}
		}
	}
	_tmp9_ = sized_buf;
	_tmp9__length1 = sized_buf_length1;
	g_signal_emit (self, moserial_serial_connection_signals[MOSERIAL_SERIAL_CONNECTION_NEW_DATA_SIGNAL], 0, _tmp9_, (gint) _tmp9__length1, bytesRead);
	if (self->priv->localEcho) {
		guchar* _tmp10_;
		gint _tmp10__length1;
		_tmp10_ = sized_buf;
		_tmp10__length1 = sized_buf_length1;
		moserial_serial_connection_sendBytes (self, (gchar*) _tmp10_, (gint) ((_tmp10__length1 * sizeof (guchar)) / sizeof (gchar)), (gsize) bytesRead);
	}
	result = self->priv->connected;
	sized_buf = (g_free (sized_buf), NULL);
	m_buf = (g_free (m_buf), NULL);
	return result;
}

static void
moserial_serial_connection_applySettings (moserialSerialConnection* self,
                                          Settings* settings)
{
	guint baudRate = 0U;
	gint _tmp0_;
	gint _tmp1_;
	gint dataBits = 0;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_;
	gint _tmp8_;
	SettingsParity _tmp18_;
	SettingsParity _tmp19_;
	gint _tmp22_;
	gint _tmp23_;
	gboolean _tmp24_ = FALSE;
	SettingsHandshake _tmp25_;
	SettingsHandshake _tmp26_;
	gboolean _tmp29_ = FALSE;
	SettingsHandshake _tmp30_;
	SettingsHandshake _tmp31_;
	gint mcs = 0;
	gint _tmp34_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	baudRate = (guint) 0;
	_tmp0_ = settings_get_baudRate (settings);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case 300:
		{
			baudRate = (guint) B300;
			break;
		}
		case 600:
		{
			baudRate = (guint) B600;
			break;
		}
		case 1200:
		{
			baudRate = (guint) B1200;
			break;
		}
		case 2400:
		{
			baudRate = (guint) B2400;
			break;
		}
		case 4800:
		{
			baudRate = (guint) B4800;
			break;
		}
		case 9600:
		{
			baudRate = (guint) B9600;
			break;
		}
		case 19200:
		{
			baudRate = (guint) B19200;
			break;
		}
		case 38400:
		{
			baudRate = (guint) B38400;
			break;
		}
		case 57600:
		{
			baudRate = (guint) B57600;
			break;
		}
		case 115200:
		{
			baudRate = (guint) B115200;
			break;
		}
		case 230400:
		{
			baudRate = (guint) B230400;
			break;
		}
		case 460800:
		{
			baudRate = (guint) B460800;
			break;
		}
		case 576000:
		{
			baudRate = (guint) B576000;
			break;
		}
		case 921600:
		{
			baudRate = (guint) B921600;
			break;
		}
		case 1000000:
		{
			baudRate = (guint) B1000000;
			break;
		}
		case 2000000:
		{
			baudRate = (guint) B2000000;
			break;
		}
		case 3000000:
		{
			baudRate = (guint) B3000000;
			break;
		}
		default:
		{
			gint _tmp2_;
			gint _tmp3_;
			_tmp2_ = settings_get_baudRate (settings);
			_tmp3_ = _tmp2_;
			baudRate = (guint) _tmp3_;
			break;
		}
	}
	cfsetospeed (&self->priv->newtio, (speed_t) baudRate);
	cfsetispeed (&self->priv->newtio, (speed_t) baudRate);
	cfmakeraw (&self->priv->newtio);
	self->priv->newtio.c_cc[VTIME] = (cc_t) 0;
	self->priv->newtio.c_cc[VMIN] = (cc_t) 1;
	_tmp4_ = settings_get_dataBits (settings);
	_tmp5_ = _tmp4_;
	dataBits = _tmp5_;
	_tmp7_ = settings_get_dataBits (settings);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 7) {
		gboolean _tmp9_ = FALSE;
		SettingsParity _tmp10_;
		SettingsParity _tmp11_;
		_tmp10_ = settings_get_parity (settings);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == SETTINGS_PARITY_MARK) {
			_tmp9_ = TRUE;
		} else {
			SettingsParity _tmp12_;
			SettingsParity _tmp13_;
			_tmp12_ = settings_get_parity (settings);
			_tmp13_ = _tmp12_;
			_tmp9_ = _tmp13_ == SETTINGS_PARITY_SPACE;
		}
		_tmp6_ = _tmp9_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		dataBits = 8;
	}
	switch (dataBits) {
		case 5:
		{
			struct termios _tmp14_;
			_tmp14_ = self->priv->newtio;
			self->priv->newtio.c_cflag = (_tmp14_.c_cflag & (~CSIZE)) | CS5;
			break;
		}
		case 6:
		{
			struct termios _tmp15_;
			_tmp15_ = self->priv->newtio;
			self->priv->newtio.c_cflag = (_tmp15_.c_cflag & (~CSIZE)) | CS6;
			break;
		}
		case 7:
		{
			struct termios _tmp16_;
			_tmp16_ = self->priv->newtio;
			self->priv->newtio.c_cflag = (_tmp16_.c_cflag & (~CSIZE)) | CS7;
			break;
		}
		default:
		case 8:
		{
			struct termios _tmp17_;
			_tmp17_ = self->priv->newtio;
			self->priv->newtio.c_cflag = (_tmp17_.c_cflag & (~CSIZE)) | CS8;
			break;
		}
	}
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | (CLOCAL | CREAD);
	self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~(PARENB | PARODD));
	_tmp18_ = settings_get_parity (settings);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == SETTINGS_PARITY_EVEN) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | PARENB;
	} else {
		SettingsParity _tmp20_;
		SettingsParity _tmp21_;
		_tmp20_ = settings_get_parity (settings);
		_tmp21_ = _tmp20_;
		if (_tmp21_ == SETTINGS_PARITY_ODD) {
			self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | (PARENB | PARODD);
		}
	}
	_tmp22_ = settings_get_stopBits (settings);
	_tmp23_ = _tmp22_;
	if (_tmp23_ == 2) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | CSTOPB;
	} else {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CSTOPB);
	}
	_tmp25_ = settings_get_handshake (settings);
	_tmp26_ = _tmp25_;
	if (_tmp26_ == SETTINGS_HANDSHAKE_SOFTWARE) {
		_tmp24_ = TRUE;
	} else {
		SettingsHandshake _tmp27_;
		SettingsHandshake _tmp28_;
		_tmp27_ = settings_get_handshake (settings);
		_tmp28_ = _tmp27_;
		_tmp24_ = _tmp28_ == SETTINGS_HANDSHAKE_BOTH;
	}
	if (_tmp24_) {
		self->priv->newtio.c_iflag = self->priv->newtio.c_iflag | (IXON | IXOFF);
	} else {
		self->priv->newtio.c_iflag = self->priv->newtio.c_iflag & (~((IXON | IXOFF) | IXANY));
	}
	_tmp30_ = settings_get_handshake (settings);
	_tmp31_ = _tmp30_;
	if (_tmp31_ == SETTINGS_HANDSHAKE_HARDWARE) {
		_tmp29_ = TRUE;
	} else {
		SettingsHandshake _tmp32_;
		SettingsHandshake _tmp33_;
		_tmp32_ = settings_get_handshake (settings);
		_tmp33_ = _tmp32_;
		_tmp29_ = _tmp33_ == SETTINGS_HANDSHAKE_BOTH;
	}
	if (_tmp29_) {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag | CRTSCTS;
	} else {
		self->priv->newtio.c_cflag = self->priv->newtio.c_cflag & (~CRTSCTS);
	}
	mcs = 0;
	ioctl (self->priv->m_fd, TIOCMGET, &_tmp34_);
	mcs = _tmp34_;
	mcs |= TIOCM_RTS | TIOCM_DTR;
	ioctl (self->priv->m_fd, TIOCMSET, &mcs);
}

void
moserial_serial_connection_controlDTR (moserialSerialConnection* self,
                                       gboolean y)
{
	gint mcs = 0;
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	mcs = 0;
	ioctl (self->priv->m_fd, TIOCMGET, &_tmp0_);
	mcs = _tmp0_;
	if (y) {
		mcs |= TIOCM_DTR;
	} else {
		mcs &= ~TIOCM_DTR;
	}
	ioctl (self->priv->m_fd, TIOCMSET, &mcs);
}

void
moserial_serial_connection_controlRTS (moserialSerialConnection* self,
                                       gboolean y)
{
	gint mcs = 0;
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	mcs = 0;
	ioctl (self->priv->m_fd, TIOCMGET, &_tmp0_);
	mcs = _tmp0_;
	if (y) {
		mcs |= TIOCM_RTS;
	} else {
		mcs &= ~TIOCM_RTS;
	}
	ioctl (self->priv->m_fd, TIOCMSET, &mcs);
}

static gboolean*
_vala_array_dup1 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

gboolean*
moserial_serial_connection_getStatus (moserialSerialConnection* self,
                                      gint* result_length1)
{
	gboolean mcs[6] = {0};
	gint stat = 0;
	gint _tmp0_ = 0;
	gboolean* _tmp1_;
	gint _tmp1__length1;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gboolean* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	ioctl (self->priv->m_fd, TIOCMGET, &_tmp0_);
	stat = _tmp0_;
	if ((stat & 0x080) == 0) {
		mcs[0] = FALSE;
	} else {
		mcs[0] = TRUE;
	}
	if ((stat & TIOCM_DSR) == 0) {
		mcs[1] = FALSE;
	} else {
		mcs[1] = TRUE;
	}
	if ((stat & 0x040) == 0) {
		mcs[2] = FALSE;
	} else {
		mcs[2] = TRUE;
	}
	if ((stat & TIOCM_CTS) == 0) {
		mcs[3] = FALSE;
	} else {
		mcs[3] = TRUE;
	}
	if ((stat & TIOCM_RTS) == 0) {
		mcs[4] = FALSE;
	} else {
		mcs[4] = TRUE;
	}
	if ((stat & TIOCM_DTR) == 0) {
		mcs[5] = FALSE;
	} else {
		mcs[5] = TRUE;
	}
	_tmp1_ = _vala_array_dup1 (mcs, 6);
	_tmp1__length1 = 6;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gchar*
moserial_serial_connection_getBytecountbarString (moserialSerialConnection* self)
{
	gchar* r = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->nonprintable > ((gulong) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf (_ ("TX: %lu, RX: %lu (%lu unprintable)"), self->tx, self->rx, self->nonprintable);
		_g_free0 (r);
		r = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup_printf (_ ("TX: %lu, RX: %lu"), self->tx, self->rx);
		_g_free0 (r);
		r = _tmp1_;
	}
	result = r;
	return result;
}

moserialSerialConnection*
moserial_serial_connection_construct (GType object_type)
{
	moserialSerialConnection * self = NULL;
	self = (moserialSerialConnection*) g_object_new (object_type, NULL);
	return self;
}

moserialSerialConnection*
moserial_serial_connection_new (void)
{
	return moserial_serial_connection_construct (MOSERIAL_TYPE_SERIAL_CONNECTION);
}

static void
g_cclosure_user_marshal_VOID__POINTER_INT_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__POINTER_INT_INT) (gpointer data1, gpointer arg_1, gint arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static void
moserial_serial_connection_class_init (moserialSerialConnectionClass * klass,
                                       gpointer klass_data)
{
	moserial_serial_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &moserialSerialConnection_private_offset);
	G_OBJECT_CLASS (klass)->finalize = moserial_serial_connection_finalize;
	moserial_serial_connection_signals[MOSERIAL_SERIAL_CONNECTION_NEW_DATA_SIGNAL] = g_signal_new ("new-data", MOSERIAL_TYPE_SERIAL_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_INT, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_INT);
	moserial_serial_connection_signals[MOSERIAL_SERIAL_CONNECTION_ON_ERROR_SIGNAL] = g_signal_new ("on-error", MOSERIAL_TYPE_SERIAL_CONNECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
moserial_serial_connection_instance_init (moserialSerialConnection * self,
                                          gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = moserial_serial_connection_get_instance_private (self);
	self->tx = (gulong) 0;
	self->rx = (gulong) 0;
	self->nonprintable = (gulong) 0;
	self->forced_hex_view = FALSE;
	self->lastRxCharWasCR = FALSE;
	_tmp0_ = g_strdup ("");
	self->echoReference = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->echoCompare = _tmp1_;
	self->priv->m_fd = -1;
	self->priv->flags = 0;
}

static void
moserial_serial_connection_finalize (GObject * obj)
{
	moserialSerialConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOSERIAL_TYPE_SERIAL_CONNECTION, moserialSerialConnection);
	_g_free0 (self->echoReference);
	_g_free0 (self->echoCompare);
	_g_io_channel_unref0 (self->priv->IOChannelFd);
	_g_free0 (self->priv->sourceId);
	_g_free0 (self->priv->sourceIdErr);
	_g_free0 (self->priv->sourceIdHup);
	_g_free0 (self->priv->sourceIdNval);
	G_OBJECT_CLASS (moserial_serial_connection_parent_class)->finalize (obj);
}

static GType
moserial_serial_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (moserialSerialConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) moserial_serial_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (moserialSerialConnection), 0, (GInstanceInitFunc) moserial_serial_connection_instance_init, NULL };
	GType moserial_serial_connection_type_id;
	moserial_serial_connection_type_id = g_type_register_static (G_TYPE_OBJECT, "moserialSerialConnection", &g_define_type_info, 0);
	moserialSerialConnection_private_offset = g_type_add_instance_private (moserial_serial_connection_type_id, sizeof (moserialSerialConnectionPrivate));
	return moserial_serial_connection_type_id;
}

GType
moserial_serial_connection_get_type (void)
{
	static volatile gsize moserial_serial_connection_type_id__volatile = 0;
	if (g_once_init_enter (&moserial_serial_connection_type_id__volatile)) {
		GType moserial_serial_connection_type_id;
		moserial_serial_connection_type_id = moserial_serial_connection_get_type_once ();
		g_once_init_leave (&moserial_serial_connection_type_id__volatile, moserial_serial_connection_type_id);
	}
	return moserial_serial_connection_type_id__volatile;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

