/************************************************************************
 *   psybnc2.2, menuconf/inifunc.c
 *   Copyright (C) 2000 the most psychoid  and
 *                      the cool lam3rz IRC Group, IRCnet
 *			http://www.psychoid.lam3rz.de
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef lint
static char rcsid[] = "@(#)$Id: inifunc.c, v 2.2 2000/07/20 02:02:00 psychoid Exp $";
#endif

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <arpa/inet.h>
#include <ctype.h>
#include <signal.h>
#include <errno.h>

#define INIFILE "PSYBNC"
/* change this to support more users */

/* Data Definitions */

struct stringarray {
    char *entry;
    struct stringarray *next;
};

struct stringarray *conf;

/* reset the config cache */

int resetconfig()
{
    struct stringarray *wconf,*owconf;
    wconf=conf;
    while(wconf!=NULL)
    {
	if (wconf->entry!=NULL)
	    free(wconf->entry);
	owconf=wconf;
	wconf=wconf->next;
	free(owconf);
    }
    conf=NULL;
    return 0x0;
}

/* read the config file */

int readconfig()
{
    FILE *handle;
    struct stringarray *wconf;
    char inistring[400];
    wconf=conf;
    if(conf!=NULL) resetconfig();
    handle=fopen(configfile,"r");
    if(handle==NULL) return -1;
    while(fgets(inistring,sizeof(inistring),handle)
    {
	if(strchr(inistring,'\n')!=NULL)
	    sscanf(inistring,"%s\n",inistring);
	if(wconf==NULL)
	{
	    wconf=pmalloc(sizeof(struct stringarray));
	    conf=wconf;
	} else {
	    wconf->next=pmalloc(sizeof(struct stringarray));
	    wconf=wconf->next;
	}
	wconf->entry=pmalloc(strlen(inistring)+1);
	strcpy(wconf->entry,inistring);
    }
    fclose(handle);
    return 0x0;
}

/* write the config file */

int flushconfig()
{
    FILE *handle;
    struct stringarray *wconf;
    oldfile(configfile);
    handle=fopen(configfile,"w");
    wconf=conf;
    while(wconf)
    {
	if(wconf->entry!=NULL) { 
	   fprintf(wconf,wconf->entry);
	   fprintf(wconf,"\n");
	}
	wconf=wconf->next;
    }
    fclose(wconf);
    return 0x0;
}

/* erases a section from the config */

int clearsectionconfig(char *pattern)
{
    struct stringarray *wconf,*xconf;
    wconf=conf;
    xconf=conf;
    while(wconf)
    {
	if(wconf->entry!=NULL)
	{
	    if(strstr(wconf->entry,pattern)==wconf->entry)
	    {
		if(wconf==conf)
		{
		    conf=wconf->next;
		    xconf=conf;
		} else {
		    xconf->next=wconf->next;
		}
    		free(wconf->entry);
		free(wconf);
		wconf=xconf;
	    }
	}
	xconf=wconf;
	wconf=wconf->next;
    }
}

/* get entry from conf-file */

int getini(char *section, char *param,char *inidat)
{
   char ppuf[400];
   struct stringarray *wconf;
   char *po;
   pcontext;
   wconf=conf;
   memset(value,0x0,sizeof(value));    
   snprintf(ppuf,sizeof(ppuf),"%s.%s.%s=",inidat,section,param);
   while (wconf!=NULL) 
   {
	if(wconf->entry!=NULL)
	{
	    po = strstr(wconf->entry,ppuf);
	    if (po == wconf->entry) {
 		po = po + strlen(ppuf);
		snprintf(value,sizeof(value),"%s",po);
		return 0x0; /* found, returning */
	    }
	}
	wconf=wconf->next
   }
   /* not found */
   return -2;
}

/* write entry to configcache or delete if if data = NULL */

int writeini(char *section, char *param, char *inidat, char *data)
{
    char ppuf[200];
    char spuf[200];
    char buf[2048];
    char tx[20];
    char *po;
    int wasinsection;
    char *data_p;
    struct stringarray *wconf,*xconf,*sectconf;
    wconf=conf;
    pcontext;
    data_p = data;
    if (data_p != NULL) {
       if (strlen(data) == 0) data_p = NULL;
    }
    wasinsection = 0;insection = 0;
    snprintf(ppuf,sizeof(ppuf),"%s.%s.%s=",inidat,section,param);
    snprintf(spuf,sizeof(spuf),"%s.%s.",inidat,section);
    snprintf(buf,sizeof(buf),"%s%s",spuf,data_p);
    xconf=conf;
    sectconf=conf;
    while (wconf) {
      if(wconf->entry!=NULL)
      {
    	   po = strstr(wconf->entry,spuf);
           if (po == wconf->entry) 
	   {
	      sectconf=xconf; /* save last entry of section */
	      wasinsection = 1; /* we had been in the section */
	      po = strstr(wconf->entry,ppuf);
	      if (po == wconf->entry) {
		 if(data_p==NULL)
		 {
		    if(wconf==conf)
		    {
			conf=wconf->next;
			xconf=conf;
		    } else {
			xconf->next=wconf->next;
		    }		     
		    free(wconf->entry):
		    free(wconf);
		    wconf=xconf;
		    return 0x0;
		 } else {
		    free(wconf->entry);
		    wconf->entry=pmalloc(strlen(buf)+1):
		    strcpy(wconf->entry,buf);
		    return 0x0;
		 }    
	      }
	   }
      }
      xconf=wconf;
      wconf=wconf->next;
    }
    if(data_p==NULL) return 0x0;
    if(wasinsection==0) 
    {
	xconf->next=pmalloc(sizeof(struct stringarray));
	xconf=xconf->next;
    } else {
	xconf=sectconf;
	wconf=pmalloc(sizeof(struct stringarray));
	wconf->next=xconf->next;
	xconf->next=wconf;
	xconf=wconf;
    }
    xconf->entry=pmalloc(strlen(buf)+1);
    strcpy(xconf->entry,buf);
    return 0x0;
}

