#include "translation/common.h"
#include "translation/translation.h"

static translation_string all_strings[] = {
    {TR_NO_PATCH_TITLE, "Uppdatering 1.0.1.0 inte installerad"},
    {TR_NO_PATCH_MESSAGE,
        "Din Caesar 3-installation har inte uppdatering 1.0.1.0 installerad. "
        "Du kan ladda ner installationen från:\n"
        URL_PATCHES "\n"
        "Fortsätt på egen risk."},
    {TR_MISSING_FONTS_TITLE, "Saknade typsnitt"},
    {TR_MISSING_FONTS_MESSAGE,
        "Din Caesar 3-installation behöver extra typsnittsfiler. "
        "Du kan ladda ner dem för ditt språk från:\n"
    URL_PATCHES},
    {TR_NO_EDITOR_TITLE, "Redigeringsverktyg inte installerade"},
    {TR_NO_EDITOR_MESSAGE,
        "Din Caesar 3-installation saknar redigeringsfilerna. "
        "Du kan ladda ner dom från:\n"
    URL_EDITOR},
    {TR_INVALID_LANGUAGE_TITLE, "Ogiltig språkmapp"},
    {TR_INVALID_LANGUAGE_MESSAGE,
        "Den valda mappen innehåller inte ett giltigt språkpaket. "
        "Kolla i loggen efter fel."},
    {TR_BUILD_ALL_TEMPLES, "Alla"},
    {TR_BUTTON_OK, "OK"},
    {TR_BUTTON_CANCEL, "Avbryt"},
    {TR_BUTTON_RESET_DEFAULTS, "Återställ förval"},
    {TR_BUTTON_CONFIGURE_HOTKEYS, "Kortkommando"},		  
    {TR_CONFIG_TITLE, "Augustus-konfigurationer"},
	{TR_CONFIG_ARE_YOU_SURE, "Återställ standardvärden?"},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_CONFIGS, "Alla anpassade konfigurationer kommer gå förlorade."},
    {TR_CONFIG_YOU_WILL_LOSE_YOUR_HOTKEYS, "Alla anpassade kortkommandon kommer gå förlorade."},
    {TR_CONFIG_HEADER_GENERAL, "Generelt"},
    {TR_CONFIG_HEADER_GAMEPLAY_CHANGES, "Svårighetsgrad"},
    {TR_CONFIG_HEADER_CITY_MANAGEMENT_CHANGES, "Stadsförvaltning"},															  
    {TR_CONFIG_LANGUAGE_LABEL, "Språk:"},
    {TR_CONFIG_LANGUAGE_DEFAULT, "(förval)"},			   
	{TR_CONFIG_GAME_SPEED, "Spelhastighet:"},
    {TR_CONFIG_VIDEO, "Videoinställningar"},
    {TR_CONFIG_FULLSCREEN, "Fullskärm"},
    {TR_CONFIG_WINDOWED_RESOLUTION, "Fönsterlägesskala:"},														
    {TR_CONFIG_DISPLAY_SCALE, "Bildskärmsskala:"},
    {TR_CONFIG_CURSOR_SCALE, "Markörskala:"},
    {TR_CONFIG_HEADER_UI_CHANGES, "Gränssnitt"},
	{TR_CONFIG_AUDIO, "Ljudinställningar"},
    {TR_CONFIG_VOLUME, "Volym"},
    {TR_CONFIG_ENABLE_AUDIO, "Slå på ljud"},
    {TR_CONFIG_MUSIC, "Slå på musik"},
    {TR_CONFIG_SPEECH, "Slå på tal"},
    {TR_CONFIG_EFFECTS, "Slå på ljudeffekter"},
    {TR_CONFIG_CITY_SOUNDS, "Slå på stadsljud"},
	{TR_CONFIG_VIDEO_SOUND, "Slå på filmljud"},											  
    {TR_CONFIG_SCROLL_SPEED, "Skrollhastighet:"},										  
    {TR_CONFIG_SHOW_INTRO_VIDEO, "Visa inledningsfilmer"},
    {TR_CONFIG_SIDEBAR_INFO, "Extra information i kontrollpanelen"},
    {TR_CONFIG_SMOOTH_SCROLLING, "Mjuk skrollning"},										  
	{TR_CONFIG_DISABLE_MOUSE_EDGE_SCROLLING, "Stäng av förflyttning av kartan vid fönstrets kanter"},																				 
    {TR_CONFIG_DISABLE_RIGHT_CLICK_MAP_DRAG, "Inaktivera att högerklick drar kartan"},
    {TR_CONFIG_VISUAL_FEEDBACK_ON_DELETE, "Öka visuell återkoppling vid rensning av land"},
    {TR_CONFIG_ALLOW_CYCLING_TEMPLES, "Tillåt att bygga varje tempel i följd"},
    {TR_CONFIG_SHOW_WATER_STRUCTURE_RANGE, "Visa räckvidd vid bygge av reservoarer, fontäner och brunnar"},
    {TR_CONFIG_SHOW_CONSTRUCTION_SIZE, "Visa dragbar byggnadsstorlek"},
    {TR_CONFIG_HIGHLIGHT_LEGIONS, "Framhäv legion när muspekaren är över den"},
	{TR_CONFIG_ROTATE_MANUALLY, "Rotera grindstugor och triumfarken med kortkommando"},
    {TR_CONFIG_SHOW_MILITARY_SIDEBAR, "Använd militärsidopanelen"},
    {TR_CONFIG_FIX_IMMIGRATION_BUG, "Fixa invandringsproblem med svårighetsgraden Väldigt Svårt"},																	
    {TR_CONFIG_FIX_100_YEAR_GHOSTS, "Fixa 100-års spöken"},
    {TR_CONFIG_FIX_EDITOR_EVENTS, "Fixa kejsarbyte och överlevnadstid i användaruppdrag"},
	{TR_CONFIG_DRAW_WALKER_WAYPOINTS, "Visa vagndragarens måldestination när du klickat på en byggnad."},
    {TR_CONFIG_ENABLE_ZOOM, "Slå på zoom (kan vara långsamt, använder mer RAM-minne)"},
    {TR_CONFIG_COMPLETE_RATING_COLUMNS, "Fixa ofullständiga ställningspelare för låga mål"},
    {TR_CONFIG_GRANDFESTIVAL, "Storslagen festival möjliggör ytterligare en gåva från en gud"},
    {TR_CONFIG_JEALOUS_GODS, "Stäng av svartsjuka gudar"},
	{TR_CONFIG_DIFFICULTY, "Svårighetsgrad:"},
    {TR_CONFIG_GODS_EFFECTS, "Slå på gudaförbannelser/välsingelser"},
	{TR_CONFIG_INFINITE, "Oändligt"},													
    {TR_CONFIG_GLOBAL_LABOUR, "Slå på global arbetsstyrka"},
    {TR_CONFIG_SCHOOL_WALKERS, "Förläng skolvandrares räckvidd"},
    {TR_CONFIG_RETIRE_AT_60, "Ändra medborgares pensionsålder från 50 till 60"},
    {TR_CONFIG_FIXED_WORKERS, "Fixerad arbetsstyrka - 38% av plebejbefolkningen"},
    {TR_CONFIG_EXTRA_FORTS, "Tillåt byggandet av 4 extra fort"},
    {TR_CONFIG_WOLVES_BLOCK, "Förbjudet att bygga i närheten av vargar"},
    {TR_CONFIG_DYNAMIC_GRANARIES, "Blockera ej sammankopplade sädesmagasinvägar"},
    {TR_CONFIG_MORE_STOCKPILE, "Hus lagrar fler varor från marknader"},
    {TR_CONFIG_NO_SUPPLIER_DISTRIBUTION, "Köpande marknadshandlare distribuerar ej varor"},
    {TR_CONFIG_IMMEDIATELY_DELETE_BUILDINGS, "Förstör byggnader direkt"},
    {TR_CONFIG_GETTING_GRANARIES_GO_OFFROAD, "Vagndragare från 'hämtande'-sädesmagasin kan gå av vägarna"},
    {TR_CONFIG_GRANARIES_GET_DOUBLE, "Dubblera vagndragares kapacitet från 'hämtande'-sädesmagasin"},
	{TR_CONFIG_ALLOW_EXPORTING_FROM_GRANARIES, "Tillåt handlare att exportera mat från sädesmagasin"},																						  
    {TR_CONFIG_TOWER_SENTRIES_GO_OFFROAD, "Tornvaktposter behöver inte vägtillgång till förläggningar"},
    {TR_CONFIG_FARMS_DELIVER_CLOSE, "Lantbruk och fiskehamnar lämnar bara varor till nära sädesmagasin"},
    {TR_CONFIG_DELIVER_ONLY_TO_ACCEPTING_GRANARIES, "Mat levereras inte till 'hämtande'-sädesmagasin"},
    {TR_CONFIG_ALL_HOUSES_MERGE, "Alla hus sammanfogas"},
    {TR_CONFIG_WINE_COUNTS_IF_OPEN_TRADE_ROUTE, "Öppna handelsvägar räknas som tillhandahållning av olika vinsorter"},
    {TR_CONFIG_RANDOM_COLLAPSES_TAKE_MONEY, "Slumpmässigt kollapsade lertag och malmbrott tar lite pengar istället"},
    {TR_CONFIG_MULTIPLE_BARRACKS, "Tillåt byggandet av flera förläggningar" },
    {TR_CONFIG_NOT_ACCEPTING_WAREHOUSES, "Handelsmagasin accepterar ingenting när de har byggts"},
    {TR_CONFIG_HOUSES_DONT_EXPAND_INTO_GARDENS, "Hus bygger inte ut över trädgårdar"},																																
	{TR_CONFIG_ROAMERS_DONT_SKIP_CORNERS, "Strövande medborgare hoppar inte över väghörn"},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_TITLE, "Stadsinzoomning kunde inte aktiveras"},
    {TR_CONFIG_ZOOM_COULD_NOT_BE_ENABLED_MESSAGE,
        "Ditt system har inte tillräckligt med grafikminne för att aktivera stadszoomning.\n"
        "Stadszoomning har ej aktiverats."},
    {TR_CONFIG_SHOW_MAX_POSSIBLE_PROSPERITY, "Visa det högsta möjliga välståndsbetyg med nuvarande bostäder"},																										  
    {TR_HOTKEY_TITLE, "Augustus kortkommandoinställningar"},
    {TR_HOTKEY_LABEL, "Kortkommando"},
    {TR_HOTKEY_ALTERNATIVE_LABEL, "Alternativ"},
    {TR_HOTKEY_HEADER_ARROWS, "Piltangenter"},
    {TR_HOTKEY_HEADER_GLOBAL, "Globala kortkommandon"},
    {TR_HOTKEY_HEADER_CITY, "Stadskortkommandon"},
    {TR_HOTKEY_HEADER_ADVISORS, "Rådgivare"},
    {TR_HOTKEY_HEADER_OVERLAYS, "Översikt"},
    {TR_HOTKEY_HEADER_BOOKMARKS, "Stadskartebokmärken"},
    {TR_HOTKEY_HEADER_EDITOR, "Redigeringsverktyg"},
    {TR_HOTKEY_HEADER_BUILD, "Byggnadskortkommandon"},
    {TR_HOTKEY_ARROW_UP, "Upp"},
    {TR_HOTKEY_ARROW_DOWN, "Ner"},
    {TR_HOTKEY_ARROW_LEFT, "Vänster"},
    {TR_HOTKEY_ARROW_RIGHT, "Höger"},
    {TR_HOTKEY_TOGGLE_FULLSCREEN, "Fullskärm"},
    {TR_HOTKEY_CENTER_WINDOW, "Centrera fönster"},
    {TR_HOTKEY_RESIZE_TO_640, "Sätt fönster till 640x480"},
    {TR_HOTKEY_RESIZE_TO_800, "Sätt fönster till 800x600"},
    {TR_HOTKEY_RESIZE_TO_1024, "Sätt fönster till 1024x768"},
    {TR_HOTKEY_SAVE_SCREENSHOT, "Spara skärmdump"},
    {TR_HOTKEY_SAVE_CITY_SCREENSHOT, "Spara skärmdump över hela staden"},
    {TR_HOTKEY_BUILD_CLONE, "Klona byggnad under pekaren"},
    {TR_HOTKEY_LOAD_FILE, "Öppna fil"},
    {TR_HOTKEY_SAVE_FILE, "Spara fil"},
    {TR_HOTKEY_INCREASE_GAME_SPEED, "Öka spelhastighet"},
    {TR_HOTKEY_DECREASE_GAME_SPEED, "Minska spelhastighet"},
    {TR_HOTKEY_TOGGLE_PAUSE, "Pausa"},
    {TR_HOTKEY_CYCLE_LEGION, "Växla mellan legioner"},
    {TR_HOTKEY_ROTATE_MAP_LEFT, "Rotera kartan vänster"},
    {TR_HOTKEY_ROTATE_MAP_RIGHT, "Rotera kartan höger"},
    {TR_HOTKEY_SHOW_ADVISOR_LABOR, "Arbetarrådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_MILITARY, "Militärrådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_IMPERIAL, "Imperierådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_RATINGS, "Ställningsrådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_TRADE, "Handelsrådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_POPULATION, "Befolkningsrådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_HEALTH, "Hälsorådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_EDUCATION, "Utbildningsrådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_ENTERTAINMENT, "Nöjesrådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_RELIGION, "Religionsrådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_FINANCIAL, "Ekonomirådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_CHIEF, "Huvudrådgivare"},
    {TR_HOTKEY_SHOW_ADVISOR_HOUSING, "Bostadsrådgivare", },
    {TR_HOTKEY_TOGGLE_OVERLAY, "Slå på/av nuvarande översikt"},
	{TR_HOTKEY_SHOW_OVERLAY_RELATIVE, "Visa relativ översikt"},
    {TR_HOTKEY_SHOW_OVERLAY_WATER, "Vattenöversikt"},
    {TR_HOTKEY_SHOW_OVERLAY_FIRE, "Eldöversikt"},
    {TR_HOTKEY_SHOW_OVERLAY_DAMAGE, "Skadeöversikt"},
    {TR_HOTKEY_SHOW_OVERLAY_CRIME, "Brottsöversikt"},
	{TR_HOTKEY_ROTATE_BUILDING, "Rotera byggnad"},											   
	{TR_HOTKEY_ROTATE_BUILDING_BACK, "Föregående byggnadsrotation"},															   
    {TR_HOTKEY_SHOW_OVERLAY_PROBLEMS, "Problemöversikt"},
    {TR_HOTKEY_GO_TO_BOOKMARK_1, "Gå till bokmärke 1"},
    {TR_HOTKEY_GO_TO_BOOKMARK_2, "Gå till bokmärke 2"},
    {TR_HOTKEY_GO_TO_BOOKMARK_3, "Gå till bokmärke 3"},
    {TR_HOTKEY_GO_TO_BOOKMARK_4, "Gå till bokmärke 4"},
    {TR_HOTKEY_SET_BOOKMARK_1, "Sätt bokmärke 1"},
    {TR_HOTKEY_SET_BOOKMARK_2, "Sätt bokmärke 2"},
    {TR_HOTKEY_SET_BOOKMARK_3, "Sätt bokmärke 3"},
    {TR_HOTKEY_SET_BOOKMARK_4, "Sätt bokmärke 4"},
    {TR_HOTKEY_EDITOR_TOGGLE_BATTLE_INFO, "Slå på/av stridsinformation"},
    {TR_HOTKEY_EDIT_TITLE, "Nytt kortkommando"},
	{TR_BUILDING_ROADBLOCK, "Vägspärr"},
    {TR_BUILDING_ROADBLOCK_DESC, "Vägspärrar stoppar strövande medborgare."},
    {TR_BUILDING_ARCHITECT_GUILD, "Arkitektsskrå" },
    {TR_BUILDING_ARCHITECT_GUILD_DESC, "Arkitekter här arbetar flitigt för att konstruera monument i Roms ära." },
    {TR_BUILDING_GRAND_TEMPLE_ADD_MODULE, "Skänk epitet till templet" },
    {TR_BUILDING_GRAND_TEMPLE_CERES, "Ceres storslagna tempel" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE, "Neptunus storslagna tempel" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY, "Merkurius storslagna tempel" },
    {TR_BUILDING_GRAND_TEMPLE_MARS, "Mars storslagna tempel" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS, "Venus storslagna tempel" },
    {TR_BUILDING_PANTHEON, "Pantheon" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC, "Ceres" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC, "Neptunus" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC, "Merkurius" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC, "Mars" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC, "Venus" },
    {TR_BUILDING_PANTHEON_DESC, "Pantheon, en helgedom åt alla gudar" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_BONUS_DESC, "Vagndragare från lantgårdar går 50% snabbare" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_BONUS_DESC, "Ger +1 räckvidd för fontäner och brunnar, samt +2 till reservoarer. Antalet anställda som krävs till vattentjänstebyggnader minskar med 50%. Handelsfartyg seglar 25% snabbare." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_BONUS_DESC, "Köpmannakaravaner samt handelsskepp har 50% mer kapacitet. Köpmannakaravaner rör sig 25% snabbare." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_BONUS_DESC, "Utbildar soldater som en förläggning. Ytterligare fyra fort kan byggas." },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_BONUS_DESC, "Stadens trädgårdar, statyer och tempel glänser med förhöjd skönhet, vilket ökar deras attraktionsvärde. Hus lagrar fler varor och de övergår till lägre nivåer i en långsammare takt." },
    {TR_BUILDING_PANTHEON_BONUS_DESC, "Förser åtkomst till alla gudar. Arrangerar årliga festivaler och minskar tempelavgifter med 25%." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_1_DESC, "Ceres präster minskar matåtgången med 20%." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_1_DESC, "Neptunustempel producerar körsven till hippodromen." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_1_DESC, "Merkurius präster minskar kruk- och möbelåtgången med 20%." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_1_DESC, "Marstempel genererar mat, mängden baseras på antalet hus de täcker, och levererar det till förnödenhetsstationen." },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_1_DESC, "Det storslagna templet producerar vin i en kvantitet som baseras på hur stor andel av befolkningen som har åtkomst till Venustempel. Tempel samlar in och distribuerar det till husen." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_MODULE_2_DESC, "Ceres präster samlar in och distribuerar både olja och en sorts mat från stadens magasin." },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_MODULE_2_DESC, "Präster expanderar husens kapacitet med 5%. Det storslagna templet förser vatten som en fylld reservoar." },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_MODULE_2_DESC, "Merkurius präster minskat olje- och vinkonsumptionen med 20%." },
    {TR_BUILDING_GRAND_TEMPLE_MARS_MODULE_2_DESC, "Mars präster minskar konsumptionen av alla varor med 10%." },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_MODULE_2_DESC, "Venus präster bidrar med underhållning och förfinar husen överlag, vilket ökar attraktionsvärdet i området utan att ytterligare dekorationer krävs." },
    {TR_BUILDING_PANTHEON_MODULE_1_DESC, "Alla stadens tempel skickar präster till Pantheon, och sprider tron och välsignelser från deras respektive gudar." },
    {TR_BUILDING_PANTHEON_MODULE_2_DESC, "Hus med åtkomst till Pantheon kan utvecklas ytterligare en nivå." },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_1, "Ceres tempel Promitor" },
    {TR_BUILDING_GRAND_TEMPLE_CERES_DESC_MODULE_2, "Ceres tempel Reparator" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_1, "Neptunus tempel Equester" },
    {TR_BUILDING_GRAND_TEMPLE_NEPTUNE_DESC_MODULE_2, "Neptunus tempel Adiutor" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_1, "Merkurius tempel Fortunus" },
    {TR_BUILDING_GRAND_TEMPLE_MERCURY_DESC_MODULE_2, "Merkurius tempel Abundantia" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_1, "Mars Mars tempel Ultor" },
    {TR_BUILDING_GRAND_TEMPLE_MARS_DESC_MODULE_2, "Mars Mars tempel Quirinus" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_1, "Venus tempel Verticordia" },
    {TR_BUILDING_GRAND_TEMPLE_VENUS_DESC_MODULE_2, "Venus tempel Genetrix" },
    {TR_BUILDING_PANTHEON_DESC_MODULE_1, "Pantheum Ara Maxima" },
    {TR_BUILDING_PANTHEON_DESC_MODULE_2, "Pantheum Roma Aeterna" },
    {TR_BUILDING_GRAND_TEMPLE_MENU, "Storslaget tempel" },
    {TR_BUILDING_WORK_CAMP, "Arbetarläger" },
    {TR_BUILDING_WORK_CAMP_DESC, "Arbetare samlas här för att förflytta material till byggarbetsplatser." },
    {TR_HEADER_HOUSING, "Bostäder"},
    {TR_ADVISOR_HOUSING_ROOM, "Stadens bostäder har plats för"},
    {TR_ADVISOR_HOUSING_NO_ROOM, "Det finns inget tillgängligt utrymme för inhysande."},
    {TR_ADVISOR_RESIDENCES_DEMANDING_POTTERY, "Bostäder kräver krukor"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_FURNITURE, "Bostäder kräver möbler"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_OIL, "Bostäder kräver olja"},
    {TR_ADVISOR_RESIDENCES_DEMANDING_WINE, "Bostäder kräver vin"},
    {TR_ADVISOR_TOTAL_NUM_HOUSES, "Totala bostäder:"},
    {TR_ADVISOR_AVAILABLE_HOUSING_CAPACITY, "Tillgänglig kapacitet:"},
    {TR_ADVISOR_TOTAL_HOUSING_CAPACITY, "Total kapacitet:"},
    {TR_ADVISOR_ADVISOR_HEADER_HOUSING, "Befolkning - Bostäder"},
    {TR_ADVISOR_BUTTON_GRAPHS, "Grafer"},
    {TR_ADVISOR_HOUSING_PROSPERITY_RATING, "Bostadsvälståndsställning är"},
    {TR_ADVISOR_PERCENTAGE_IN_VILLAS_PALACES, "Andelen av din befolkning som bor i villor och palats är"},
    {TR_ADVISOR_PERCENTAGE_IN_TENTS_SHACKS, "Andelen av din befolkning som bor i tält och skjul är"},
    {TR_ADVISOR_AVERAGE_TAX, "Genomsnittlig skatteinkomst per bostad är"},
    {TR_ADVISOR_AVERAGE_AGE, "Medelåldern för din befolkning är"},
    {TR_ADVISOR_PERCENT_IN_WORKFORCE, "Andelen av din befolkning i arbetskraften är"},
    {TR_ADVISOR_BIRTHS_LAST_YEAR, "Födslar förra året"},
    {TR_ADVISOR_DEATHS_LAST_YEAR, "Dödsfall förra året"},
    {TR_ADVISOR_TOTAL_POPULATION, "invånare totalt"},
	    {TR_ADVISOR_IN_STORAGE, "i förvar"},
    {TR_ADVISOR_FROM_GRANARIES, "från sädesmagasin"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TITLE, "Levererar mat från sädesmagasin"},
    {TR_ADVISOR_DISPATCHING_FOOD_FROM_GRANARIES_TEXT, "Är du säker?"},
    {TR_ADVISOR_KEEP_STOCKPILING, "Fortsätt lagra resurs"},
    {TR_ADVISOR_MAX_ATTAINABLE_PROSPERITY_IS, "Det högsta möjliga välståndsbetyget för nuvarande bostadsnivå är"},																							 
    {TR_REQUIRED_RESOURCES, "Resurser levererade till nuvarande fas:"},
    {TR_BUILDING_GRAND_TEMPLE_CONSTRUCTION_DESC, "För att konstruera ett storslaget tempel krävs lagrade material i ett varuhus, arbetare från ett arbetarläger, och arkitekter från ett arkitetsskrå."},
    {TR_CONSTRUCTION_PHASE, "Konstruktionsfas:"},
    {TR_ADD_MODULE, "Återinviga templet?"},
    {TR_BUILDING_TEMPLE_MODULE_CONSTRUCTED, "Epitet tilldelad."},
    {TR_BUILDING_CERES_TEMPLE_QUOTE, "Ceres var den som först med buktig plog vände torvan,\nhon gav oss grödor först och ljuva frukter ur jorden,\nskänkte oss lagar först. Allting är gåvor från Ceres.\n-Ovidius, Metamorfoser, Bok V" },
    { TR_BUILDING_NEPTUNE_TEMPLE_QUOTE, "Havets ursinne släcks,\ndess härskare lägger åt sidan treuddigt ljuster,\nsmeker till ro dess vågor och kallar Triton\nsom mörkblå höjer upp ur djupen,\nmed skuldror täckta av musslor som sugit sig fast.\nSin ljudande snäcka manas han blåsa i\noch så bjuda strömmar och floder att retirera snabbt.\n-Ovidius, Metamorfoser, Bok I"},
    {TR_BUILDING_MERCURY_TEMPLE_QUOTE, "Taga sig kan man med svärd både oxar och yppersta fårhjord,\nskaffa sig kan man den vackraste häst och den skönaste trefot\no, men en människas själ, den griper och fångar man icke,\nså att den vänder igen, när den flytt över tändernas stängsel.\n-Homeros, Iliaden, Sång IX"},
    {TR_BUILDING_MARS_TEMPLE_QUOTE, "Snabbt i den lilla staden går ryktet ut\natt beridna krigare bryter upp\nmot etruskerkonungens stränder.\nMödrar fördubblar i skräck sina bönelöften,\nty rädslan växer med faran,\noch Mars gestalt står väldig framför dem.\n-Vergilius, Aeneiden, Sång VIII" },
    {TR_BUILDING_VENUS_TEMPLE_QUOTE, "O Venus, och du som följer din vänliga moder,\nvingade gud, vilken fröjd jag njöt!\nHur begäret, nu öppet, grep mig!\nHur smälte ej, när jag låg där, hela mitt väsen!\n-Ovidius, Metamorfoser, Bok IX" },
    {TR_BUILDING_PANTHEON_QUOTE,"Nu slås Olympens, den allt behärskandes,\nmäktiga portar upp, ty människors konung och gudars\nfader har kallat samman sitt råd i stjärnstrött palats,\nfrån vars höjd han betraktar hela vår jord,\nlatinska folk och dardanernas läger.\n-Vergilius, Aeneiden, Sång X" },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1, "(Podium)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2, "(Portik)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3, "(Cella)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4, "(Praecinctum)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5, "(Dedicatio)"},
    {TR_BUILDING_GRAND_TEMPLE_PHASE_1_TEXT, "Arbetare konstruerar podiet som höjer upp templet och förser det med en gedigen grund för att klara tidens gång." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_2_TEXT, "Hantverkade bygger portiken, som bär upp templets offeraltare." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_3_TEXT, "Arkitekter bygger cellan, insidan av templet där de heliga målningarna finns." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_4_TEXT, "Arbetet på templets praecinctum har påbörjats, där tillbedjare kommer samlas utomhus för offentliga ceremonier." },
    {TR_BUILDING_GRAND_TEMPLE_PHASE_5_TEXT, "Nu när templet snart är färdigt samlas präster för att utföra invigningsritualer."},
    {TR_BUILDING_MENU_TREES, "Träd" },
    {TR_BUILDING_MENU_PATHS, "Stråk" },
    {TR_BUILDING_MENU_PARKS, "Parker"},
    {TR_BUILDING_SMALL_POND, "Liten damm"},
    {TR_BUILDING_LARGE_POND, "Stor damm"},
    {TR_BUILDING_PINE_TREE, "Tall"},
    {TR_BUILDING_FIR_TREE, "Gran" },
    {TR_BUILDING_OAK_TREE, "Ek" },
    {TR_BUILDING_ELM_TREE, "Alm" },
    {TR_BUILDING_FIG_TREE, "Fikonträd" },
    {TR_BUILDING_PLUM_TREE, "Plommonträd" },
    {TR_BUILDING_PALM_TREE, "Palmträd" },
    {TR_BUILDING_DATE_TREE, "Dadelpalm" },
    {TR_BUILDING_PINE_PATH, "Tallstråk" },
    {TR_BUILDING_FIR_PATH, "Granstråk" },
    {TR_BUILDING_OAK_PATH, "Ekstråk" },
    {TR_BUILDING_ELM_PATH, "Almstråk" },
    {TR_BUILDING_FIG_PATH, "Fikonstråk" },
    {TR_BUILDING_PLUM_PATH, "Plommonstråk" },
    {TR_BUILDING_PALM_PATH, "Palmstråk" },
    {TR_BUILDING_DATE_PATH, "Dadelstråk" },
    {TR_BUILDING_BLUE_PAVILION, "Blå paviljong" },
    {TR_BUILDING_RED_PAVILION, "Röd paviljong"},
    {TR_BUILDING_ORANGE_PAVILION, "Orange paviljong"},
    {TR_BUILDING_YELLOW_PAVILION, "Gul paviljong"},
    {TR_BUILDING_GREEN_PAVILION, "Grön paviljong" },
    {TR_BUILDING_SMALL_STATUE_ALT, "Gudinnestaty" },
    {TR_BUILDING_SMALL_STATUE_ALT_B, "Senatorstaty"},
    {TR_BUILDING_OBELISK, "Obelisk" },
    {TR_BUILDING_POND_DESC, "Dammar förses med vatten från stadens reservoarer och förser växter och djur med vatten, men är också en svalkande och avslappnande oas för folket. Alla medborgare skulle älska att bo nära en damm." },
    {TR_BUILDING_WINDOW_POND, "Damm"},
    {TR_BUILDING_OBELISK_DESC, "Ett prestigefyllt monument, från en forntida konung av Nilen. Egyptierna hade ingen användning för den."},
    {TR_ADVISOR_FINANCE_LEVIES, "Byggnadsavgifter"},
    {TR_CONFIRM_DELETE_MONUMENT, "Rasera det här monumentet"},
    {TR_SELECT_EPITHET_PROMPT_HEADER, "Välj epitet att tilldela."},
    {TR_SELECT_EPITHET_PROMPT_TEXT, "Genom att tilldela en epitet tillägnar du ditt tempel en permanent aspekt av dess gud, vilket ger präster gudomliga krafter." },
    {TR_BUILDING_INFO_MONTHLY_LEVY, "/månad"},
    {TR_BUILDING_MESS_HALL, "Förnödenhetsstation"},
    {TR_BUILDING_MESS_HALL_DESC, "Förnödenhetsstationen samlar in mat från stadens sädesmagasin för att utfodra soldater stationerade i stadens fort. En förnödenhetsstation med dålig tillgång till mat kommer leda till att rekryteringen saktar ned samt att truppernas moral tar skada."},
    {TR_BUILDING_MESS_HALL_FULFILLMENT, "Förra månadens matförsörjning:"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER, "Soldaterna är: " },
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_1, "Väl utfodrade" },
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_2, "Utfodrade"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_3, "Hungriga"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_4, "Mycket hungriga"},
    {TR_BUILDING_MESS_HALL_TROOP_HUNGER_5, "Svältande"},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_1, "En varierad diet för dina soldater kommer öka deras moral mycket."},
    {TR_BUILDING_MESS_HALL_FOOD_TYPES_BONUS_2, "Den varierade och näringsrika kosten som dina soldater åtnjuter ökar moralen mycket."},
    {TR_BUILDING_MESS_HALL_NO_SOLDIERS, "Du har inga soldater att utfodra." },
    {TR_BUILDING_MESS_HALL_MONTHS_FOOD_STORED, "Månader som den lagrade maten räcker till:" },
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "Matbrist i din förnödenhetsstation saktar ned rekryteringen av nya soldater."},
	{TR_MESS_HALL_SPECIAL_ORDERS_HEADER, "Förnödenhetsstationsinstruktioner"},
    {TR_BUILDING_BARRACKS_FOOD_WARNING, "Matbrist vid din förnödenhetsstation saktar ned rekryteringen av soldater."},																										   
    {TR_BUILDING_BARRACKS_FOOD_WARNING_2, "Akut matbrist i din förnödenhetsstation stoppar trupprekryteringen." },
    {TR_BUILDING_LEGION_FOOD_WARNING_1, "Den gångna matbristen sänkte moralen."},
    {TR_BUILDING_LEGION_FOOD_WARNING_2, "Den gångna matbristen sänkte moralen mycket."},
    {TR_BUILDING_LEGION_STARVING, "Matbrist" },
	{TR_ADVISOR_TRADE_MAX, "Max"},
    {TR_ADVISOR_TRADE_NO_LIMIT, "max"},
    {TR_ADVISOR_TRADE_IMPORTABLE, "Importerbar"},
    {TR_ADVISOR_TRADE_EXPORTABLE, "Exporterbar"},
    {TR_ADVISOR_TRADE_NO_BUYERS, "Inga köpare för den här resursen"},
    {TR_ADVISOR_TRADE_NO_SELLERS, "Inga säljare för den här resursen"},
    {TR_ADVISOR_TRADE_NOT_IMPORTING, "Importerar inte"},
    {TR_ADVISOR_TRADE_NOT_EXPORTING, "Exporterar inte"},
    {TR_ADVISOR_OPEN_TO_IMPORT, "Öppna handelsväg för import"},
    {TR_ADVISOR_OPEN_TO_EXPORT, "Öppna handelsväg för export"},														  
    {TR_ADVISOR_LEGION_FOOD_SATISFIED, "Dina soldater har all mat som de behöver."},
    {TR_ADVISOR_LEGION_FOOD_NEEDED, "Dina soldater behöver mer mat." },
    {TR_ADVISOR_LEGION_FOOD_CRITICAL, "Dina soldater svälter!"},
    {TR_ADVISOR_LEGION_MONTHS_FOOD_STORED, "Månader som den lagrade maten i förnödenhetsstationen räcker till:" },
    {TR_CITY_MESSAGE_TITLE_MESS_HALL_NEEDS_FOOD, "Hungriga soldater" },
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_NEEDS_FOOD, "Din förnödenhetsstation har akut brist på mat, och dina truppers moral minskar. Se till att stationen har tillgång till ett välfyllt sädesmagasin."},
    {TR_CITY_MESSAGE_TEXT_MESS_HALL_MISSING, "Din stad har förlorat sin förnödenhetsstation och dina trupper svälter. Bygg en ny station genast."},
    {TR_MARKET_SPECIAL_ORDERS_HEADER, "Varor att hämta"},
    {TR_WARNING_NO_MESS_HALL, "Först måste du bygga en förnödenhetsstation så du kan utfodra dina soldater." },
	{TR_DOCK_SPECIAL_ORDERS_HEADER, "Hamninstruktioner"},
    {TR_TEMPLE_SPECIAL_ORDERS_HEADER, "Tempelinstruktioner"},
    {TR_TAVERN_SPECIAL_ORDERS_HEADER, "Kroginstruktioner"},	
    {TR_WARNING_NO_MESS_HALL, "Först måste du bygga en förnödenhetsstation för att utfodra dina soldater." },
    {TR_WARNING_MAX_GRAND_TEMPLES, "Endast två storslagna tempel kan byggas." },
    {TR_CITY_MESSAGE_TITLE_GRAND_TEMPLE_COMPLETE, "Storslaget tempel färdigbyggt"},
    {TR_CITY_MESSAGE_TEXT_GRAND_TEMPLE_COMPLETE, "Präster och tillbedjare flockas till det nya storslagna templet för invigningsritualerna. Ditt folk beundrar ditt storslagna arbete, och templets tillägnade gud öser sin ynnest över dig."},
    {TR_CITY_MESSAGE_TITLE_MERCURY_BLESSING, "En välsignelse från Merkurius" },
    {TR_CITY_MESSAGE_TEXT_MERCURY_BLESSING, "Förtjust över din hängivenhet har Merkurius välsignat din industri och upptäckt bortglömda råmaterial till dina hantverkare."},
    {TR_FIGURE_TYPE_WORK_CAMP_WORKER, "Förman"},
    {TR_FIGURE_TYPE_WORK_CAMP_SLAVE, "Fraktare"},
    {TR_FIGURE_TYPE_WORK_CAMP_ARCHITECT, "Arkitekt"},
    {TR_FIGURE_TYPE_MESS_HALL_SUPPLIER, "Kvartermmästare"},
    {TR_FIGURE_TYPE_MESS_HALL_COLLECTOR, "Lägertjänare"},
    {TR_BUILDING_CERES_TEMPLE_MODULE_DESC, "Ceres präster från det storslagna templet bidrar med att distribuera mat och olja till dina hungriga invånare."},
    {TR_BUILDING_VENUS_TEMPLE_MODULE_DESC, "Venus präster från det storslagna templet förser heligt vin till dina invånare." },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC, "Mars präster från det storslagna templet förser mat till din förnödenhetsstation."},
    {TR_BUILDING_SMALL_TEMPLE_CERES_NAME, "Tempel till Ceres"},
    {TR_BUILDING_SMALL_TEMPLE_NEPTUNE_NAME, "Tempel till Neptunus"},
    {TR_BUILDING_SMALL_TEMPLE_MERCURY_NAME, "Tempel till Merkurius"},
    {TR_BUILDING_SMALL_TEMPLE_MARS_NAME, "Tempel till Mars"},
    {TR_BUILDING_SMALL_TEMPLE_VENUS_NAME, "Tempel till Venus"},
    {TR_FIGURE_TYPE_PRIEST_SUPPLIER, "Präst" },
	{TR_BUILDING_DOCK_CITIES_CONFIG_DESC, "Städer med öppna sjöhandelsvägar:" },
    {TR_BUILDING_DOCK_CITIES_NO_ROUTES, "Det finns inga öppna sjöhandelsvägar." },																			
    // Transcription of mission_exact4.wav
    {TR_PHRASE_FIGURE_MISSIONARY_EXACT_4, "\"Jag ska göra vad jag kan för att lugna dessa barbarer. Jag är säker på att de kommer sluta atteckera staden när jag har pratat med dem.\"" },
    {TR_CITY_MESSAGE_TITLE_PANTHEON_FESTIVAL, "En årlig festival"},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_CERES, "De troende flockar till tempel för att fira Cerealia, i Ceres ära. Jordbrukare skänker offergåvor för rika skördar de kommande åren."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_NEPTUNE, "Idag är det Neptunaliafestivalen, i Neptunus ära. De trofasta bygger hyddor av grenar och lövverk och roar sig under midsommarsolens gassande hetta."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MERCURY, "Massor av köpmän anländer för att fira Merkuriusfestivalen. Heligt vatten sprids på skeppen och varuhusen i hopp om gudomligt skydd av Merkurius."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_MARS, "Medborgare samlas utanför staden för att fira Equirria, för att söka Mars gunst. Luften är tyngd av dånande hovar och knarrande vagnar när trofasta tävlar till sin guds ära."},
    {TR_CITY_MESSAGE_TEXT_PANTHEON_FESTIVAL_VENUS, "De troende samlas för att fira Veneralia, en helig dag för Venus. Dina medborgare bönfaller henne om god lycka å deras hjärtans strävan."},
    {TR_TOOLTIP_BUTTON_DELETE_READ_MESSAGES, "Radera lästa meddelanden"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_ON, "Ta denna byggnad ur bruk"},
    {TR_TOOLTIP_BUTTON_MOTHBALL_OFF, "Börja använda denna byggnad"},
    {TR_TOOLTIP_BUTTON_ACCEPT_MARKET_LADIES, "Tillåt marknadshandlare att köpa härifrån"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_CARAVAN, "Tillåt köpmannakaravaner att byteshandla här"},
    {TR_TOOLTIP_BUTTON_ACCEPT_TRADE_SHIPS, "Tillåt handelsskepp att byteshandla här"},
    {TR_BUILDING_CARAVANSERAI, "Karavanseraj"},									   
    {TR_BUILDING_LIGHTHOUSE, "Fyr"},
	{TR_BUILDING_CARAVANSERAI_DESC, "Handelskaravaner tar skydd här för att vila och utfodra sina djur. Avbrott på handelsvägarna består bara hälften så lång tid."},
	{TR_CARAVANSERAI_SPECIAL_ORDERS_HEADER, "Karavanseraj iinstruktioner"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1, "(Grund)"},
    {TR_BUILDING_CARAVANSERAI_PHASE_1_TEXT, "Arkitekter gräver grunden för denna framtida viloplats."},
    {TR_FIGURE_TYPE_CARAVANSERAI_SUPPLIER, "Karavanserajleverantör" },
    {TR_FIGURE_TYPE_CARAVANSERAI_COLLECTOR, "Karavanserajinsamlare" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TITLE, "Landhandelspolicy" },
    {TR_BUILDING_CARAVANSERAI_NO_POLICY, "Ingen landhandelspolicy" },
    {TR_BUILDING_CARAVANSERAI_POLICY_TEXT, "Välj en handelsvägspolicy för din stad. Du kan byta ut den när som helst, mot ett pris." },
    {TR_BUILDING_CARAVANSERAI_POLICY_1_TITLE, "Consilium venditor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_1, "Handelsvägssäljarens policy: Exportintäkter från handelskaravaner är 20% högre, men landbaserade importer är 10% dyrare." },
    {TR_BUILDING_CARAVANSERAI_POLICY_2_TITLE, "Consilium emptor terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_2, "Handelsvägsköparens policy: Importer med handelskaravaner är 20% billigare, men landbaserade exporter är 10% lägre." },
    {TR_BUILDING_CARAVANSERAI_POLICY_3_TITLE, "Consilium quantitas terrae" },
    {TR_BUILDING_CARAVANSERAI_POLICY_3, "Kvantitetspolicy för handelskaravaner: Handelskaravaner transporterar ytterligare 4 varor, men förflyttar sig 15% långsammare." },													  
    {TR_BUILDING_LIGHTHOUSE_PHASE_1, "(Grund)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_2, "(Pedestal)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_3, "(Torn)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_4, "(Krona)" },
    {TR_BUILDING_LIGHTHOUSE_PHASE_1_TEXT, "Arkitekter lägger en stadig grund som ska tåla vikten av ett stort torn i sten." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_2_TEXT, "Murare konstruerar pedestalen som ska förhöja fyrens eld långt ovanför horisonten." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_3_TEXT, "Fyrens torn blir högre för var dag som murarna utövar sitt hantverk." },
    {TR_BUILDING_LIGHTHOUSE_PHASE_4_TEXT, "Arkitekter arbetar på de sista detaljerna på fyren. Snart kommer den synas från flera mil, och vägleda fartyg hem." },
    {TR_BUILDING_LIGHTHOUSE_CONSTRUCTION_DESC, "Konstruktionen av fyren kräver att material finns lagrat i ett varuhus, arbetare från ett arbetarläger och arkitekter från ett arkitetsskrå. " },
    {TR_BUILDING_LIGHTHOUSE_BONUS_DESC, "Ljuset på detta storslagna torn vägleder skepp från fjärran länder till din stad. Fiskeskepp seglar nu 10% snabbare, och havsstormar varar endast hälften så lång tid." },
	{TR_BUILDING_LIGHTHOUSE_POLICY_TITLE, "Sjöhandelspolicy" },
    {TR_BUILDING_LIGHTHOUSE_NO_POLICY, "Ingen sjöhandelspolicy" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_TEXT, "Välj en sjöfartshandelspolicy för din stad. Du kan byta ut den när som helst, mot ett pris." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1_TITLE, "Consilium venditor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_1, "Sjöfartsförsäljarens policy: Exportintäkter från sjöfartshandel är 20% högre, men sjöfartsbaserade importer är 10% dyrare." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2_TITLE, "Consilium emptor maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_2, "Sjöfartsköparens policy: Importer via sjöfartshandel är 20% billigare, men exporter med sjöfartshandel är 10% lägre." },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3_TITLE, "Consilium quantitas maritimae" },
    {TR_BUILDING_LIGHTHOUSE_POLICY_3, "Kvantitetspolicy för sjöfartshandel: Handelsskepp transporterar ytterligare 6 varor, men förflyttar sig 15% långsammare." },													   
    {TR_EDITOR_ALLOWED_BUILDINGS_MONUMENTS, "Monument"},
    {TR_CITY_MESSAGE_TEXT_LIGHTHOUSE_COMPLETE, "Den färdiga fyren, ett mäktigt torn av sten, reser sig över horisonten. Må dess ljus vägleda skepp i evig tid." },
    {TR_CITY_MESSAGE_TEXT_PANTHEON_COMPLETE, "Pantheon är färdig. Den är ett oöverträffligt monument till gudarnas makt och det romerska folket." },
    {TR_CITY_MESSAGE_TITLE_MONUMENT_COMPLETE, "Monument färdigt" },
    {TR_CITY_MESSAGE_TITLE_NEPTUNE_BLESSING, "En välsignelse från Neptunus"},
    {TR_CITY_MESSAGE_TEXT_NEPTUNE_BLESSING, "Som belöning för din stads hängivenhet förunnar Neptunus säker sjöfart åt handelsskeppen i tolv månader, dessutom kommer dina exporter dra in hälften av priset som bonus under den tiden."},
    {TR_CITY_MESSAGE_TITLE_VENUS_BLESSING, "En välsignelse fån Venus" },
    {TR_CITY_MESSAGE_TEXT_VENUS_BLESSING, "Förtjust över det glädjefyllda vördnad som visas henne skänker Venus livskraft, hälsa och lycka till ditt folk, vilket ökar andelen av befolkningen som arbetar." },
    {TR_BUILDING_MENU_STATUES, "Statyer" },
    {TR_BUILDING_MENU_GOV_RES, "Guvernörens herrgårdar" },
    {TR_OVERLAY_ROADS, "Vägar" },
    {TR_NO_EXTRA_ASSETS_TITLE, "'Assets'-mappen kan inte hittas." },
    {TR_NO_EXTRA_ASSETS_MESSAGE,
	    "Nya tillgångar kommer ej visas korrekt.\n"
        "Din installation av Caesar 3 har ej en korrekt installerad 'assets'-mapp.\n"
        "Var god och säkertställ att '/assets'-mappen finns på översta nivån i din Caesar 3-installationsmapp." },
    {TR_WARNING_WATER_NEEDED_FOR_LIGHTHOUSE, "Fyren måste placeras nära vatten"},
    {TR_TOOLTIP_OVERLAY_PANTHEON_ACCESS, "Det här huset har tillgång till alla fem gudarna via Pantheon."},
    {TR_BUILDING_LEGION_FOOD_BONUS, "Den rikliga maten ökar moralen" },
    {TR_BUILDING_LEGION_FOOD_STATUS, "Förnödenhetsstatus"},
    {TR_TOOLTIP_BUTTON_ACCEPT_QUARTERMASTER, "Tillåt kvartermästaren att hämta mat härifrån"},
    {TR_WARNING_RESOURCES_NOT_AVAILABLE, "Du kan inte erhålla materialen som krävs"},
    {TR_CONFIG_GP_CH_MONUMENTS_BOOST_CULTURE_RATING, "Färdigbyggda storslagna tempel ger +8 kulturställning"},
	{TR_CONFIG_GP_CH_DISABLE_INFINITE_WOLVES_SPAWNING, "Slå av att vargar uppstår i all evighet"},																					   
    {TR_BUTTON_BACK_TO_MAIN_MENU, "Tillbaka till huvudmeny" },
    {TR_LABEL_PAUSE_MENU, "Pausa" },
    {TR_OVERLAY_LEVY, "Avgifter" },
    {TR_TOOLTIP_OVERLAY_LEVY, " denarier betalade i avgifter månadsvis." }, 
    {TR_MAP_EDITOR_OPTIONS, "Scenarieinställningar" },										 
    {TR_BUTTON_GO_TO_SITE, "Gå till platsen" },
	{TR_BUILDING_TAVERN, "Krog" },
    {TR_BUILDING_GRAND_GARDEN, "Praktfull trädgård" },
    {TR_BUILDING_TAVERN_DESC_1, "Den här krogen har inga arbetare, och kan inte bedriva sin verksamhet." },
    {TR_BUILDING_TAVERN_DESC_2, "Den här krogen har inget vin, och kan intebedriva sin verksamhet." },
    {TR_BUILDING_TAVERN_DESC_3, "Krogen bjuder på underrhållning så länge vinet fortsätter flöda. Tillgång till kött skulle öka dess attraktionskraft." },
    {TR_BUILDING_TAVERN_DESC_4, "Rikliga mängder vin och doften av grillat kött lockar en livlig skara medborgare till krogen för spel, musik och festligheter." },
    {TR_FIGURE_TYPE_BARKEEP, "Krogbiträde" },
    {TR_FIGURE_TYPE_BARKEEP_SUPPLIER, "Krogens leverantör" },
    {TR_OVERLAY_TAVERN, "Krog" },
    {TR_TOOLTIP_OVERLAY_TAVERN_1, "Det här huset har ej tillgång till en krog, eller så har krogens vin sinat." },
    {TR_TOOLTIP_OVERLAY_TAVERN_2, "Inget krogbiträde har passerat här på ett tag. Det här huset kommer snart förlora dess krogtillgång." },
    {TR_TOOLTIP_OVERLAY_TAVERN_3, "Ett krogbiträde har passerat det här huset från en krog med vin." },
    {TR_TOOLTIP_OVERLAY_TAVERN_4, "Ett krogbiträde har passerat det här huset från en krog med vin och kött." },
    {TR_TOOLTIP_OVERLAY_TAVERN_5, "Ett krogbiträde passerade nyligen det här huset från en krog med vin." },
    {TR_TOOLTIP_OVERLAY_TAVERN_6, "Ett krogbiträde passerade nyligen det här huset från en krog med vin och kött. Låt festligheterna börja!" },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_1, "De boende föraktar ditt självaste namn."},
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_2, "De boende är mycket arga på dig." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_3, "De boende är arga på dig." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_4, "De boende är mycket upprörda på dig." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_5, "De boende är upprörda på dig." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_6, "De boende stör sig på dig." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_7, "De boende är likgiltiga mot dig." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_8, "De boende är nöjda med dig." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_9, "De boende är mycket nöjda med dig." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_10, "De boende är oerhört nöjda med dig." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_11, "De boende älskar dig." },
    {TR_BUILDING_WINDOW_HOUSE_SENTIMENT_12, "De boende avgudar dig." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_HIGH_TAXES, "De boende är upprörda över höga skatter." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_LOW_WAGES, "De boende är upprörda över låga löner." }, 
    {TR_BUILDING_WINDOW_HOUSE_UPSET_UNEMPLOYMENT, "De boende är upprörda över bristen på arbete." },
    {TR_BUILDING_WINDOW_HOUSE_UPSET_SQUALOR, "De boende är uppgivna över deras undermåliga bostäder." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_ENTERTAINMENT, "De boende skulle uppskatta mer underhållning." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_FOOD, "De boende skulle uppskatta en mer varierad kost." },
    {TR_BUILDING_WINDOW_HOUSE_SUGGEST_DESIRABILITY, "De boende skulle uppskatta mer åtråvärdhet i området." },
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_POSITIVE, "De boendes humör har lyfts av en nyligen inträffad händelse." }, 
    {TR_BUILDING_WINDOW_HOUSE_RECENT_EVENT_NEGATIVE, "De boende är modfällda på grund av en ny händelse." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_TAVERN_COVERAGE, "Krogar" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_HEADER, "Spel" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_DESC, "Med dina personliga besparingar kan du sponsra storslagna spel i ditt colosseum eller hippodrom." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Anordna spel" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_PREPARING, "Förberedelser för storslagna gladiatorspel är pågång." },
    {TR_SELECT_GAMES_HEADER, "Spel" },
    {TR_SELECT_GAMES_TEXT, "Gladiatorspel kommer att hållas i Colosseum eller hippodromen och kommer att bekostas med dina personliga besparingar och tillgångar." },
    {TR_BUILDING_ARENA, "Arena" },
    {TR_BUILDING_HORSE_STATUE, "Ryttarstaty" },
    {TR_BUILDING_DOLPHIN_FOUNTAIN, "Delfinfontän" },
    {TR_BUILDING_HEDGE_DARK, "Grönskande häck" },
    {TR_BUILDING_HEDGE_LIGHT, "Solbelyst häck" },
    {TR_BUILDING_GARDEN_WALL, "Slingrande trädgårdsmur" },
    {TR_BUILDING_LEGION_STATUE, "Legionärstaty" },
    {TR_BUILDING_DECORATIVE_COLUMN, "Marmorpelare" },
    {TR_BUILDING_COLOSSEUM_PHASE_1, "(Hypogeum)" },
    {TR_BUILDING_COLOSSEUM_PHASE_2, "(Grund)" },
    {TR_BUILDING_COLOSSEUM_PHASE_3, "(Arkad Arcade)" },
    {TR_BUILDING_COLOSSEUM_PHASE_4, "(Galleria)" },
    {TR_BUILDING_COLOSSEUM_PHASE_1_TEXT, "Arbetare gräver den underjordiska hypogeum, tunnlar och konstruktioner från vilka storslagna spektakel kommer att skapas." },
    {TR_BUILDING_COLOSSEUM_PHASE_2_TEXT, "Colosseums läktare tar form när arbetare lägger sittplatser för såväl vanligt folk som kejsare." },
    {TR_BUILDING_COLOSSEUM_PHASE_3_TEXT, "Eleganta valv reser sig mot skyarna för att bära det mäktiga Colosseum." },
    {TR_BUILDING_COLOSSEUM_PHASE_4_TEXT, "Då Colosseum reser sig mot skyn beklädes dess väggar i skinande marmor och statyetter." },
    {TR_BUILDING_HIPPODROME_PHASE_1, "(Spår)" },
    {TR_BUILDING_HIPPODROME_PHASE_2, "(Grund)" },
    {TR_BUILDING_HIPPODROME_PHASE_3, "(Stånd)" },
    {TR_BUILDING_HIPPODROME_PHASE_4, "(Fasad)" },
    {TR_BUILDING_HIPPODROME_PHASE_1_TEXT, "Denna massiva plats undersöks ihärdigt och rensas för ett byggnadsprojekt av oöverträffad omfattning." },
    {TR_BUILDING_HIPPODROME_PHASE_2_TEXT, "Ingångar och läktare konstrueras runt omkring spåret." },
    {TR_BUILDING_HIPPODROME_PHASE_3_TEXT, "Stenhuggare knackar ur sittplatser av sten för tiotusentals åskådare." },
    {TR_BUILDING_HIPPODROME_PHASE_4_TEXT, "Mer än bara en kapplöpningsbana, hantverkare skapar ett monument värdigt gudarna och det romerska folket." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_DESC, "Konstruktionen av monumentet kräver material förvarat i ett handelsmagasin, arbetare från ett arbetarläger samt arkitekter från ett arkitetsskrå." },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_HALTED, "Konstruktion stoppad." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_ARENA_COVERAGE, "Arenor" },
    {TR_BUILDING_INFO_TOURISM, "(resande)" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_COMPLETE, "Colosseum är fullbordat! Låt spelen börja!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_COMPLETE, "Hippodromen är färdigställd. Medborgarna väntar med spänning på din order om att kapplöpningarna ska sätta igång!" },
    {TR_CITY_MESSAGE_TITLE_COLOSSEUM_WORKING, "Invigningsspelen" },
    {TR_CITY_MESSAGE_TITLE_HIPPODROME_WORKING, "Kapplöpningarna inleds" },
    {TR_CITY_MESSAGE_TEXT_COLOSSEUM_WORKING, "De invigande spelen för ditt Colosseum har börjat. På ditt kommando kommer de tappra kämparnas blod inviga detta monument!" },
    {TR_CITY_MESSAGE_TEXT_HIPPODROME_WORKING, "Staden står tom när folket flockar till Hippodromen för de invigande vagnkapplöpningarna. Ett öronbedövande jubel hörs i dess omgivning när portarna slås upp!" },
    {TR_WINDOW_GAMES_OPTION_1, "Sjöslag" },
    {TR_WINDOW_GAMES_OPTION_2, "Djurtävlingar" },
    {TR_WINDOW_GAMES_OPTION_3, "Kalends Ianuarius" },
    {TR_WINDOW_GAMES_OPTION_4, "Olympiska spelen" },
    {TR_WINDOW_GAMES_OPTION_5, "Roman Games" },
    {TR_WINDOW_GAMES_OPTION_1_DESC, "Vatten kommer fylla Colosseum för att rekonstruera ett storslaget sjöslag. Ökar soldaternas rörelsehastighet, samt deras styrka i avlägsna strider, i 12 månader." },
    {TR_WINDOW_GAMES_OPTION_2_DESC, "Ruskiga djurjakter och avrättningar av vilda odjur kommer arrangeras i Colosseum, vilket behagar plebejerna. Kriminella, upplopp och revolter kommer stävjas i 12 månader. Gladiatorer kommer hjälpa till att försvara staden vid nästa invasion." },
    {TR_WINDOW_GAMES_OPTION_3_DESC, "Colosseum kommer att hålla gladiatorspel till gudarnas ära på årets första dag, i hopp om lycka och välstånd. Handelskvoter kommer fördubblas nästa år." },
    {TR_WINDOW_GAMES_OPTION_4_DESC, "De olympiska spelen kommer hållas i Hippodromen. Din stad - The Hippodrome will host the Olympic Games. Your city will host throngs of visitors, and if your athletes honor your city well you will gain a permanent increase in tourism and favor." },
    {TR_WINDOW_GAMES_OPTION_5_DESC, "De Romerska spelen kommer hållas i Colosseum. Din stad kommer vara värd för besökare från fjärran platser, ivriga att bevisa sina styrkor i olika tävlingar. Firandet kommer att belöna dig med gunst från både Kejsaren och vanligt folk det kommande året." },
    {TR_WINDOW_GAMES_COST, "Kostnad:" },
    {TR_WINDOW_GAMES_PERSONAL_FUNDS, "(personliga besparingar)" },
    {TR_WINDOW_GAMES_NOT_ENOUGH_FUNDS, "Ej tillräckligt med personliga besparingar." },
    {TR_WINDOW_GAMES_NOT_ENOUGH_RESOURCES, "Ej tillräckligt med lagrade resurser." },
    {TR_WINDOW_GAMES_NO_VENUE, "Arenan ej färdig, eller saknar arbetskraft." },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1, "(Konstruktion)" },
    {TR_BUILDING_SMALL_TEMPLE_PHASE_1_TEXT, "Stenhuggare och arkitekter bygger denna byggnad av skinande marmor med omsorg." },
    {TR_BUILDING_SMALL_TEMPLE_CONSTRUCTION_DESC, "Att konstruera detta tempel fordrar material förvarat i ett handelsmagasin, arbetare från ett arbetarläger och arkitekter från arkitetsskrået." },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_PLANNING, "Vatten från stadens reservoarer fyller långsamt Colosseum. Snickare börjar sätta ihop verklighetstrogna krigsskepp medan gladiatorer övar på strider till sjöss. Snart kommer sjöslagen att börja!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_STARTING, "Colosseum har förvandlats till en konstgjord sjö där gladiatorer återskapar storslagna romerska segrar till sjöss. Åskådarna hejar på medan blod och vatten beblandas. Naumachia, sjöslaget, har börjat!" },
    {TR_CITY_MESSAGE_TEXT_NAVAL_GAMES_ENDING, "Colosseum förbereds för normala föreställningar igen genom dränering och en långdragen reningsprocess. Folket kommer att tala om detta vattenspektakel i många år framöver." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_PLANNING, "Underligt gods börjar dyka upp i staden då handelsmän levererar rysliga odjur från världens hörn till burarna under Colosseum. Ohyggliga spektakel kommer snart att behaga ditt folk." },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_STARTING, "Dömda brottslingar och ärosökande gladiatorer möter döden i form av tänder och klor. I ljudet av trumpeter inleds striderna mot djuren!" },
    {TR_CITY_MESSAGE_TEXT_ANIMAL_GAMES_ENDING, "Det sista vilda odjuret ligger dräpt i Colosseums sand, vars blod möts med det från de som dömts till döden. Striderna mot djuren är över." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_PLANNING, "Vi välkomnar det nya året med storslagna spel i gudarnas ära. I gengäld ber vi om lycka, välstånd och välsignelser i handel." },
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_STARTING, "När dagen gryr på Kalends Ianurius startar spelen. Präster offrar djur medan gladiatorer rustar upp för att strida för de gudomligas gunst."},
    {TR_CITY_MESSAGE_TEXT_KALENDS_GAMES_ENDING, "Spåmännen påstår att guda är mycket nöjda med våra storslagna spel, och offergåvorna samt vördnaden som visats dem. Vi kan vänta oss ett väldigt lönsamt år!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_PLANNING, "Allas blickar kommer att riktas mot din stad när de olympiska spelen lockar kringresande, kämpar och romerska ämbetsmän från hela världen. Inom ett år kommer alla förberedelser vara verkställda."},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_STARTING, "Äntligen är dagen kommen. Den heliga elden är tänd, och stadens gator står övergivna då medborgare trängs i den stora hippodromen. Låt spelen börja!"},
    {TR_CITY_MESSAGE_TEXT_OLYMPIC_GAMES_ENDING, "Den heliga elden har falnat, i en matt fröjd beger sig de kringresande och medborgarna hemåt. Den eviga äran är din efter att med framgång ha ansvarat för denna uråldriga och heliga hyllning till de dödligas styrka och ära." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_PLANNING, "Med beskedet om de romerska spelen flockas folk från utkanterna av imperiet till din stad, i hopp om vinst i de kommande tävlingarna. Inom ett år kommer alla förberedelser vara verkställda." },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_STARTING, "Den högtidliga marchen inleds, och med den de romerska spelen. Må självaste Jupiter pröva dagens triumferande kämpar i kapplöpningar, kamper och andra tävlingar i uttålighet och smidighet. Colosseum är fyllt till bredden med medborgare som inväntar spelen med de sedvanliga gåvorna vete och olivolja. Låt spelen börja!" },
    {TR_CITY_MESSAGE_TEXT_IMPERIAL_GAMES_ENDING, "Sista dagen av de romerska spelen är nu över. Samtliga medborgare har fått smaka på storheten i det romerska livet. Ära  till kejsaren, ära till segrarna i spelen och ära till guvernören!" },
    {TR_CITY_MESSAGE_TITLE_GREAT_GAMES, "De storslagna spelen"},
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN, " Månader tills nya spel kan hållas:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_NG, "Månader kvar till sjöslag:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_NG, "Sjöslag är i full gång. Vågornas dån, knakande timmer och gladiatorers stridsrop kan höras i publikens jubel." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_AG, "Månader kvar till djurtävlingarna:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_AG, "Djurtävlingarna är på gång. Sida vid sida skriker sig folkhopen hesa medan vilda odjur jagar sina mänskliga byten." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_KG, "Månader kvar till Kalends-spelen:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_KG, "Kalends-spelen är på gång. Även den fräna lukten av svett och blod från arenan överskyls av djuroffer och rökelser." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_OG, "Månader kvar till de olympiska spelen:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_OG, "De olympiska spelen är på gång. Den heliga elden brinner dag och natt när atleterna tävlar om evig ära." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_PREPARING_IG, "Månader kvar till de romerska spelen:" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_UNDERWAY_IG, "De romerska spelen är på gång. Varje deltagare offrar sitt blod, svett och tårar för att bevisa att han är den bästa i romaren." },
    {TR_WINDOW_BUILDING_GAMES_REMAINING_DURATION, "De storslagna spelen fortsätter i ytterligare" }, // ...XX Days, 
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_COOLDOWN_TEXT, "De storslagna spelen hölls nyligen." },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_GAMES_UNDERWAY, "De storslagna spelen är på gång! Kringresande som festande trängs nu på din stads gator." },
    {TR_WINDOW_BUILDING_ARENA_CLOSED, "Arenan är stängd. Fåglar bygger bon på de tomma sittplatserna." },
    {TR_WINDOW_BUILDING_ARENA_NO_SHOWS, "Arenan erbjuder väldigt lite underhållning då den varken har lejon eller gladiatorer." },
    {TR_WINDOW_BUILDING_ARENA_BOTH_SHOWS, "Lokalbefolkningen älskar gladiatorkamperna och djurtävlingarna i den här arenan." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_LIONS, "Vanliga gladiatorföreställningar underhåller pöbeln, men lejon skulle förhöja spektaklet." },
    {TR_WINDOW_BUILDING_ARENA_NEEDS_GLADIATORS, "Hungriga odjur stryker omkring arenan i jakt på byte, men bristen på gladiatorer resulterar i korta föreställningar." },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Det här templet samlar mat till din förnödenhetsstation när den väl är byggd." },
    {TR_OVERLAY_ARENA_COL, "Arena" },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_1, "Detta hus har varken tillgång till en arena eller colosseum." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_2, "Detta hus har tillgång till en arena med en föreställning." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_3, "Detta hus har tillgång till en arena med två föreställningar." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_4, "Detta hus har tillgång till colosseum med en föreställning." },
    {TR_TOOLTIP_OVERLAY_ARENA_COL_5, "Detta hus har tillgång till colosseum med två föreställningar." },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_STRIKE, "Arbetarna strejkar" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_WATER_ACCESS, "Ingen vattenåtkomst" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_CARTPUSHER, "Väntar på vagndragare" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_NO_RESOURCES, "Inga tillgängliga resurser" },
    {TR_TOOLTIP_OVERLAY_PROBLEMS_MOTHBALLED, "Byggnad ej i bruk" },
    {TR_WINDOW_BUILDING_TOURISM_DISABLED, "För många byggnader av denna sort-- kringresande undviker den här platsen." },
    {TR_WINDOW_BUILDING_TOURISM_ANNUAL, "Inkomst från kringresande det här året:" },
    {TR_WINDOW_BUILDING_WHARF_MOTHBALLED, "Din handelsrådgivare har beordrat att din fiskeverksamhet ska stoppas."},
    {TR_WINDOW_ADVISOR_FINANCE_INTEREST_TRIBUTE, "Tribut/ränta"},
    {TR_WINDOW_ADVISOR_TOURISM, "Diverse"},
    {TR_WINDOW_FIGURE_TOURIST, "Denna kringresande har spenderat: "},
    {TR_FIGURE_TYPE_TOURIST,  "Resenär"},
    {TR_MAP_EDITOR_OPTIONS, "Scenarioinställningar" },
    {TR_SAVEGAME_LARGER_VERSION_TITLE, "Inkompatibel sparfilversion" },
    {TR_SAVEGAME_LARGER_VERSION_MESSAGE, "Sparfilen du försöker ladda är från en nyare version av Augustus.\nVar god uppdatera Augustus till den senaste versionen." },
    {TR_BUILDING_COLONNADE, "Kolonnad" },
    {TR_BUILDING_LARARIUM, "Lararium" },
    {TR_WINDOW_BUILDING_LARARIUM_DESC, "Ett litet tempel tillägnat larerna - det romerska folkets skyddsandar. Här kan medborgare be och lämna små offergåvor."},
    {TR_BUILDING_WATCHTOWER, "Utkikstorn"},
    {TR_BUILDING_WATCHTOWER_DESC, "Bågskyttar på bröstvärnen håller utkik efter fiender, medan gatorna patrulleras av stadsvakter." },
	{TR_BUILDING_WATCHTOWER_DESC_NO_SOLDIERS, "Detta torn behöver en vakt från förläggningen innan det kan försvara staden."},	 
    {TR_BUILDING_NYMPHAEUM, "Nymfeum"},
    {TR_BUILDING_NYMPHAEUM_DESC, "Ett storslaget tempel tillägnat nymferna som inger hopp om lycka och gudomlig gunst till staden." },
    {TR_BUILDING_SMALL_MAUSOLEUM, "Litet mausoleum"},
    {TR_BUILDING_SMALL_MAUSOLEUM_DESC, "Många levande avundas denna viloplats för de välbergade." },
    {TR_BUILDING_LARGE_MAUSOLEUM, "Stort mausoleum"},
    {TR_BUILDING_LARGE_MAUSOLEUM_DESC, "Inom denna magnifika byggnads polerade marmorväggar har endast de mest framstående patricierna priviligiet att få vila." },
    {TR_FIGURE_TYPE_WATCHMAN, "Stadsvakt" },
    {TR_BUILDING_MARS_TEMPLE_MODULE_DESC_NO_MESS, "Det här templet kommer samla mat till din förnödenhetsstation, när den väl är byggd." },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MAINTENANCE, "Växla tillträde för prefekturer och ingenjörer" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_PRIEST, "Växla tillträde för präster" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MARKET, "Växla tillträde för marknadshandlare" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_ENTERTAINER, "Växla tillträde för underhållare" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_EDUCATION, "Växla tillträde för utbildningsarbetare" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MEDICINE, "Växla tillträde för sjukvårdsarbetare" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_TAX_COLLECTOR, "Växla tillträde för skatteindrivare" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_LABOR_SEEKER, "Växla tillträde för arbetssökande medborgare" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_MISSIONARY, "Växla tillträde för missionärer" },
    {TR_TOOLTIP_BUTTON_ROADBLOCK_PERMISSION_WATCHMAN, "Växla tillträde för stadsvakter" },
    {TR_HOTKEY_DUPLICATE_TITLE, "Kortkommando används redan"},
    {TR_HOTKEY_DUPLICATE_MESSAGE, "Den här knappkombinationen används redan till följande:"},
    {TR_BUILDING_GARDEN_PATH, "Trädgårdsstig" },
    {TR_BUTTON_GO_TO_SITE, "Gå till platsen" },
    {TR_BUTTON_HALT_MONUMENT_CONSTRUCTION, "Stoppa konstruktion" },
    {TR_BUTTON_RESUME_MONUMENT_CONSTRUCTION, "Återuppta konstruktion" },
    {TR_RESOURCE_FISH, "Fisk" },
    {TR_WARNING_VARIANT_TOGGLE, "Rotationsknappen växlar mellan varianter av denna byggnad"},
    {TR_BUILDING_SCHOOL_UPGRADE_DESC, "Denna skola är i bruk. Skolan undervisar elever och tack vare den förträffliga omgivningen har skolan kunnat expandera. Nu kan fler barn studera samtidigt."},
    {TR_BUILDING_THEATRE_UPGRADE_DESC, "Denna teater är i bruk. Den vackra omgivningen har lett till att teatern har expenderat. Den större teatern kan tillgodose fler medborgares underhållningsbehov." },
    {TR_BUILDING_LIBRARY_UPGRADE_DESC, "Detta bibliotek är i bruk. Biblioteket har byggts ut tack vare den förtjusande omgivningen. Nu när det finns plats för fler rullar kommer fler romare ha tillgång till undervisning." },
    {TR_WINDOW_BUILDING_INFO_WARNING_NO_MONUMENT_ROAD_ACCESS, "Monumentet har ej åtkomst till en väg. Se till att en väg är ansluten till mittpunkten på en av sidorna så att konstruktionen kan fortgå."},
    {TR_WINDOW_BUILDING_WORKSHOP_STRIKING, "Till följd av den dåliga stämningen i staden strejkar plebejerna i verkstaden och vägrar arbeta!" },
    {TR_CITY_WARNING_SECESSION, "Plebejer vägrar arbeta" },
    {TR_CITY_WARNING_WAREHOUSE_BREAKIN, "Ett handelsmagasin plundrades" },
    {TR_CITY_WARNING_GRANARY_BREAKIN, "Ett sädesmagasin plundrades" },
    {TR_CITY_WARNING_THEFT, "Rikedommar stals från ett forum eller senaten" },
    {TR_CITY_MESSAGE_TITLE_LOOTING, "Plundrar i staden"},
    {TR_CITY_MESSAGE_TEXT_LOOTING, "Varor stals då ett handels- eller sädesmagasin blev rånat av arga medborgare. Dålig stadsstämning ökar risken för sådanna incidenter."},
    {TR_SIDEBAR_EXTRA_INVASIONS, "Invasioner" },
    {TR_SIDEBAR_EXTRA_INVASION_UNDERWAY, "Invasion på gång" },
    {TR_SIDEBAR_EXTRA_NO_INVASIONS, "Inga invasioner" },
    {TR_SIDEBAR_EXTRA_INVASION_IMMINENT, "Invasion nära" },
    {TR_SIDEBAR_EXTRA_ENEMIES_CLOSING, "Fiender närmar sig" },
    {TR_SIDEBAR_EXTRA_ENEMIES_DISTANT, "Fiender långt borta" },
    {TR_SIDEBAR_EXTRA_GODS, "Gudar" },
    {TR_SIDEBAR_EXTRA_REQUESTS_VIEW_ALL, "Visa alla" },
    {TR_SIDEBAR_EXTRA_REQUESTS_SMALL_FORCE, "Liten styrka"},
    {TR_SIDEBAR_EXTRA_REQUESTS_AVERAGE_FORCE, "Medioker styrka"},
    {TR_SIDEBAR_EXTRA_REQUESTS_LARGE_FORCE, "Stor styrka"},
    {TR_SIDEBAR_EXTRA_REQUESTS_SEND, "Sänd begäran"},
    {TR_SIDEBAR_EXTRA_REQUESTS_STOCK, "Hamstra"},
    {TR_SIDEBAR_EXTRA_REQUESTS_UNSTOCK, "Sluta hamstra"},
    {TR_TOOLTIP_ADVISOR_HOUSING_GRAPH_BUTTON, "Gå till befolkningssammansättning" },
    {TR_TOOLTIP_ADVISOR_POPULATION_HOUSING_BUTTON, "Besök din bostadsrådgivare" },
    {TR_BUILDING_MONUMENT_CONSTRUCTION_ARCHITECT_NEEDED, "Det här monumentet har alla material som krävs för den här fasen, nu behövs en skicklig arkitekt från arkitetsskrået som kan övervaka konstruktionen." },
    {TR_RETURN_ALL_TO_FORT, "Alla"},
	{TR_TOOLTIP_ADVISOR_ENTERTAINMENT_GAMES_BUTTON, "Spelinformation" },
    {TR_WINDOW_BUILDING_GOVERNMENT_LARGE_STATUE_WATER_WARNING, "Statyn ser fantastisk ut, men den skulle se ännu ståtligare ut om dess fontän var igång. Ge den tillgång till vatten." },
    {TR_OPTION_MENU_COST, "Detta kommer kosta"},
	{TR_OPTION_MENU_APPLY, "Tillämpa" },										 
    {TR_FIGURE_TYPE_LOOTER, "Plundrare" },
    {TR_FIGURE_TYPE_ROBBER, "Rånare" },
    {TR_OVERLAY_SENTIMENT, "Stämning" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_NO_COVERAGE, "Ingen" },
    {TR_WINDOW_ADVISOR_ENTERTAINMENT_FULL_COVERAGE, "Alla" },
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY, "Välj en landhandelspolicy"},
    {TR_TOOLTIP_ADVISOR_TRADE_LAND_POLICY_REQUIRED, "Din stad måste ha en karavanseraj för att en landhandelspolicy ska kunna väljas"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY, "Välj sjöhandelspolicy"},
    {TR_TOOLTIP_ADVISOR_TRADE_SEA_POLICY_REQUIRED, "Din stad måste ha en fyr för att en landhandelspolicy ska kunna väljas"},
    {TR_TOOLTIP_HOLD_GAME, "Anordna spelen"},
    {TR_TOOLTIP_NO_GAME, "Anordna inte spelen"},
    {TR_WARNING_NEARBY_WOLF, "Kan inte bygga i närheten av vargar"},															   
	{TR_MARKET_TRADING, "Handlar med"},
    {TR_MARKET_NOT_TRADING, "Handlar ej med"},
    {TR_TEMPLE_DISTRIBUTING, "Distribuerar"},
    {TR_TEMPLE_NOT_DISTRIBUTING, "Distribuerar ej"},
    {TR_ADVISOR_CHIEF_NO_IMMIGRATION_SQUALOR, "Eländiga bostäder och slumområden förhindrar immigration."},
	{TR_CITY_MESSAGE_SQUALOR, "Undermåliga bostäder och slumområden är ett problem"},																	 
    {TR_FIGURE_TYPE_LIGHTHOUSE_SUPPLIER, "Fyrvakt"},
    {TR_WINDOW_GAMES_NO_WATER_ACCESS, "Arenan har ej tillgång till en reservoar."},{TR_HOTKEY_COPY_SETTINGS, "Kopiera byggnadsinställningar" },
    {TR_HOTKEY_PASTE_SETTINGS, "Klistra in byggnadsinställningar" },
    {TR_WINDOW_ADVISOR_RELIGION_LARARIUMS, "Lararia in the city" },
    {TR_WINDOW_RACE_BET_BUTTON, "Satsa på en häst"},
    {TR_WINDOW_IN_PROGRESS_BET_BUTTON, "Kapplöpning pågår..."},
    {TR_WINDOW_RACE_BET_TITLE, "Satsa pengar på en häst"},
    {TR_WINDOW_RACE_BET_AMOUNT, "Insats"},
    {TR_WINDOW_RACE_BET_DESCRIPTION, "Lägg en insats från dina personliga besparingar på den körsvenn du tror kommer vinna, din insats dubblas om din häst vinner. Din insats kommer dessutom fyrdubblas om ett spel hålls i colosseum!"},
    {TR_WARNING_BET_VICTORY, "Din häst vann kapplöpningen i stadens hippodrom!"},
    {TR_WARNING_BET_DEFEAT, "Din häst förlorade kapplöpningen i din stads hippodrom."},
    {TR_PERSONAL_SAVINGS, "Besparingar :"},
    {TR_WINDOW_RACE_BET_BLUE_HORSE, "Satsa på den blåa hästen"},
    {TR_WINDOW_RACE_BET_RED_HORSE, "Satsa på den röda hästen"},
    {TR_WINDOW_RACE_BET_WHITE_HORSE, "Satsa på den vita hästen"},
    {TR_WINDOW_RACE_BET_GREEN_HORSE, "Satsa på den gröna hästen"},
    {TR_BUILDING_GRAND_TEMPLE_NEEDS_WORKERS, "När templet inte är fullt bemannat kan inte samtliga riter och festligheter utföras. Tills det ändras kan vi inte förvänta oss gudomlig favör."},
    {TR_BUILDING_COLOSSEUM_NEEDS_WORKERS, "Colosseum behöver fler arbetare för att dina invånare ska få tillgång till den underhållning som är värdig byggnaden."},
    {TR_BUILDING_HIPPODROME_NEEDS_WORKERS, "Hippodromen behöver fler arbetare för att kunna tillhandahålla spektakulär underhållning till samtliga invånare."},
    {TR_BUILDING_LIGHTHOUSE_NEEDS_WORKERS, "Fyren är inte fullt bemannad, fyrens eld kan därför inte hållas vid liv. Fartyg kan inte vägledas av dess ljus till våra hamnar."},
    {TR_BUILDING_CARAVANSERAI_NEEDS_WORKERS, "Utan att vara fullt bemannad kan inte karavanserajen betjäna alla ankommande karavaner."},
    {TR_BUILDING_ROOFED_GARDEN_WALL, "Trädgårdsmur med tak"},
    {TR_BUILDING_GARDEN_WALL_GATE, "Trädgårdsgrind"},
    {TR_BUILDING_GARDEN_WALL_GATE_DESC, "Grinden hindrar oinbjudna gäster från att störa i de fridfulla trädgårdarna."},
    {TR_WINDOW_BUILDING_DISTRIBUTION_CART_PUSHER_GETTING, "Vagndragaren hämtar varor från ett annat varuhus."},
    {TR_BUILDING_PALISADE, "Palissad" },
    {TR_BUILDING_PALISADE_DESC, "Detta gedigna pålverk av trä kommer skydda oss från angripare och fientliga djur."},	
    {TR_CONFIG_MAX_GRAND_TEMPLES, "Maximalt antal storslagna tempel per stad:" },
    {TR_CONFIG_USE_COLOR_CURSORS, "Använd färgade muspekare" },
    {TR_HOTKEY_COPY_SETTINGS, "Kopiera byggnadsinställningar" },
    {TR_OVERLAY_MOTHBALL, "Ur bruk" },
    {TR_OVERLAY_ENEMY, "Fiender" },
    {TR_BUILDING_TAVERN_DESC_5, "Medborgare älskar att besöka den här anläggningen på deras fritid för att umgås över god mat och fint vin." },
    {TR_OVERLAY_WAREHOUSES, "Handelsmagasin" },
    {TR_WINDOW_RACE_BLUE_HORSE_DESCRIPTION, "Det blåa laget - Neptunus favoriter. De här är de mest lovande av Roms unga kuskar som önskar visa vad de går för." },
    {TR_WINDOW_RACE_RED_HORSE_DESCRIPTION, "Det röda laget - känt som laget som leds av den mest framgångsrika kusken i Roms historia - en föredetta roddare som räddade livet på en romesrk konsul." },
    {TR_WINDOW_RACE_WHITE_HORSE_DESCRIPTION, "Det vita laget - grundat av föredetta gladiatorer. De har stridandet i blodet, och trots att de är fria män lever de för den här utmaningen." },
    {TR_WINDOW_RACE_GREEN_HORSE_DESCRIPTION, "Det gröna laget - arvingar till Celeresryttarna från tiden då rom ännu var ett kungarike. De påstår sig fortfarande vara de bästa av de bästa." },
    {TR_TOOLTIP_BUTTON_ACCEPT_WORKERS, "Stoppa leveranser av resurser till handelsmagasin och sädesmagasin." },
    {TR_TOOLTIP_BUTTON_REJECT_WORKERS, "Återuppta resursleveranser" },
    {TR_TOOLTIP_BUTTON_STOCKPILING_ON, "Hamstra varor direkt handelsmagasin." },
    {TR_TOOLTIP_BUTTON_STOCKPILING_OFF, "Sluta hamstra varor direkt i handelsmagasin." },
    {TR_CONFIG_DIGIT_SEPARATOR, "Separate digits"},
};

void translation_swedish(const translation_string **strings, int *num_strings)
{
    *strings = all_strings;
    *num_strings = sizeof(all_strings) / sizeof(translation_string);
}
