MACRO(getFfmpegVersionFromHeader description headerFile definition ffmpegVersion)
  FILE(READ "${headerFile}" FFMPEG_H)
  STRING(REGEX MATCH "#define[ ]+${definition}[ ]+([0-9]+)" FFMPEG_H "${FFMPEG_H}")
  STRING(REGEX REPLACE ".*[ ]([0-9]+).*" "\\1" ${ffmpegVersion} "${FFMPEG_H}")
ENDMACRO()

MACRO(getFfmpegLibNames sourceDir)
  getFfmpegVersionFromHeader("libavcodec" "${sourceDir}/libavcodec/version_major.h" LIBAVCODEC_VERSION_MAJOR LIBAVCODEC_VERSION)
  getFfmpegVersionFromHeader("libavformat" "${sourceDir}/libavformat/version_major.h" LIBAVFORMAT_VERSION_MAJOR LIBAVFORMAT_VERSION)
  getFfmpegVersionFromHeader("libavutil" "${sourceDir}/libavutil/version.h" LIBAVUTIL_VERSION_MAJOR LIBAVUTIL_VERSION)
  getFfmpegVersionFromHeader("libpostproc" "${sourceDir}/libpostproc/version_major.h" LIBPOSTPROC_VERSION_MAJOR LIBPOSTPROC_VERSION)
  getFfmpegVersionFromHeader("libswscale" "${sourceDir}/libswscale/version_major.h" LIBSWSCALE_VERSION_MAJOR LIBSWSCALE_VERSION)
  SET(VERBOSE 1)
  IF(VERBOSE)
    MESSAGE(STATUS "AVFORMAT : ${LIBAVFORMAT_VERSION}, Major : ${LIBAVFORMAT_VERSION_MAJOR}")
    MESSAGE(STATUS "AVCODEC  : ${LIBAVCODEC_VERSION}, Major : ${LIBAVCODEC_VERSION_MAJOR}")
    MESSAGE(STATUS "AVUTIL   : ${LIBAVUTIL_VERSION}, Major : ${LIBAVUTIL_VERSION_MAJOR}")
    MESSAGE(STATUS "POSTPRC  : ${LIBPOSTPROC_VERSION}, Major : ${LIBPOSTPROC_VERSION_MAJOR}")
    MESSAGE(STATUS "SWSCALE  : ${LIBSWSCALE_VERSION}, Major : ${LIBSWSCALE_VERSION_MAJOR}")
    MESSAGE("")
  ENDIF()

  IF(UNIX)
    SET(LIBAVCODEC_ADM ADM6)
  ENDIF()

  IF(APPLE)
    SET(LIBAVCODEC_LIB lib${LIBAVCODEC_ADM}avcodec.${LIBAVCODEC_VERSION}${CMAKE_SHARED_LIBRARY_SUFFIX})
    SET(LIBAVFORMAT_LIB lib${LIBAVCODEC_ADM}avformat.${LIBAVFORMAT_VERSION}${CMAKE_SHARED_LIBRARY_SUFFIX})
    SET(LIBAVUTIL_LIB lib${LIBAVCODEC_ADM}avutil.${LIBAVUTIL_VERSION}${CMAKE_SHARED_LIBRARY_SUFFIX})
    SET(LIBPOSTPROC_LIB lib${LIBAVCODEC_ADM}postproc.${LIBPOSTPROC_VERSION}${CMAKE_SHARED_LIBRARY_SUFFIX})
    SET(LIBSWSCALE_LIB lib${LIBAVCODEC_ADM}swscale.${LIBSWSCALE_VERSION}${CMAKE_SHARED_LIBRARY_SUFFIX})
  elseIF(UNIX)
    SET(LIBAVCODEC_LIB lib${LIBAVCODEC_ADM}avcodec${CMAKE_SHARED_LIBRARY_SUFFIX}.${LIBAVCODEC_VERSION})
    SET(LIBAVFORMAT_LIB lib${LIBAVCODEC_ADM}avformat${CMAKE_SHARED_LIBRARY_SUFFIX}.${LIBAVFORMAT_VERSION})
    SET(LIBAVUTIL_LIB lib${LIBAVCODEC_ADM}avutil${CMAKE_SHARED_LIBRARY_SUFFIX}.${LIBAVUTIL_VERSION})
    SET(LIBPOSTPROC_LIB lib${LIBAVCODEC_ADM}postproc${CMAKE_SHARED_LIBRARY_SUFFIX}.${LIBPOSTPROC_VERSION})
    SET(LIBSWSCALE_LIB lib${LIBAVCODEC_ADM}swscale${CMAKE_SHARED_LIBRARY_SUFFIX}.${LIBSWSCALE_VERSION})
  elseIF(MINGW)
    SET(LIBAVCODEC_LIB ${LIBAVCODEC_ADM}avcodec-${LIBAVCODEC_VERSION}${CMAKE_SHARED_LIBRARY_SUFFIX})
    SET(LIBAVFORMAT_LIB ${LIBAVCODEC_ADM}avformat-${LIBAVFORMAT_VERSION}${CMAKE_SHARED_LIBRARY_SUFFIX})
    SET(LIBAVUTIL_LIB ${LIBAVCODEC_ADM}avutil-${LIBAVUTIL_VERSION}${CMAKE_SHARED_LIBRARY_SUFFIX})
    SET(LIBPOSTPROC_LIB ${LIBAVCODEC_ADM}postproc-${LIBPOSTPROC_VERSION}${CMAKE_SHARED_LIBRARY_SUFFIX})
    SET(LIBSWSCALE_LIB ${LIBAVCODEC_ADM}swscale-${LIBSWSCALE_VERSION}${CMAKE_SHARED_LIBRARY_SUFFIX})
  elseIF(MSVC)
    SET(LIBAVCODEC_LIB   avcodec.lib)
    SET(LIBAVFORMAT_LIB  avformat.lib)
    SET(LIBAVUTIL_LIB    avutil.lib)
    SET(LIBPOSTPROC_LIB  postproc.lib)
    SET(LIBSWSCALE_LIB   swscale.lib)
  ENDIF()
ENDMACRO()

MACRO(registerFFmpeg sourceDir binaryDir installed)
  getFfmpegLibNames("${sourceDir}")

  ADD_LIBRARY(ADM_libswscale UNKNOWN IMPORTED)
  ADD_LIBRARY(ADM_libpostproc UNKNOWN IMPORTED)
  ADD_LIBRARY(ADM_libavutil UNKNOWN IMPORTED)
  ADD_LIBRARY(ADM_libavcodec UNKNOWN IMPORTED)
  ADD_LIBRARY(ADM_libavformat UNKNOWN IMPORTED)

  IF(${installed})
    SET_PROPERTY(TARGET ADM_libswscale PROPERTY IMPORTED_LOCATION "${binaryDir}/${LIBSWSCALE_LIB}")
    SET_PROPERTY(TARGET ADM_libpostproc PROPERTY IMPORTED_LOCATION "${binaryDir}/${LIBPOSTPROC_LIB}")
    SET_PROPERTY(TARGET ADM_libavutil PROPERTY IMPORTED_LOCATION "${binaryDir}/${LIBAVUTIL_LIB}")
    SET_PROPERTY(TARGET ADM_libavcodec PROPERTY IMPORTED_LOCATION "${binaryDir}/${LIBAVCODEC_LIB}")
    SET_PROPERTY(TARGET ADM_libavformat PROPERTY IMPORTED_LOCATION "${binaryDir}/${LIBAVFORMAT_LIB}")
  ELSE()
    MACRO(IMPORTFF lib adm_lib location)
      SET_PROPERTY(TARGET ${adm_lib} PROPERTY IMPORTED_LOCATION "${location}")
      ADD_CUSTOM_TARGET(${lib} DEPENDS "${location}")
      ADD_DEPENDENCIES(${adm_lib} ${lib})
    ENDMACRO()

    IMPORTFF(libswscale  ADM_libswscale "${binaryDir}/libswscale/${LIBSWSCALE_LIB}")
    IMPORTFF(libpostproc ADM_libpostproc "${binaryDir}/libpostproc/${LIBPOSTPROC_LIB}")
    IMPORTFF(libavutil   ADM_libavutil "${binaryDir}/libavutil/${LIBAVUTIL_LIB}")
    IMPORTFF(libavcodec  ADM_libavcodec "${binaryDir}/libavcodec/${LIBAVCODEC_LIB}")
    IMPORTFF(libavformat ADM_libavformat "${binaryDir}/libavformat/${LIBAVFORMAT_LIB}")

    ADD_CUSTOM_TARGET(ffmpeg DEPENDS "${binaryDir}/ffmpeg${CMAKE_EXECUTABLE_SUFFIX}")
  ENDIF()
ENDMACRO()

MACRO(convertPathToUnix pathVariableName bashExecutable)
  IF(WIN32)
    GET_FILENAME_COMPONENT(directory ${${pathVariableName}} PATH)
    GET_FILENAME_COMPONENT(fileName ${${pathVariableName}} NAME)

    EXECUTE_PROCESS(COMMAND ${bashExecutable} -c "echo $PWD" WORKING_DIRECTORY "${directory}"
            OUTPUT_VARIABLE ${pathVariableName})

    STRING(REGEX REPLACE "(\r?\n)+$" "" ${pathVariableName} "${${pathVariableName}}")
    SET(${pathVariableName} "${${pathVariableName}}/${fileName}")
  ENDIF()
ENDMACRO()
