/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.metadata.source;

import com.google.i18n.phonenumbers.MetadataLoader;
import com.google.i18n.phonenumbers.Phonemetadata;
import com.google.i18n.phonenumbers.internal.GeoEntityUtility;
import com.google.i18n.phonenumbers.metadata.init.MetadataParser;
import com.google.i18n.phonenumbers.metadata.source.BlockingMetadataBootstrappingGuard;
import com.google.i18n.phonenumbers.metadata.source.MapBackedMetadataContainer;
import com.google.i18n.phonenumbers.metadata.source.MetadataBootstrappingGuard;
import com.google.i18n.phonenumbers.metadata.source.PhoneMetadataFileNameProvider;
import com.google.i18n.phonenumbers.metadata.source.RegionMetadataSource;

public final class RegionMetadataSourceImpl
implements RegionMetadataSource {
    private final PhoneMetadataFileNameProvider phoneMetadataFileNameProvider;
    private final MetadataBootstrappingGuard<MapBackedMetadataContainer<String>> bootstrappingGuard;

    public RegionMetadataSourceImpl(PhoneMetadataFileNameProvider phoneMetadataFileNameProvider, MetadataBootstrappingGuard<MapBackedMetadataContainer<String>> bootstrappingGuard) {
        this.phoneMetadataFileNameProvider = phoneMetadataFileNameProvider;
        this.bootstrappingGuard = bootstrappingGuard;
    }

    public RegionMetadataSourceImpl(PhoneMetadataFileNameProvider phoneMetadataFileNameProvider, MetadataLoader metadataLoader, MetadataParser metadataParser) {
        this(phoneMetadataFileNameProvider, new BlockingMetadataBootstrappingGuard<MapBackedMetadataContainer<String>>(metadataLoader, metadataParser, MapBackedMetadataContainer.byRegionCode()));
    }

    @Override
    public Phonemetadata.PhoneMetadata getMetadataForRegion(String regionCode) {
        if (!GeoEntityUtility.isGeoEntity(regionCode)) {
            throw new IllegalArgumentException(regionCode + " region code is a non-geo entity");
        }
        return this.bootstrappingGuard.getOrBootstrap(this.phoneMetadataFileNameProvider.getFor(regionCode)).getMetadataBy(regionCode);
    }
}

