/* 
    cdplay - A Commandline CD Player         
    Copyright (C) 2000 Robin Redeker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#define START_SIZE 256

void strip_spaces(char *buffer)
{
    int i;
    for (i = strlen(buffer) - 1; i >= 0; i--) {
	if (buffer[i] != ' ') {
	    break;
	} else {
	    buffer[i] = '\0';
	}
    }
}
int dyn_fgets(char **b, FILE * stream)
{
    char c;
    int size = START_SIZE, tmpsize = 0;

    *b = (char *) malloc(sizeof(char) * START_SIZE);
    if (*b == NULL) {
	printf("cdplay: Couldn't malloc\n");
	exit(1);
    }


    while ((c = fgetc(stream))) {
	tmpsize++;
	if (tmpsize == size) {
	    if ((*b = (char *) realloc(*b, sizeof(char) * size * 2)) ==
		NULL) {
		printf("watcher: Couldn't malloc\n"); exit(1);
	    }
	    size *= 2;
	}
	if (c == '\0') {
	    c = ' ';
	}
	if (c == EOF) {
	    (*b)[tmpsize - 1] = '\0';
	    return 0;
	}
	if (c == '\n') {
	    (*b)[tmpsize - 1] = '\0';
	    return 1;
	}
	(*b)[tmpsize - 1] = c;
    }

    printf("watcher: debug: %s\n", *b);
    return 1;
}

