Summary: Network server for controlling gateway link for NAT clients
Name: dwun
Version: 0.96e
Release: 1
Copyright: MIT
Group: System Environment/Daemons
Source: http://download.sourceforge.net/dwun/%{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-buildroot
Prereq: /sbin/chkconfig

%description
Dwun is a program which is usually used by clients behind an IP Masquerading
(NAT) gateway to bring a network link (e.g. modem) up when at least one
person says they want the link to be available, and down when no such clients
remain.
    
It can also be used to run specified commands on behalf of authenticated users,
for example using dwun to control firewall rules.

%prep
%setup -q

%build
./configure --prefix=$RPM_BUILD_ROOT/usr --with-docdir=doc/%{name}-%{version}-%{release}
make

%install
rm -rf $RPM_BUILD_ROOT
make install-strip

mkdir -p $RPM_BUILD_ROOT/etc
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
install -m 644 rpm/dwunrc $RPM_BUILD_ROOT/etc/dwunrc
install -m 600 rpm/dwunauth $RPM_BUILD_ROOT/etc/dwunauth
install -m 755 rpm/dwun.init $RPM_BUILD_ROOT/etc/rc.d/init.d/dwun
if [ -d /etc/ppp/ip-up.d ]; then
	install -D -m 755 rpm/dwun.ip-up $RPM_BUILD_ROOT/etc/ppp/ip-up.d/0dwun
fi

%clean
rm -rf $RPM_BUILD_ROOT

# FIXME: If you install with --excludedocs, the directories under /usr/doc
# will stil be installed. (But not the files).
%files
%config /etc/*
%doc /usr/man/*/*
%doc /usr/doc/%{name}-%{version}-%{release}/*
%dir /usr/doc/%{name}-%{version}-%{release}
/usr/bin/*
/usr/sbin/*

%preun
#!/bin/sh
if [ "$1" -eq 0 ]; then
	/etc/rc.d/init.d/dwun stop >&2
	/sbin/chkconfig --del dwun
fi

%post
#!/bin/sh
/sbin/chkconfig --add dwun

if ( grep -q '/var/run/dwun-log\.pid' /etc/dwunrc ); then
        ( cd /var/run && ln -s dwun-log.pid dwunlog.pid )
fi

if [ -d /etc/ppp/ip-up.d ]; then
	exit 0 # already done
fi
if [ -f /etc/ppp/ip-up.local ]; then
	IP_UP=/etc/ppp/ip-up.local
else
	IP_UP=/etc/ppp/ip-up # If ppp is upgraded, this could get overwritten.
fi
IP_UP_OLD=$IP_UP.dwun-old
if [ -f $IP_UP_OLD ]; then
	exit 0 # already done
fi
# Add script to the beginning of $IP_UP
cp -p $IP_UP $IP_UP_OLD
cat > $IP_UP << 'EOF'
#!/bin/sh
#
# Notify dwun if connection is up.
# Written by Tim Sutherland <timsuth@ihug.co.nz>
#
# Uncomment the CHECKIP line if you want us to ping 198.186.203.55 to check if
# we are properly connected. You may also wish to change the IP address to a
# stable host near to you.
#
# By default we instead ping the remote PPP IP address. Usually this will be
# fine, but occasionally this can succeed while access to the internet at
# large does not.
#

#CHECKIP=198.186.203.55 # linux.com

if [ -n "$CHECKIP" ]; then
	CHECKIP="$CHECKIP"
elif [ -n "$IPREMOTE" ]; then
	CHECKIP="$IPREMOTE"
elif [ -n "$5" ]; then
	CHECKIP="$5"
fi
	
if [ -n "$CHECKIP" ] && ! ping -c 1 "$CHECKIP"
then
	#echo '%con:#Bad connection' > /usr/lib/dwun-msg
	kill -USR2 `cat /var/run/dwun.pid`
	exit 1
fi
kill -USR1 `cat /var/run/dwun.pid`
EOF

# add rest of ip-up back in
sed 1d $IP_UP.dwun-old >> $IP_UP

%postun
if [ "$1" -eq 1 ]; then
	exit 0 # upgrading
fi

COMPAT_PID=/var/run/dwun-log.pid
if [ -L "$COMPAT_PID" ]; then
	rm -f "$COMPAT_PID"
fi

if [ -e /etc/ppp/ip-up.d/0dwun ]; then
	exit 0 # rpm will remove the file
fi
if [ -f /etc/ppp/ip-up.local.dwun-old ]; then
	IP_UP=/etc/ppp/ip-up.local
else
	IP_UP=/etc/ppp/ip-up
fi
IP_UP_OLD=$IP_UP.dwun-old
mv $IP_UP_OLD $IP_UP || true
