#ifndef UTIL_H
# define UTIL_H

#include "bool.h"
#include <stdio.h>
#include <signal.h>

extern bool become_daemon(void);
#define cleanup_fds() cleanup_fds_except(-1)
extern bool cleanup_fds_except(int leave);
extern void notice(const char *format, ...);
extern void notice_errdebug(const char *format, ...);
extern void notice_debug(const char *format, ...);
extern void notice_err(const char *format, ...);
extern bool alloc_copy(char **s, char *msg);
extern void term_strncpy(char *dest, const char *src, size_t n);

extern bool mystrtol(const char *nptr, long int *conv);
extern bool mystrtoi(const char *nptr, int *conv);
extern bool mystrtouc(const char *nptr, u_char *conv);
extern bool mystrtoul(const char *nptr, u_long *conv);
extern bool mystrtous(const char *nptr, unsigned short *conv);

/* A limit of -1 means unlimited. */
#define max_exceeded(count, limit) ((limit)!=-1 && (count) > (limit))
extern pid_t xfork(void);
extern void unblock_all_signals(void);
extern void all_signals(int how, sigset_t *old);
#define block_all_signals(oldpt) all_signals(SIG_BLOCK, (oldpt))
#define unblock_all_signals(oldpt) all_signals(SIG_UNBLOCK, (oldpt))
extern bool sigwrite(int fd, int c);
extern bool sigread(int fd, int *c);
extern pid_t waitpid_noint(pid_t pid, int *status, int options);

void *xmalloc(size_t size);
bool redirect_std(int fd, const char *filename, int flags);
bool cleanup_signals(void);

/* options bitmask */
enum {
	MY_CREATE = 1,
	MY_ALLREAD = 2
};
bool realfile(char **s, char *msg, int options);

#endif
