/*
 * langues.c --- language package.
 *
 * Copyright (c) 1997-2005 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2005-02-18 13:53:22 pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include	"common.h"

#include	"langues.h"

static	eLanguage	Language;
static	char*		Strings[numberOfStrings][numberOfLanguages] =
{
    {"", "", ""},					/* eStrEmpty */
    /* eStrCopyright */
    {"Copyright (C) 1997,98,99,2001-2005 Pascal Wassong",
     "Copyright (C) 1997,98,99,2001-2005 Pascal Wassong",
     "Copyright (C) 1997,98,99,2001-2005 Pascal Wassong"},
    {"RPDTFC", "KPQRBS", "KBDTLS"},		/* eStrInitialOfPieces */
    {"RDTFCCP", "KQRBNSP", "KDTLSSB"},		/* eStrForsytheInitials */
#ifdef __DJGPP__
    {"demi-coups", "single moves", "Halbzgen"},	/* eStrHalfMoves */
#else
    {"demi-coups", "single moves", "Halbzgen"},	/* eStrHalfMoves */
#endif /* not __DJGPP__ */
    {"B=%d N=%d  ", "W=%d B=%d  ", "W=%d S=%d  "},	/* eStrCoupsRestants */
    {"Recherche", "Searching", " Suche   "},		/* eStrRecherche */
    {"position",  "position",  "Stellung"},		/* eStrPosition */
#ifdef __DJGPP__
    {"Solution", "Solution", "Lsung"},		/* eStrSolution */
#else
    {"Solution", "Solution", "Lsung"},			/* eStrSolution */
#endif /* not __DJGPP__ */
#ifdef __DJGPP__
    {"voir solution", "see solution", "sehe Lsung"},/* eStrSeeSolution */
#else
    {"voir solution", "see solution", "sehe Lsung"},	/* eStrSeeSolution */
#endif /* not __DJGPP__ */
    {"Stop? O/N", "Stop? Y/N", "Stop? J/N"},		/* eStrStop */
    {"Suite O/N", "Skip? Y/N", "Skip? J/N"},		/* eStrSkip */
#ifdef __DJGPP__
    {"Temps de rsolution : ",
#else
     {"Temps de rsolution : ",
#endif /* not __DJGPP__ */
      "Resolution time : ",
#ifdef __DJGPP__
      "Lsung zeit : "},		/* eStrResolutionTime */
#else
     "Lsung zeit : "},			/* eStrResolutionTime */
#endif /* not __DJGPP__ */
#ifdef __DJGPP__
    {"La rsolution commence le %s",
#else
     {"La rsolution commence le %s",
#endif /* not __DJGPP__ */
      "The resolution begins at %s",
#ifdef __DJGPP__
      "Anfang der Lsung am %s"},	/* eStrBeginResolution */
#else
     "Anfang der Lsung am %s"},	/* eStrBeginResolution */
#endif /* not __DJGPP__ */
#ifdef __DJGPP__
    {"La rsolution finit le %s",
#else
     {"La rsolution finit le %s",
#endif /* not __DJGPP__ */
      "The resolution ends at %s",
#ifdef __DJGPP__
      "Ende der Lsung am %s"},	/* eStrEndResolution */
#else
     "Ende der Lsung am %s"},		/* eStrEndResolution */
#endif /* not __DJGPP__ */
#ifdef __DJGPP__
    {"La rsolution s'arrte aprs la solution %d",
#else
     {"La rsolution s'arrte aprs la solution %d",
#endif /* not __DJGPP__ */
      "The resolution stops after solution %d",
#ifdef __DJGPP__
      "Ende nach der Lsung %d"},	/* eStrStoppedBySolution */
#else
     "Ende nach der Lsung %d"},	/* eStrStoppedBySolution */
#endif /* not __DJGPP__ */
#ifdef __DJGPP__
    {"La rsolution est interrompue par l'utilisateur  la position %d",
#else
    {"La rsolution est interrompue par l'utilisateur  la position %d",
#endif /* not __DJGPP__ */
     "The resolution is interrupted by the user at position %d",
#ifdef __DJGPP__
     /* eStrStoppedByUser */
     "Der Benutzer hat die Lsung an Stellung %d unterbrochen"},
#else
     /* eStrStoppedByUser */
     "Der Benutzer hat die Lsung an Stellung %d unterbrochen"},
#endif /* not __DJGPP__ */
    { "Nombre de coups blancs : %d\n",
      "Number of white moves : %d\n",
#ifdef __DJGPP__
      "Weisse Zgen Anzahl : %d\n"},	/* eStrNumberOfWhiteMoves */
#else
      "Weisse Zgen Anzahl : %d\n"},	/* eStrNumberOfWhiteMoves */
#endif /* not __DJGPP__ */
    { "Coup %2d : ", "Move %2d : ", "Zug %2d : " },	/* eStrMove */
#ifdef __DJGPP__
    { "%ld solution(s) dj trouve(s).\n",
#else
    { "%ld solution(s) dj trouve(s).\n",
#endif /* not __DJGPP__ */
      "%ld solution(s) already found.\n",
#ifdef __DJGPP__
      "%ld Lsung(eng) schon gefunden.\n" },	/* eStrSolutionsFound */
#else
      "%ld Lsung(eng) schon gefunden.\n" },	/* eStrSolutionsFound */
#endif /* not __DJGPP__ */
#ifdef __DJGPP__
    { "La rsolution continue  la position %ld\n\n",
#else
    { "La rsolution continue  la position %ld\n\n",
#endif /* not __DJGPP__ */
      "Resolution continues at position %ld\n\n",
#ifdef __DJGPP__
      "Lsung geht an Stellung %ld weiter\n\n" },	/* eStrContinueAt */
#else
      "Lsung geht an Stellung %ld weiter\n\n" },	/* eStrContinueAt */
#endif /* not __DJGPP__ */
#ifdef __DJGPP__
    { "La position %ld a t saut par l'utilisateur\n",
#else
    { "La position %ld a t saut par l'utilisateur\n",
#endif /* not __DJGPP__ */
      "Position %ld has been skipped by the user\n",
      "Der Benutzer hat die Stellung %ld ausgelassen\n"},/*eStrPositionSkipped*/
};

static char		Chars[numberOfChars][numberOfLanguages] =
{
    {' ', ' ', ' '},			/* eCharEmpty */
    {'o', 'y', 'j'},			/* eCharYes */
    {'n', 'n', 'n'},			/* eCharNo */
};

void
langSetLanguage(eLanguage langue)
{
    Language = langue;
}

char
langGetChar(eCharId charId)
{
    return (Chars[charId][Language]);
}

const char* const
langGetString(eStringId stringId)
{
    return (Strings[stringId][Language]);
}
