/*
 * pcpj_deb.c --- position searching package.
 *
 * Copyright (c) 1997, 98, 99, 2000, 2001 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2002-12-20 19:32:30 pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include	"common.h"

#include	"pcpj_deb.h"
#include	"types.h"
#include	"pcpj.h"

static void
testCaseInit( int indiceDepart, int* compteur )
{
    square_t	caseInitiale = ListeNonTraitees[indiceDepart].caseInitiale;

    if ( ListeNonTraitees[ indiceDepart ].camp
	 == colour( EchiquierFinal[ caseInitiale ] )
	 && ListeNonTraitees[ indiceDepart ].typePiece
	 == Type_Pieces_Final[ EchiquierFinal[ caseInitiale ] ] )
    {
	ListeImmobiles[ NbImmobiles ] = ListeNonTraitees[ indiceDepart ];
	ListeNonTraitees[ indiceDepart ].caseInitiale    = PIECE_DEJA_TRAITEE;
	ListeImmobiles[ NbImmobiles ].caseArrivee        = caseInitiale;
	ListeImmobiles[ NbImmobiles ].nbDestination      = 1;
	ListeImmobiles[ NbImmobiles ].destination[ 0 ]   = caseInitiale;
	ListeImmobiles[ NbImmobiles ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	ListeImmobiles[ NbImmobiles ].distance[ 0 ]      = 0;
	ListeImmobiles[ NbImmobiles ].has_never_moved    = TRUE ;
	NbImmobiles++;
	(*compteur)++;

	CasesInterdites[ caseInitiale ] = TRUE;
    }
}

/* Cette fonction regarde les pions qui n'ont jamais joues et en deduit
 * la liste des pieces enfermes (F et D).
 * Traite aussi les rois.
 */
void
creeAssociationPieceImmobile()
{
    int		fouDame, fouRoi, dame;

    /* ROI ROI ROI ROI ROI ROI ROI ROI ROI ROI ROI ROI ROI ROI */
    /* ROI ROI ROI ROI ROI ROI ROI ROI ROI ROI ROI ROI ROI ROI */
    ListeSures[ NbSures ] = ListeNonTraitees[ 0 ];
    ListeSures[ NbSures ].caseArrivee
	= Position_Pieces_Blanches_Final[ 0 ];
    ListeSures[ NbSures ].nbDestination = 1;
    ListeSures[ NbSures ].destination[ 0 ]
	= Position_Pieces_Blanches_Final[ 0 ];
    ListeSures[ NbSures ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
    ListeSures[ NbSures ].distance[ 0 ] = 0;
    NbSures++;
    ListeNonTraitees[ 0 ].caseInitiale = PIECE_DEJA_TRAITEE;

    ListeSures[ NbSures ] = ListeNonTraitees[ 16 ];
    ListeSures[ NbSures ].caseArrivee = Position_Pieces_Noires_Final[ 0 ];
    ListeSures[ NbSures ].nbDestination = 1;
    ListeSures[ NbSures ].destination[ 0 ]
	= Position_Pieces_Noires_Final[ 0 ];
    ListeSures[ NbSures ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
    ListeSures[ NbSures ].distance[ 0 ] = 0;
    NbSures++;
    ListeNonTraitees[ 16 ].caseInitiale = PIECE_DEJA_TRAITEE;


    /* BLANC BLANC BLANC BLANC BLANC BLANC BLANC BLANC BLANC */
    /* BLANC BLANC BLANC BLANC BLANC BLANC BLANC BLANC BLANC */

    fouDame = fouRoi = dame = 0;
    testCaseInit(  9, &fouDame ); /* PBb2 */
    testCaseInit( 11, &fouDame ); /* PBd2 */
    testCaseInit( 12, &fouRoi );	/* PBe2 */
    testCaseInit( 14, &fouRoi );	/* PBg2 */

    /* Le Fc1 est-il enferme ? */
    if ( fouDame == 2 )
    {
	if ( is_white( EchiquierFinal[ c1 ] )
	     && Type_Pieces_Final[ EchiquierFinal[ c1 ] ] == FOU )
	{
	    ListeImmobiles[ NbImmobiles ] = ListeNonTraitees[ 3 ];
	    ListeImmobiles[ NbImmobiles ].caseArrivee        = c1;
	    ListeImmobiles[ NbImmobiles ].nbDestination      = 1;
	    ListeImmobiles[ NbImmobiles ].destination[ 0 ]   = c1;
	    ListeImmobiles[ NbImmobiles ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeImmobiles[ NbImmobiles ].distance[ 0 ]      = 0;
	    ListeImmobiles[ NbImmobiles ].has_never_moved    = TRUE ;
	    NbImmobiles++;

	    fouDame++;
	    CasesInterdites[ c1 ] = TRUE;
	}
	else
	{
	    ListeSures[ NbSures ] = ListeNonTraitees[ 3 ];
	    ListeSures[ NbSures ].caseArrivee        = c1;
	    ListeSures[ NbSures ].nbDestination      = 1;
	    ListeSures[ NbSures ].destination[ 0 ]   = c1;
	    ListeSures[ NbSures ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeSures[ NbSures ].distance[ 0 ]      = 0;
	    ListeSures[ NbSures ].pieceCapturante
		= PIECE_CAPTURANTE_INCONNUE;
	    ListeSures[ NbSures ].has_never_moved    = TRUE ;
	    NbSures++;
	}
	ListeNonTraitees[ 3 ].caseInitiale = PIECE_DEJA_TRAITEE;
    }

    /* Le Ff1 est-il enferme ? */
    if ( fouRoi == 2 )
    {
	if ( is_white( EchiquierFinal[ f1 ] )
	     && Type_Pieces_Final[ EchiquierFinal[ f1 ] ] == FOU )
	{
	    ListeImmobiles[ NbImmobiles ] = ListeNonTraitees[ 5 ];
	    ListeImmobiles[ NbImmobiles ].caseArrivee        = f1;
	    ListeImmobiles[ NbImmobiles ].nbDestination      = 1;
	    ListeImmobiles[ NbImmobiles ].destination[0]     = f1;
	    ListeImmobiles[ NbImmobiles ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeImmobiles[ NbImmobiles ].distance[ 0 ]      = 0;
	    ListeImmobiles[ NbImmobiles ].has_never_moved    = TRUE ;
	    NbImmobiles++;

	    fouRoi++;
	    CasesInterdites[ f1 ] = TRUE;
	}
	else
	{
	    ListeSures[ NbSures ] = ListeNonTraitees[ 5 ];
	    ListeSures[ NbSures ].caseArrivee        = f1;
	    ListeSures[ NbSures ].nbDestination      = 1;
	    ListeSures[ NbSures ].destination[ 0 ]   = f1;
	    ListeSures[ NbSures ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeSures[ NbSures ].distance[ 0 ]      = 0;
	    ListeSures[ NbSures ].pieceCapturante
		= PIECE_CAPTURANTE_INCONNUE;
	    ListeSures[ NbSures ].has_never_moved    = TRUE ;
	    NbSures++;
	}
	ListeNonTraitees[ 5 ].caseInitiale = PIECE_DEJA_TRAITEE;
    }

    dame = fouDame + fouRoi;
    testCaseInit( 10, &dame );	/* PBc2 */
    testCaseInit( 13, &dame );	/* PBf2 */

    /* Le Dd1 est-elle enfermee ? */
    if ( dame == 8 )
    {
	if ( is_white( EchiquierFinal[ d1 ] )
	     && Type_Pieces_Final[ EchiquierFinal[ d1 ] ] == DAME )
	{
	    ListeSures[ 0 ].has_never_moved = TRUE;

	    ListeImmobiles[ NbImmobiles ] = ListeNonTraitees[ 4 ];
	    ListeImmobiles[ NbImmobiles ].caseArrivee        = d1;
	    ListeImmobiles[ NbImmobiles ].nbDestination      = 1;
	    ListeImmobiles[ NbImmobiles ].destination[ 0 ]   = d1;
	    ListeImmobiles[ NbImmobiles ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeImmobiles[ NbImmobiles ].distance[ 0 ]      = 0;
	    ListeImmobiles[ NbImmobiles ].has_never_moved    = TRUE ;
	    NbImmobiles++;

	    dame++;
	    CasesInterdites[ d1 ] = TRUE;
	    /* Il ne faut pas interdire la case e1 sinon un CN peut jouer
	     * en d3 et f3 sans donner echec. Cela n'a pas d'autre influence.
	     */
	    /*CasesInterdites[ e1 ] = TRUE;*/
	}
	else
	{
	    ListeSures[ NbSures ] = ListeNonTraitees[ 4 ];
	    ListeSures[ NbSures ].caseArrivee        = d1;
	    ListeSures[ NbSures ].nbDestination      = 1;
	    ListeSures[ NbSures ].destination[ 0 ]   = d1;
	    ListeSures[ NbSures ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeSures[ NbSures ].distance[ 0 ]      = 0;
	    ListeSures[ NbSures ].pieceCapturante
		= PIECE_CAPTURANTE_INCONNUE;
	    ListeSures[ NbSures ].has_never_moved    = TRUE ;
	    NbSures++;
	}
	ListeNonTraitees[ 4 ].caseInitiale = PIECE_DEJA_TRAITEE;
    }

    testCaseInit(  8, &fouDame ); /* PBa2 */
    testCaseInit( 15, &fouRoi );	/* PBh2 */

    /* NOIR NOIR NOIR NOIR NOIR NOIR NOIR NOIR NOIR NOIR NOIR NOIR */
    /* NOIR NOIR NOIR NOIR NOIR NOIR NOIR NOIR NOIR NOIR NOIR NOIR */

    fouDame = fouRoi = dame = 0;
    testCaseInit( 25, &fouDame );	/* PNb7 */
    testCaseInit( 27, &fouDame );	/* PNd7 */
    testCaseInit( 28, &fouRoi );	/* PNe7 */
    testCaseInit( 30, &fouRoi );	/* PNg7 */

    /* Le FNc8 est-il enferme ? */
    if ( fouDame == 2 )
    {
	if ( is_black( EchiquierFinal[ c8 ] )
	     && Type_Pieces_Final[ EchiquierFinal[ c8 ] ] == FOU )
	{
	    ListeImmobiles[ NbImmobiles ] = ListeNonTraitees[ 19 ];
	    ListeImmobiles[ NbImmobiles ].caseArrivee        = c8;
	    ListeImmobiles[ NbImmobiles ].nbDestination      = 1;
	    ListeImmobiles[ NbImmobiles ].destination[ 0 ]   = c8;
	    ListeImmobiles[ NbImmobiles ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeImmobiles[ NbImmobiles ].distance[ 0 ]      = 0;
	    ListeImmobiles[ NbImmobiles ].has_never_moved    = TRUE ;
	    NbImmobiles++;

	    fouDame++;
	    CasesInterdites[ c8 ] = TRUE;
	}
	else
	{
	    ListeSures[ NbSures ] = ListeNonTraitees[ 19 ];
	    ListeSures[ NbSures ].caseArrivee        = c8;
	    ListeSures[ NbSures ].nbDestination      = 1;
	    ListeSures[ NbSures ].destination[ 0 ]   = c8;
	    ListeSures[ NbSures ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeSures[ NbSures ].distance[ 0 ]      = 0;
	    ListeSures[ NbSures ].pieceCapturante
		= PIECE_CAPTURANTE_INCONNUE;
	    ListeSures[ NbSures ].has_never_moved    = TRUE ;
	    NbSures++;
	}
	ListeNonTraitees[ 19 ].caseInitiale = PIECE_DEJA_TRAITEE;
    }

    /* Le FNf8 est-il enferme ? */
    if ( fouRoi == 2 )
    {
	if ( is_black( EchiquierFinal[ f8 ] )
	     && Type_Pieces_Final[ EchiquierFinal[ f8 ] ] == FOU )
	{
	    ListeImmobiles[ NbImmobiles ] = ListeNonTraitees[ 21 ];
	    ListeImmobiles[ NbImmobiles ].caseArrivee        = f8;
	    ListeImmobiles[ NbImmobiles ].nbDestination      = 1;
	    ListeImmobiles[ NbImmobiles ].destination[ 0 ]   = f8;
	    ListeImmobiles[ NbImmobiles ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeImmobiles[ NbImmobiles ].distance[ 0 ]      = 0;
	    ListeImmobiles[ NbImmobiles ].has_never_moved    = TRUE ;
	    NbImmobiles++;

	    fouRoi++;
	    CasesInterdites[ f8 ] = TRUE;
	}
	else
	{
	    ListeSures[ NbSures ] = ListeNonTraitees[ 21 ];
	    ListeSures[ NbSures ].caseArrivee        = f8;
	    ListeSures[ NbSures ].nbDestination      = 1;
	    ListeSures[ NbSures ].destination[ 0 ]   = f8;
	    ListeSures[ NbSures ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeSures[ NbSures ].distance[ 0 ]      = 0;
	    ListeSures[ NbSures ].pieceCapturante
		= PIECE_CAPTURANTE_INCONNUE;
	    ListeSures[ NbSures ].has_never_moved    = TRUE ;
	    NbSures++;
	}
	ListeNonTraitees[ 21 ].caseInitiale = PIECE_DEJA_TRAITEE;
    }

    dame = fouDame + fouRoi;
    testCaseInit( 26, &dame ); /* PNc7 */
    testCaseInit( 29, &dame ); /* PNf7 */

    /* La DNd8 est-elle enfermee ? */
    if ( dame == 8 )
    {
	if ( is_black( EchiquierFinal[ d8 ] )
	     && Type_Pieces_Final[ EchiquierFinal[ d8 ] ] == DAME )
	{
	    ListeSures[ 1 ].has_never_moved = TRUE;

	    ListeImmobiles[ NbImmobiles ] = ListeNonTraitees[ 20 ];
	    ListeImmobiles[ NbImmobiles ].caseArrivee        = d8;
	    ListeImmobiles[ NbImmobiles ].nbDestination      = 1;
	    ListeImmobiles[ NbImmobiles ].destination[ 0 ]   = d8;
	    ListeImmobiles[ NbImmobiles ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeImmobiles[ NbImmobiles ].distance[ 0 ]      = 0;
	    ListeImmobiles[ NbImmobiles ].has_never_moved    = TRUE ;
	    NbImmobiles++;

	    dame++;
	    CasesInterdites[ d8 ] = TRUE;
	    /* Il ne faut pas interdire la case e8 sinon un CB peut jouer
	     * en d6 et f6 sans donner echec. Cela n'a pas d'autre influence.
	     */
	    /*CasesInterdites[ e8 ] = TRUE;*/
	}
	else
	{
	    ListeSures[ NbSures ] = ListeNonTraitees[ 20 ];
	    ListeSures[ NbSures ].caseArrivee        = d8;
	    ListeSures[ NbSures ].nbDestination      = 1;
	    ListeSures[ NbSures ].destination[ 0 ]   = d8;
	    ListeSures[ NbSures ].pieceCapturee[ 0 ] = PAS_DE_CAPTURE;
	    ListeSures[ NbSures ].distance[ 0 ]      = 0;
	    ListeSures[ NbSures ].pieceCapturante
		= PIECE_CAPTURANTE_INCONNUE;
	    ListeSures[ NbSures ].has_never_moved    = TRUE ;
	    NbSures++;
	}
	ListeNonTraitees[ 20 ].caseInitiale = PIECE_DEJA_TRAITEE;
    }

    testCaseInit( 24, &fouDame ); /* PNa7 */
    testCaseInit( 31, &fouRoi );  /* PNh7 */
}

/* Cette fonction cherche a determiner de maniere unique l'origine
 * des pions. Les cas traites sont : PBh2->h2, PBg2->h3 ou bien
 * PBg2->g2, PBh2->h3.
 * Un cas non traites est par exemple : PBa3, b3, b4, c2. Le lien
 * PBd2->b4 n'est pas fait.
 * En fait cette fonction n'est pas tres importante, puisque les cas
 * seraient traites tres rapidement par la fonction recursive.
 */
void
creeAssociationPions()
{
    bool_t	modif, dejaVu;
    square_t	square;
    int		j, rangee, colonne;
    int		nbCapture;

    do
    {
	modif = FALSE;

	/* Cherche des pions qui se sont deplaces sans promotion */
	for ( square = a2 ; square <= h7 ; square++ )
	{
	    if ( CASE_OK( square )
		 && Type_Pieces_Final[ EchiquierFinal[ square ] ] == PION )
	    {
		rangee  = row( square ) >> 4;
		colonne = column( square );
		if ( is_white( EchiquierFinal[ square ] ) && rangee > 1 )
		{
		    rangee--;

		    /* S'il n'a pas encore d'association */
		    dejaVu = FALSE;
		    for ( j = 0 ; j < NbSures ; j++ )
		    {
			if ( ListeSures[ j ].caseArrivee == square )
			{
			    dejaVu = TRUE;
			    break;
			}
		    }

		    if ( !dejaVu )
		    {
			int		nbPossible = 0;
			int		indice     = -1;
			for ( j = 8 + colonne - rangee ;
			      j <= 8 + colonne + rangee ;
			      j++ )
			{
			    if ( j > 7 && j < 16 )
			    {
				/* Verifie s'il reste assez de pieces ennemis
				 * a capturer pour atteindre la colonne.
				 */
				if ( j - 8 > colonne )
				{
				    nbCapture = ( j - 8 ) - colonne;
				}
				else
				{
				    nbCapture = colonne - ( j - 8 );
				}
				if ( ( nbCapture <= NbResteACapturerNoires )
				     && ( ListeNonTraitees[ j ].caseInitiale
					  != 0xFE ) )
				{
				    indice = j;
				    nbPossible++;
				}
			    }
			}
			if ( nbPossible == 1 )
			{
			    int		depX, arrX;

			    ListeSures[ NbSures ] = ListeNonTraitees[ indice ];
			    ListeSures[ NbSures ].caseArrivee        = square;
			    ListeSures[ NbSures ].nbDestination      = 1;
			    ListeSures[ NbSures ].destination[ 0 ]   = square;
			    ListeSures[ NbSures ].pieceCapturee[ 0 ]
				= PAS_DE_CAPTURE;
			    ListeSures[ NbSures ].distance[ 0 ]      = 0;
			    ListeNonTraitees[ indice ].caseInitiale
				= PIECE_DEJA_TRAITEE;

			    /* NbResteACapturerNoires est suffisemment
			     * grand sinon la position est impossible !!
			     */
			    arrX = column( ListeSures[ NbSures ].caseArrivee );
			    depX = column( ListeSures[ NbSures ].caseInitiale );
			    nbCapture = ( arrX > depX )
				? arrX - depX : depX - arrX;
			    NbResteACapturerNoires -= nbCapture;
			    ListeSures[ NbSures ].nb_captures = nbCapture;

			    NbSures++;
			    modif = TRUE;
			}
		    }
		}
		else if ( is_black( EchiquierFinal[ square ] ) && rangee < 6 )
		{
		    rangee = ( rangee ^ 0x07 ) - 1;

		    /* S'il n'a pas encore d'association */
		    dejaVu = FALSE;
		    for ( j = 0 ; j < NbSures ; j++ )
		    {
			if ( ListeSures[ j ].caseArrivee == square )
			{
			    dejaVu = TRUE;
			    break;
			}
		    }

		    if ( !dejaVu )
		    {
			int		nbPossible = 0;
			int		indice     = -1;
			for ( j = 24 + colonne - rangee ;
			      j <= 24 + colonne + rangee ;
			      j++ )
			{
			    if ( j > 23 && j < 32 )
			    {
				/* Verifie s'il reste assez de pieces ennemis
				 * a capturer pour atteindre la colonne.
				 */
				if ( j - 24 > colonne )
				{
				    nbCapture = ( j - 24 ) - colonne;
				}
				else
				{
				    nbCapture = colonne - ( j - 24 );
				}
				if ( ( nbCapture <= NbResteACapturerBlanches )
				     && ( ListeNonTraitees[ j ].caseInitiale
					  != PIECE_DEJA_TRAITEE ) )
				{
				    indice = j;
				    nbPossible++;
				}
			    }
			}
			if ( nbPossible == 1 )
			{
			    int		depX, arrX;

			    ListeSures[ NbSures ] = ListeNonTraitees[ indice ];
			    ListeSures[ NbSures ].caseArrivee        = square;
			    ListeSures[ NbSures ].nbDestination      = 1;
			    ListeSures[ NbSures ].destination[ 0 ]   = square;
			    ListeSures[ NbSures ].pieceCapturee[ 0 ]
				= PAS_DE_CAPTURE;
			    ListeSures[ NbSures ].distance[ 0 ]      = 0;
			    ListeNonTraitees[ indice ].caseInitiale
				= PIECE_DEJA_TRAITEE;

			    /* NbResteACapturerBlanches est suffisemment
			     * grand sinon la position est impossible !!
			     */
			    arrX = column( ListeSures[ NbSures ].caseArrivee );
			    depX = column( ListeSures[ NbSures ].caseInitiale );
			    nbCapture = ( arrX > depX )
				? arrX - depX : depX - arrX;
			    NbResteACapturerBlanches -= nbCapture;
			    ListeSures[ NbSures ].nb_captures = nbCapture;

			    NbSures++;
			    modif = TRUE;
			}
		    }
		}
	    }
	}
    } while ( modif );
}
