/*
 * twin_squares.h --- twin squares package
 *
 * Copyright (c) 2001, 2002 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2002-05-05 18:05:43 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef TWIN_SQUARE_H
#define	TWIN_SQUARE_H

#include	"types.h"

void		create_twin_squares(
    const piece_t*	pieces,
    unsigned int	nb_pieces );

square_t	find_twin_square(
    square_t		square,
    bool_t		orthogonal,
    piece_type_t	type,
    colour_t		colour);

extern square_t	No_Twin_Square ;

#endif /* TWIN_SQUARE_H */
