/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.contrib.demo;

import com.sun.jna.platform.dnd.DragHandler;
import com.sun.jna.platform.dnd.DropHandler;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class GhostedDragImageDemo {
    public static void main(String[] args) {
        try {
            System.setProperty("sun.java2d.noddraw", "true");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame f1 = new JFrame("Drag this");
            JFrame f2 = new JFrame("Over here");
            URL url = GhostedDragImageDemo.class.getResource("toucan.png");
            if (url == null) {
                throw new RuntimeException("Icon not found");
            }
            ImageIcon icon = new ImageIcon(url);
            f1.getContentPane().add(new DragLabel(icon));
            DragLabel label2 = new DragLabel(icon);
            f2.getContentPane().add(label2);
            f1.setLocation(100, 100);
            f1.pack();
            f1.setDefaultCloseOperation(3);
            f2.setLocation(300, 100);
            f2.pack();
            ((JLabel)label2).setIcon(null);
            f2.setDefaultCloseOperation(3);
            f2.setVisible(true);
            f1.setVisible(true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static class DragLabel
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private boolean dragging;

        public DragLabel(Icon icon) {
            super(icon);
            new DragHandler(this, 3){

                @Override
                protected Icon getDragIcon(DragGestureEvent e, Point imageOffset) {
                    DragLabel.this.dragging = true;
                    return DragLabel.this.getIcon();
                }

                @Override
                public void dragDropEnd(DragSourceDropEvent e) {
                    super.dragDropEnd(e);
                    if (e.getDropSuccess() && this.getDropAction(e) == 2 && DragLabel.this.dragging) {
                        DragLabel.this.setIcon(null);
                        DragLabel.this.dragging = false;
                    }
                }

                @Override
                protected Transferable getTransferable(DragGestureEvent e) {
                    ImageIcon icon = (ImageIcon)DragLabel.this.getIcon();
                    if (icon != null) {
                        return new ImageSelection(icon.getImage());
                    }
                    return null;
                }
            };
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            new DropHandler(this, 3, flavors){

                @Override
                protected void drop(DropTargetDropEvent e, int action) throws UnsupportedFlavorException, IOException {
                    Image image = (Image)e.getTransferable().getTransferData(DataFlavor.imageFlavor);
                    DragLabel.this.dragging = false;
                    DragLabel.this.setIcon(new ImageIcon(image));
                }
            };
        }

        @Override
        public void setIcon(Icon icon) {
            super.setIcon(icon);
            if (icon == null) {
                this.setText("Empty");
            } else {
                this.setText(null);
            }
        }
    }

    public static class ImageSelection
    implements Transferable,
    ClipboardOwner {
        public static final DataFlavor IMAGE_FLAVOR = DataFlavor.imageFlavor;
        private static final DataFlavor[] FLAVORS = new DataFlavor[]{IMAGE_FLAVOR};
        private Image image;

        public ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return this.isDataFlavorSupported(flavor) ? this.image : null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return FLAVORS;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(IMAGE_FLAVOR);
        }
    }
}

