/* Bongard dataset from
L. De Raedt and W. Van Laer. Inductive constraint logic.
In Klaus P. Jantke, Takeshi Shinohara, and Thomas Zeugmann, editors,
Proceedings of the Sixth International Workshop on Algorithmic
Learning Theory, volume 997 of Lecture Notes in Artificial Intelligence,
pages 80-94. SpringerVerlag, 1995.

Downloaded from
https://dtai.cs.kuleuven.be/static/ACE/doc/
*/

/** <examples>
?- induce_par([train],P),test(P,[test],LL,AUCROC,ROC,AUCPR,PR). % learn the parameteters and test the result
?- induce([train],P),test(P,[test],LL,AUCROC,ROC,AUCPR,PR). % learn the structure and the parameters and test the result
?- in(P),test(P,[test],LL,AUCROC,ROC,AUCPR,PR). % test the input theory
?- induce_par([all],P).
?- induce([all],P).
*/
:-use_module(library(slipcover)).

:- if(current_predicate(use_rendering/1)).
:- use_rendering(c3).
:- use_rendering(lpad).
:- endif.

:-sc.

:- set_sc(megaex_bottom,20).
:- set_sc(max_iter,3).
:- set_sc(max_iter_structure,10).
:- set_sc(maxdepth_var,4).
:- set_sc(verbosity,1).

bg([]).

in([
(
 pos:0.5 :-
 	circle(A),
 	in(B,A)
),
(
 pos:0.5 :-
 	circle(A),
 	triangle(B)
)]).

fold(train,[2,3,5,6,9,12,14,15,17,20,24,25,28,29,31,36,37,40,41,50,52,55,56,57,
  59,62,63,65,66,67,69,74,76,77,79,83,93,95,99,101,103,104,105,106,107,109,110,
  111,112,117,120,121,125,126,127,128,131,135,137,140,143,144,151,154,155,156,
  159,167,168,169,172,175,176,177,178,181,184,188,190,192,193,194,196,198,202,
  206,208,209,211,214,219,222,223,224,225,227,230,231,233,238,241,243,244,248,
  249,250,256,258,260,268,270,273,280,282,286,287,288,289,290,295,300,301,303,
  304,307,309,314,316,319,321,324,326,327,328,329,331,334,337,343,345,348,352,
  353,355,358,366,369,370,373,375,376,378,379,381,382,390,393,402,404,408,411,
  412,416,417,419,420,421,424,425,427,428,431,432,433,437,444,445,447,453,456,
  457,459,462,463,464,465,468,470,473,474,476,477,479,481,482,483,485,488,489]).

fold(test,
  [490,491,494,497,499,500,512,513,516,517,520,521,527,529,531,533,534,539,540,
  542,543,544,546,550,552,553,555,559,565,567,568,572,578,582,583,591,595,597,
  600,602,609,612,614,615,616,617,622,625,628,634,635,637,639,640,641,642,647,
  648,649,650,654,656,657,658,662,667,669,671,679,682,683,685,686,691,693,698,
  700,701,705,708,709,710,719,722,723,725,728,732,734,737,740,741,743,744,745,
  747,748,750,751,753,754,755,765,766,768,769,772,773,777,779,780,781,787,794,
  795,797,803,805,807,814,815,816,818,819,822,829,832,833,835,836,837,838,841,
  844,845,846,847,848,849,856,859,862,864,867,872,874,876,880,882,887,890,892,
  893,897,899,900,904,909,910,912,915,917,926,927,929,930,931,932,933,938,939,
  940,941,944,945,946,947,955,957,961,971,973,974,975,977,978,979,984,989,991,
  995,997,1000]).

fold(all,F):-
  fold(train,FTr),
  fold(test,FTe),
  append(FTr,FTe,F).


output(pos/0).

input_cw(triangle/1).
input_cw(square/1).
input_cw(circle/1).
input_cw(in/2).
input_cw(config/2).

determination(pos/0,triangle/1).
determination(pos/0,square/1).
determination(pos/0,circle/1).
determination(pos/0,in/2).
determination(pos/0,config/2).

modeh(*,pos).
modeb(*,triangle(-obj)).
modeb(*,square(-obj)).
modeb(*,circle(-obj)).
modeb(*,in(+obj,-obj)).
modeb(*,in(-obj,+obj)).
modeb(*,config(+obj,-#dir)).

begin(model(2)).
pos.
triangle(o5).
config(o5,up).
square(o4).
in(o4,o5).
circle(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(2)).

begin(model(3)).
neg(pos).
circle(o4).
circle(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(3)).

begin(model(5)).
neg(pos).
square(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(5)).

begin(model(6)).
pos.
triangle(o5).
config(o5,down).
triangle(o4).
config(o4,up).
in(o4,o5).
circle(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(6)).

begin(model(9)).
pos.
circle(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,down).
square(o1).
in(o1,o2).
end_mod(model(9)).

begin(model(12)).
neg(pos).
triangle(o5).
config(o5,down).
square(o4).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(12)).

begin(model(14)).
neg(pos).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(14)).

begin(model(15)).
neg(pos).
triangle(o4).
config(o4,down).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(15)).

begin(model(17)).
pos.
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(17)).

begin(model(20)).
pos.
triangle(o6).
config(o6,up).
triangle(o5).
config(o5,up).
in(o5,o6).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(20)).

begin(model(24)).
pos.
triangle(o4).
config(o4,up).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(24)).

begin(model(25)).
neg(pos).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(25)).

begin(model(28)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(28)).

begin(model(29)).
neg(pos).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(29)).

begin(model(31)).
neg(pos).
circle(o4).
square(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(31)).

begin(model(36)).
neg(pos).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(36)).

begin(model(37)).
neg(pos).
square(o6).
circle(o5).
in(o5,o6).
square(o4).
circle(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(37)).

begin(model(40)).
neg(pos).
circle(o4).
square(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(40)).

begin(model(41)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(41)).

begin(model(50)).
pos.
triangle(o6).
config(o6,up).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,down).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(50)).

begin(model(52)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(52)).

begin(model(55)).
neg(pos).
triangle(o2).
config(o2,down).
square(o1).
in(o1,o2).
end_mod(model(55)).

begin(model(56)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(56)).

begin(model(57)).
neg(pos).
circle(o4).
circle(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(57)).

begin(model(59)).
neg(pos).
square(o5).
triangle(o4).
config(o4,up).
in(o4,o5).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(59)).

begin(model(62)).
pos.
triangle(o5).
config(o5,up).
triangle(o4).
config(o4,down).
in(o4,o5).
triangle(o3).
config(o3,up).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(62)).

begin(model(63)).
neg(pos).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(63)).

begin(model(65)).
neg(pos).
circle(o6).
circle(o5).
in(o5,o6).
circle(o4).
circle(o3).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(65)).

begin(model(66)).
neg(pos).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(66)).

begin(model(67)).
neg(pos).
circle(o4).
circle(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(67)).

begin(model(69)).
pos.
circle(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(69)).

begin(model(74)).
pos.
circle(o6).
triangle(o5).
config(o5,up).
in(o5,o6).
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(74)).

begin(model(76)).
pos.
square(o6).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(76)).

begin(model(77)).
neg(pos).
square(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
square(o1).
end_mod(model(77)).

begin(model(79)).
pos.
triangle(o5).
config(o5,up).
triangle(o4).
config(o4,down).
in(o4,o5).
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,up).
in(o2,o3).
square(o1).
end_mod(model(79)).

begin(model(83)).
pos.
triangle(o3).
config(o3,up).
triangle(o2).
config(o2,down).
in(o2,o3).
square(o1).
end_mod(model(83)).

begin(model(93)).
neg(pos).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(93)).

begin(model(95)).
pos.
circle(o6).
square(o5).
in(o5,o6).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(95)).

begin(model(99)).
neg(pos).
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(99)).

begin(model(101)).
neg(pos).
square(o6).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,down).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(101)).

begin(model(103)).
pos.
circle(o4).
square(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(103)).

begin(model(104)).
pos.
circle(o5).
triangle(o4).
config(o4,up).
in(o4,o5).
circle(o3).
square(o2).
in(o2,o3).
circle(o1).
end_mod(model(104)).

begin(model(105)).
neg(pos).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(105)).

begin(model(106)).
pos.
triangle(o5).
config(o5,up).
triangle(o4).
config(o4,up).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(106)).

begin(model(107)).
pos.
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(107)).

begin(model(109)).
neg(pos).
square(o4).
circle(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(109)).

begin(model(110)).
neg(pos).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(110)).

begin(model(111)).
neg(pos).
square(o6).
circle(o5).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(111)).

begin(model(112)).
neg(pos).
square(o4).
circle(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(112)).

begin(model(117)).
neg(pos).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(117)).

begin(model(120)).
pos.
circle(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(120)).

begin(model(121)).
neg(pos).
triangle(o3).
config(o3,down).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(121)).

begin(model(125)).
neg(pos).
circle(o4).
circle(o3).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(125)).

begin(model(126)).
neg(pos).
circle(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(126)).

begin(model(127)).
neg(pos).
triangle(o3).
config(o3,up).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(127)).

begin(model(128)).
neg(pos).
circle(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(128)).

begin(model(131)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(131)).

begin(model(135)).
pos.
triangle(o5).
config(o5,down).
triangle(o4).
config(o4,up).
in(o4,o5).
triangle(o3).
config(o3,down).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(135)).

begin(model(137)).
neg(pos).
square(o6).
circle(o5).
in(o5,o6).
circle(o4).
circle(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(137)).

begin(model(140)).
neg(pos).
square(o3).
triangle(o2).
config(o2,down).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(140)).

begin(model(143)).
neg(pos).
circle(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(143)).

begin(model(144)).
neg(pos).
triangle(o5).
config(o5,down).
circle(o4).
in(o4,o5).
square(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(144)).

begin(model(151)).
neg(pos).
circle(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(151)).

begin(model(154)).
neg(pos).
circle(o4).
square(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(154)).

begin(model(155)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(155)).

begin(model(156)).
neg(pos).
square(o6).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(156)).

begin(model(159)).
neg(pos).
triangle(o6).
config(o6,up).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(159)).

begin(model(167)).
pos.
circle(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(167)).

begin(model(168)).
pos.
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,down).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(168)).

begin(model(169)).
neg(pos).
triangle(o6).
config(o6,up).
square(o5).
in(o5,o6).
circle(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(169)).

begin(model(172)).
neg(pos).
square(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(172)).

begin(model(175)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(175)).

begin(model(176)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
circle(o3).
square(o2).
in(o2,o3).
circle(o1).
end_mod(model(176)).

begin(model(177)).
neg(pos).
circle(o4).
circle(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(177)).

begin(model(178)).
pos.
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(178)).

begin(model(181)).
neg(pos).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(181)).

begin(model(184)).
neg(pos).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(184)).

begin(model(188)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(188)).

begin(model(190)).
neg(pos).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(190)).

begin(model(192)).
pos.
circle(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(192)).

begin(model(193)).
neg(pos).
triangle(o4).
config(o4,up).
circle(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(193)).

begin(model(194)).
neg(pos).
circle(o4).
square(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(194)).

begin(model(196)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(196)).

begin(model(198)).
pos.
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,down).
in(o2,o3).
square(o1).
end_mod(model(198)).

begin(model(202)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
square(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(202)).

begin(model(206)).
neg(pos).
circle(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(206)).

begin(model(208)).
neg(pos).
square(o4).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(208)).

begin(model(209)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(209)).

begin(model(211)).
pos.
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(211)).

begin(model(214)).
pos.
triangle(o5).
config(o5,down).
square(o4).
in(o4,o5).
circle(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(214)).

begin(model(219)).
pos.
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(219)).

begin(model(222)).
pos.
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(222)).

begin(model(223)).
pos.
circle(o6).
circle(o5).
in(o5,o6).
circle(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(223)).

begin(model(224)).
pos.
circle(o6).
square(o5).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(224)).

begin(model(225)).
pos.
circle(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(225)).

begin(model(227)).
pos.
circle(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
circle(o1).
end_mod(model(227)).

begin(model(230)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
square(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(230)).

begin(model(231)).
pos.
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(231)).

begin(model(233)).
neg(pos).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(233)).

begin(model(238)).
pos.
triangle(o5).
config(o5,up).
triangle(o4).
config(o4,down).
in(o4,o5).
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,up).
in(o2,o3).
circle(o1).
end_mod(model(238)).

begin(model(241)).
neg(pos).
triangle(o5).
config(o5,up).
circle(o4).
in(o4,o5).
square(o3).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(241)).

begin(model(243)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(243)).

begin(model(244)).
pos.
square(o5).
square(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,down).
in(o2,o3).
square(o1).
end_mod(model(244)).

begin(model(248)).
pos.
circle(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(248)).

begin(model(249)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
square(o3).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(249)).

begin(model(250)).
neg(pos).
square(o6).
circle(o5).
in(o5,o6).
circle(o4).
square(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(250)).

begin(model(256)).
pos.
circle(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(256)).

begin(model(258)).
pos.
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,down).
in(o3,o4).
circle(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(258)).

begin(model(260)).
pos.
square(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(260)).

begin(model(268)).
neg(pos).
square(o5).
circle(o4).
in(o4,o5).
circle(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(268)).

begin(model(270)).
pos.
circle(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(270)).

begin(model(273)).
neg(pos).
square(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(273)).

begin(model(280)).
neg(pos).
square(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(280)).

begin(model(282)).
pos.
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(282)).

begin(model(286)).
neg(pos).
triangle(o4).
config(o4,down).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
square(o1).
in(o1,o2).
end_mod(model(286)).

begin(model(287)).
neg(pos).
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(287)).

begin(model(288)).
pos.
circle(o5).
triangle(o4).
config(o4,up).
in(o4,o5).
circle(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(288)).

begin(model(289)).
neg(pos).
triangle(o6).
config(o6,up).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(289)).

begin(model(290)).
neg(pos).
triangle(o5).
config(o5,down).
circle(o4).
in(o4,o5).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(290)).

begin(model(295)).
pos.
circle(o6).
triangle(o5).
config(o5,down).
in(o5,o6).
triangle(o4).
config(o4,down).
triangle(o3).
config(o3,down).
in(o3,o4).
circle(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(295)).

begin(model(300)).
neg(pos).
square(o3).
triangle(o2).
config(o2,down).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(300)).

begin(model(301)).
neg(pos).
square(o6).
triangle(o5).
config(o5,up).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(301)).

begin(model(303)).
neg(pos).
circle(o3).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(303)).

begin(model(304)).
neg(pos).
square(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(304)).

begin(model(307)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(307)).

begin(model(309)).
neg(pos).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(309)).

begin(model(314)).
pos.
square(o5).
triangle(o4).
config(o4,down).
in(o4,o5).
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,down).
in(o2,o3).
circle(o1).
end_mod(model(314)).

begin(model(316)).
neg(pos).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(316)).

begin(model(319)).
pos.
triangle(o5).
config(o5,down).
triangle(o4).
config(o4,down).
in(o4,o5).
square(o3).
square(o2).
in(o2,o3).
circle(o1).
end_mod(model(319)).

begin(model(321)).
neg(pos).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(321)).

begin(model(324)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(324)).

begin(model(326)).
neg(pos).
square(o6).
circle(o5).
in(o5,o6).
circle(o4).
square(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(326)).

begin(model(327)).
neg(pos).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(327)).

begin(model(328)).
neg(pos).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(328)).

begin(model(329)).
neg(pos).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(329)).

begin(model(331)).
pos.
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(331)).

begin(model(334)).
neg(pos).
triangle(o4).
config(o4,up).
circle(o3).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(334)).

begin(model(337)).
neg(pos).
circle(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
square(o1).
in(o1,o2).
end_mod(model(337)).

begin(model(343)).
pos.
triangle(o6).
config(o6,down).
triangle(o5).
config(o5,up).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(343)).

begin(model(345)).
pos.
circle(o5).
triangle(o4).
config(o4,up).
in(o4,o5).
circle(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
square(o1).
end_mod(model(345)).

begin(model(348)).
neg(pos).
square(o4).
square(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(348)).

begin(model(352)).
neg(pos).
triangle(o6).
config(o6,down).
circle(o5).
in(o5,o6).
triangle(o4).
config(o4,up).
circle(o3).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(352)).

begin(model(353)).
neg(pos).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(353)).

begin(model(355)).
neg(pos).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(355)).

begin(model(358)).
pos.
circle(o6).
square(o5).
in(o5,o6).
circle(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(358)).

begin(model(366)).
pos.
square(o6).
triangle(o5).
config(o5,down).
in(o5,o6).
circle(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(366)).

begin(model(369)).
neg(pos).
triangle(o6).
config(o6,down).
circle(o5).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(369)).

begin(model(370)).
neg(pos).
circle(o6).
circle(o5).
in(o5,o6).
square(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(370)).

begin(model(373)).
pos.
triangle(o3).
config(o3,up).
triangle(o2).
config(o2,down).
in(o2,o3).
square(o1).
end_mod(model(373)).

begin(model(375)).
pos.
triangle(o4).
config(o4,down).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(375)).

begin(model(376)).
neg(pos).
square(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(376)).

begin(model(378)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(378)).

begin(model(379)).
pos.
triangle(o3).
config(o3,up).
triangle(o2).
config(o2,up).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(379)).

begin(model(381)).
pos.
circle(o5).
square(o4).
in(o4,o5).
square(o3).
triangle(o2).
config(o2,down).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(381)).

begin(model(382)).
pos.
circle(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(382)).

begin(model(390)).
pos.
triangle(o4).
config(o4,down).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(390)).

begin(model(393)).
neg(pos).
triangle(o3).
config(o3,up).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(393)).

begin(model(402)).
pos.
triangle(o5).
config(o5,down).
square(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,up).
in(o2,o3).
circle(o1).
end_mod(model(402)).

begin(model(404)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(404)).

begin(model(408)).
neg(pos).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(408)).

begin(model(411)).
neg(pos).
circle(o5).
triangle(o4).
config(o4,down).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(411)).

begin(model(412)).
neg(pos).
circle(o6).
circle(o5).
in(o5,o6).
square(o4).
circle(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(412)).

begin(model(416)).
neg(pos).
circle(o4).
square(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(416)).

begin(model(417)).
neg(pos).
triangle(o6).
config(o6,up).
square(o5).
in(o5,o6).
square(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(417)).

begin(model(419)).
neg(pos).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(419)).

begin(model(420)).
pos.
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(420)).

begin(model(421)).
neg(pos).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(421)).

begin(model(424)).
neg(pos).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(424)).

begin(model(425)).
neg(pos).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(425)).

begin(model(427)).
pos.
square(o6).
circle(o5).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(427)).

begin(model(428)).
pos.
circle(o4).
square(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(428)).

begin(model(431)).
neg(pos).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(431)).

begin(model(432)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(432)).

begin(model(433)).
pos.
triangle(o6).
config(o6,down).
square(o5).
in(o5,o6).
circle(o4).
square(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(433)).

begin(model(437)).
neg(pos).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(437)).

begin(model(444)).
neg(pos).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(444)).

begin(model(445)).
neg(pos).
square(o5).
triangle(o4).
config(o4,up).
in(o4,o5).
triangle(o3).
config(o3,down).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(445)).

begin(model(447)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
square(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(447)).

begin(model(453)).
pos.
circle(o6).
triangle(o5).
config(o5,down).
in(o5,o6).
triangle(o4).
config(o4,down).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(453)).

begin(model(456)).
pos.
triangle(o3).
config(o3,up).
triangle(o2).
config(o2,up).
in(o2,o3).
square(o1).
end_mod(model(456)).

begin(model(457)).
neg(pos).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(457)).

begin(model(459)).
pos.
triangle(o6).
config(o6,down).
triangle(o5).
config(o5,up).
in(o5,o6).
circle(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(459)).

begin(model(462)).
neg(pos).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(462)).

begin(model(463)).
pos.
square(o6).
triangle(o5).
config(o5,down).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(463)).

begin(model(464)).
pos.
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(464)).

begin(model(465)).
pos.
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,down).
in(o2,o3).
square(o1).
end_mod(model(465)).

begin(model(468)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(468)).

begin(model(470)).
neg(pos).
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(470)).

begin(model(473)).
neg(pos).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(473)).

begin(model(474)).
neg(pos).
triangle(o6).
config(o6,up).
square(o5).
in(o5,o6).
square(o4).
circle(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(474)).

begin(model(476)).
neg(pos).
triangle(o5).
config(o5,down).
square(o4).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(476)).

begin(model(477)).
neg(pos).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(477)).

begin(model(479)).
pos.
circle(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(479)).

begin(model(481)).
neg(pos).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(481)).

begin(model(482)).
pos.
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(482)).

begin(model(483)).
neg(pos).
circle(o4).
circle(o3).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(483)).

begin(model(485)).
neg(pos).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(485)).

begin(model(488)).
neg(pos).
triangle(o4).
config(o4,down).
circle(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(488)).

begin(model(489)).
neg(pos).
triangle(o3).
config(o3,down).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(489)).

begin(model(490)).
neg(pos).
triangle(o5).
config(o5,down).
circle(o4).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(490)).

begin(model(491)).
neg(pos).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(491)).

begin(model(494)).
neg(pos).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(494)).

begin(model(497)).
neg(pos).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(497)).

begin(model(499)).
neg(pos).
square(o5).
triangle(o4).
config(o4,down).
in(o4,o5).
square(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(499)).

begin(model(500)).
neg(pos).
circle(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(500)).

begin(model(512)).
neg(pos).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(512)).

begin(model(513)).
neg(pos).
triangle(o6).
config(o6,up).
square(o5).
in(o5,o6).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(513)).

begin(model(516)).
pos.
circle(o4).
square(o3).
in(o3,o4).
circle(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(516)).

begin(model(517)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(517)).

begin(model(520)).
pos.
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(520)).

begin(model(521)).
neg(pos).
circle(o6).
circle(o5).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(521)).

begin(model(527)).
pos.
circle(o5).
triangle(o4).
config(o4,up).
in(o4,o5).
circle(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(527)).

begin(model(529)).
neg(pos).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(529)).

begin(model(531)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(531)).

begin(model(533)).
neg(pos).
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(533)).

begin(model(534)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(534)).

begin(model(539)).
pos.
square(o6).
triangle(o5).
config(o5,down).
in(o5,o6).
circle(o4).
square(o3).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(539)).

begin(model(540)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(540)).

begin(model(542)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(542)).

begin(model(543)).
neg(pos).
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(543)).

begin(model(544)).
neg(pos).
circle(o6).
circle(o5).
in(o5,o6).
square(o4).
circle(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(544)).

begin(model(546)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(546)).

begin(model(550)).
pos.
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(550)).

begin(model(552)).
pos.
circle(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
circle(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(552)).

begin(model(553)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(553)).

begin(model(555)).
neg(pos).
square(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(555)).

begin(model(559)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(559)).

begin(model(565)).
pos.
triangle(o6).
config(o6,down).
triangle(o5).
config(o5,up).
in(o5,o6).
circle(o4).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(565)).

begin(model(567)).
pos.
circle(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(567)).

begin(model(568)).
pos.
square(o6).
square(o5).
in(o5,o6).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(568)).

begin(model(572)).
pos.
triangle(o4).
config(o4,down).
triangle(o3).
config(o3,down).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(572)).

begin(model(578)).
neg(pos).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(578)).

begin(model(582)).
pos.
triangle(o4).
config(o4,down).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(582)).

begin(model(583)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(583)).

begin(model(591)).
neg(pos).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(591)).

begin(model(595)).
pos.
square(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(595)).

begin(model(597)).
pos.
circle(o4).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(597)).

begin(model(600)).
neg(pos).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(600)).

begin(model(602)).
pos.
circle(o5).
triangle(o4).
config(o4,down).
in(o4,o5).
circle(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
circle(o1).
end_mod(model(602)).

begin(model(609)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(609)).

begin(model(612)).
neg(pos).
triangle(o5).
config(o5,down).
circle(o4).
in(o4,o5).
square(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(612)).

begin(model(614)).
neg(pos).
triangle(o3).
config(o3,up).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(614)).

begin(model(615)).
neg(pos).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(615)).

begin(model(616)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(616)).

begin(model(617)).
neg(pos).
square(o5).
triangle(o4).
config(o4,down).
in(o4,o5).
square(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(617)).

begin(model(622)).
pos.
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(622)).

begin(model(625)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(625)).

begin(model(628)).
neg(pos).
triangle(o5).
config(o5,down).
circle(o4).
in(o4,o5).
square(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(628)).

begin(model(634)).
pos.
square(o6).
triangle(o5).
config(o5,up).
in(o5,o6).
triangle(o4).
config(o4,down).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(634)).

begin(model(635)).
neg(pos).
triangle(o5).
config(o5,down).
circle(o4).
in(o4,o5).
triangle(o3).
config(o3,up).
square(o2).
in(o2,o3).
circle(o1).
end_mod(model(635)).

begin(model(637)).
neg(pos).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(637)).

begin(model(639)).
pos.
triangle(o5).
config(o5,up).
square(o4).
in(o4,o5).
circle(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(639)).

begin(model(640)).
pos.
circle(o6).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,down).
in(o3,o4).
triangle(o2).
config(o2,down).
square(o1).
in(o1,o2).
end_mod(model(640)).

begin(model(641)).
pos.
circle(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(641)).

begin(model(642)).
pos.
circle(o6).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(642)).

begin(model(647)).
pos.
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,down).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(647)).

begin(model(648)).
pos.
triangle(o6).
config(o6,down).
triangle(o5).
config(o5,down).
in(o5,o6).
square(o4).
circle(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(648)).

begin(model(649)).
pos.
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(649)).

begin(model(650)).
pos.
circle(o4).
square(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(650)).

begin(model(654)).
neg(pos).
triangle(o4).
config(o4,up).
circle(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(654)).

begin(model(656)).
neg(pos).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(656)).

begin(model(657)).
pos.
circle(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
square(o1).
end_mod(model(657)).

begin(model(658)).
neg(pos).
square(o4).
circle(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(658)).

begin(model(662)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(662)).

begin(model(667)).
pos.
circle(o6).
circle(o5).
in(o5,o6).
triangle(o4).
config(o4,down).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(667)).

begin(model(669)).
neg(pos).
square(o4).
square(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(669)).

begin(model(671)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(671)).

begin(model(679)).
neg(pos).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(679)).

begin(model(682)).
neg(pos).
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(682)).

begin(model(683)).
neg(pos).
square(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(683)).

begin(model(685)).
pos.
square(o6).
circle(o5).
in(o5,o6).
circle(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(685)).

begin(model(686)).
pos.
circle(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(686)).

begin(model(691)).
neg(pos).
square(o5).
circle(o4).
in(o4,o5).
triangle(o3).
config(o3,up).
square(o2).
in(o2,o3).
circle(o1).
end_mod(model(691)).

begin(model(693)).
neg(pos).
triangle(o6).
config(o6,up).
square(o5).
in(o5,o6).
square(o4).
circle(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(693)).

begin(model(698)).
neg(pos).
triangle(o6).
config(o6,up).
circle(o5).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(698)).

begin(model(700)).
neg(pos).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(700)).

begin(model(701)).
neg(pos).
circle(o5).
square(o4).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(701)).

begin(model(705)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(705)).

begin(model(708)).
neg(pos).
triangle(o5).
config(o5,up).
square(o4).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(708)).

begin(model(709)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(709)).

begin(model(710)).
neg(pos).
square(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(710)).

begin(model(719)).
neg(pos).
square(o4).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(719)).

begin(model(722)).
neg(pos).
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(722)).

begin(model(723)).
neg(pos).
circle(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(723)).

begin(model(725)).
pos.
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(725)).

begin(model(728)).
neg(pos).
circle(o4).
circle(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(728)).

begin(model(732)).
neg(pos).
circle(o5).
triangle(o4).
config(o4,down).
in(o4,o5).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(732)).

begin(model(734)).
neg(pos).
square(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(734)).

begin(model(737)).
neg(pos).
square(o4).
circle(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(737)).

begin(model(740)).
neg(pos).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(740)).

begin(model(741)).
neg(pos).
triangle(o5).
config(o5,up).
circle(o4).
in(o4,o5).
square(o3).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(741)).

begin(model(743)).
neg(pos).
triangle(o2).
config(o2,down).
square(o1).
in(o1,o2).
end_mod(model(743)).

begin(model(744)).
neg(pos).
triangle(o5).
config(o5,down).
square(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(744)).

begin(model(745)).
pos.
circle(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(745)).

begin(model(747)).
neg(pos).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(747)).

begin(model(748)).
neg(pos).
square(o5).
circle(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(748)).

begin(model(750)).
neg(pos).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(750)).

begin(model(751)).
neg(pos).
triangle(o2).
config(o2,down).
square(o1).
in(o1,o2).
end_mod(model(751)).

begin(model(753)).
pos.
circle(o6).
triangle(o5).
config(o5,up).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(753)).

begin(model(754)).
neg(pos).
square(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(754)).

begin(model(755)).
neg(pos).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(755)).

begin(model(765)).
neg(pos).
triangle(o2).
config(o2,down).
square(o1).
in(o1,o2).
end_mod(model(765)).

begin(model(766)).
neg(pos).
triangle(o3).
config(o3,up).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(766)).

begin(model(768)).
pos.
square(o6).
square(o5).
in(o5,o6).
circle(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(768)).

begin(model(769)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(769)).

begin(model(772)).
neg(pos).
square(o5).
circle(o4).
in(o4,o5).
square(o3).
triangle(o2).
config(o2,down).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(772)).

begin(model(773)).
neg(pos).
square(o5).
triangle(o4).
config(o4,up).
in(o4,o5).
square(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(773)).

begin(model(777)).
neg(pos).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(777)).

begin(model(779)).
neg(pos).
square(o5).
triangle(o4).
config(o4,down).
in(o4,o5).
triangle(o3).
config(o3,up).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(779)).

begin(model(780)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
circle(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(780)).

begin(model(781)).
neg(pos).
triangle(o6).
config(o6,up).
square(o5).
in(o5,o6).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(781)).

begin(model(787)).
pos.
square(o6).
triangle(o5).
config(o5,down).
in(o5,o6).
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(787)).

begin(model(794)).
neg(pos).
triangle(o3).
config(o3,up).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(794)).

begin(model(795)).
neg(pos).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(795)).

begin(model(797)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
circle(o3).
square(o2).
in(o2,o3).
circle(o1).
end_mod(model(797)).

begin(model(803)).
neg(pos).
triangle(o4).
config(o4,up).
circle(o3).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(803)).

begin(model(805)).
pos.
circle(o6).
triangle(o5).
config(o5,down).
in(o5,o6).
square(o4).
triangle(o3).
config(o3,down).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(805)).

begin(model(807)).
neg(pos).
square(o5).
triangle(o4).
config(o4,up).
in(o4,o5).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(807)).

begin(model(814)).
neg(pos).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(814)).

begin(model(815)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
square(o3).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(815)).

begin(model(816)).
pos.
triangle(o6).
config(o6,up).
triangle(o5).
config(o5,down).
in(o5,o6).
triangle(o4).
config(o4,up).
circle(o3).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(816)).

begin(model(818)).
neg(pos).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(818)).

begin(model(819)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
square(o3).
square(o2).
in(o2,o3).
circle(o1).
end_mod(model(819)).

begin(model(822)).
neg(pos).
square(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(822)).

begin(model(829)).
neg(pos).
square(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(829)).

begin(model(832)).
neg(pos).
square(o5).
circle(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(832)).

begin(model(833)).
neg(pos).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(833)).

begin(model(835)).
pos.
triangle(o6).
config(o6,down).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(835)).

begin(model(836)).
neg(pos).
square(o6).
square(o5).
in(o5,o6).
circle(o4).
square(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(836)).

begin(model(837)).
pos.
triangle(o5).
config(o5,down).
triangle(o4).
config(o4,down).
in(o4,o5).
square(o3).
triangle(o2).
config(o2,down).
in(o2,o3).
square(o1).
end_mod(model(837)).

begin(model(838)).
neg(pos).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(838)).

begin(model(841)).
pos.
triangle(o5).
config(o5,down).
triangle(o4).
config(o4,down).
in(o4,o5).
square(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(841)).

begin(model(844)).
pos.
square(o6).
square(o5).
in(o5,o6).
circle(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(844)).

begin(model(845)).
neg(pos).
triangle(o4).
config(o4,up).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(845)).

begin(model(846)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
square(o3).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(846)).

begin(model(847)).
neg(pos).
circle(o6).
circle(o5).
in(o5,o6).
circle(o4).
square(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(847)).

begin(model(848)).
neg(pos).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(848)).

begin(model(849)).
pos.
triangle(o5).
config(o5,down).
triangle(o4).
config(o4,up).
in(o4,o5).
circle(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
square(o1).
end_mod(model(849)).

begin(model(856)).
neg(pos).
triangle(o2).
config(o2,down).
square(o1).
in(o1,o2).
end_mod(model(856)).

begin(model(859)).
neg(pos).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(859)).

begin(model(862)).
neg(pos).
square(o3).
triangle(o2).
config(o2,down).
in(o2,o3).
square(o1).
end_mod(model(862)).

begin(model(864)).
pos.
circle(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
square(o1).
end_mod(model(864)).

begin(model(867)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
square(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
circle(o1).
end_mod(model(867)).

begin(model(872)).
neg(pos).
square(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(872)).

begin(model(874)).
pos.
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,down).
in(o2,o3).
square(o1).
end_mod(model(874)).

begin(model(876)).
neg(pos).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(876)).

begin(model(880)).
pos.
circle(o6).
circle(o5).
in(o5,o6).
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(880)).

begin(model(882)).
neg(pos).
triangle(o4).
config(o4,down).
circle(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(882)).

begin(model(887)).
neg(pos).
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(887)).

begin(model(890)).
neg(pos).
triangle(o3).
config(o3,down).
square(o2).
in(o2,o3).
square(o1).
end_mod(model(890)).

begin(model(892)).
neg(pos).
triangle(o5).
config(o5,down).
circle(o4).
in(o4,o5).
square(o3).
triangle(o2).
config(o2,up).
in(o2,o3).
square(o1).
end_mod(model(892)).

begin(model(893)).
pos.
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(893)).

begin(model(897)).
neg(pos).
square(o6).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(897)).

begin(model(899)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(899)).

begin(model(900)).
neg(pos).
square(o6).
triangle(o5).
config(o5,down).
in(o5,o6).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
square(o1).
in(o1,o2).
end_mod(model(900)).

begin(model(904)).
neg(pos).
circle(o5).
circle(o4).
in(o4,o5).
square(o3).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(904)).

begin(model(909)).
pos.
circle(o6).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,up).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(909)).

begin(model(910)).
pos.
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
circle(o2).
square(o1).
in(o1,o2).
end_mod(model(910)).

begin(model(912)).
neg(pos).
circle(o6).
triangle(o5).
config(o5,down).
in(o5,o6).
triangle(o4).
config(o4,up).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(912)).

begin(model(915)).
neg(pos).
triangle(o5).
config(o5,up).
square(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(915)).

begin(model(917)).
neg(pos).
triangle(o3).
config(o3,up).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(917)).

begin(model(926)).
neg(pos).
square(o4).
square(o3).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(926)).

begin(model(927)).
neg(pos).
triangle(o5).
config(o5,down).
circle(o4).
in(o4,o5).
triangle(o3).
config(o3,up).
circle(o2).
in(o2,o3).
circle(o1).
end_mod(model(927)).

begin(model(929)).
neg(pos).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(929)).

begin(model(930)).
pos.
triangle(o3).
config(o3,up).
triangle(o2).
config(o2,up).
in(o2,o3).
square(o1).
end_mod(model(930)).

begin(model(931)).
neg(pos).
square(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(931)).

begin(model(932)).
pos.
triangle(o5).
config(o5,down).
square(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,up).
in(o2,o3).
circle(o1).
end_mod(model(932)).

begin(model(933)).
neg(pos).
square(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(933)).

begin(model(938)).
pos.
circle(o6).
circle(o5).
in(o5,o6).
triangle(o4).
config(o4,down).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(938)).

begin(model(939)).
neg(pos).
triangle(o2).
config(o2,up).
square(o1).
in(o1,o2).
end_mod(model(939)).

begin(model(940)).
pos.
triangle(o4).
config(o4,down).
triangle(o3).
config(o3,up).
in(o3,o4).
circle(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(940)).

begin(model(941)).
neg(pos).
triangle(o3).
config(o3,down).
circle(o2).
in(o2,o3).
square(o1).
end_mod(model(941)).

begin(model(944)).
neg(pos).
circle(o4).
circle(o3).
in(o3,o4).
circle(o2).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(944)).

begin(model(945)).
neg(pos).
square(o5).
square(o4).
in(o4,o5).
square(o3).
circle(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(945)).

begin(model(946)).
pos.
triangle(o5).
config(o5,up).
circle(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,down).
in(o2,o3).
circle(o1).
end_mod(model(946)).

begin(model(947)).
pos.
circle(o5).
circle(o4).
in(o4,o5).
triangle(o3).
config(o3,down).
triangle(o2).
config(o2,down).
in(o2,o3).
circle(o1).
end_mod(model(947)).

begin(model(955)).
neg(pos).
circle(o6).
triangle(o5).
config(o5,down).
in(o5,o6).
square(o4).
triangle(o3).
config(o3,up).
in(o3,o4).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(955)).

begin(model(957)).
pos.
triangle(o6).
config(o6,down).
circle(o5).
in(o5,o6).
circle(o4).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(957)).

begin(model(961)).
neg(pos).
square(o4).
circle(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(961)).

begin(model(971)).
pos.
circle(o5).
triangle(o4).
config(o4,down).
in(o4,o5).
triangle(o3).
config(o3,up).
triangle(o2).
config(o2,down).
in(o2,o3).
square(o1).
end_mod(model(971)).

begin(model(973)).
neg(pos).
square(o4).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(973)).

begin(model(974)).
neg(pos).
circle(o6).
circle(o5).
in(o5,o6).
square(o4).
circle(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(974)).

begin(model(975)).
neg(pos).
square(o3).
triangle(o2).
config(o2,down).
in(o2,o3).
triangle(o1).
config(o1,up).
end_mod(model(975)).

begin(model(977)).
neg(pos).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(977)).

begin(model(978)).
pos.
triangle(o2).
config(o2,down).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(978)).

begin(model(979)).
pos.
circle(o2).
triangle(o1).
config(o1,up).
in(o1,o2).
end_mod(model(979)).

begin(model(984)).
neg(pos).
square(o2).
circle(o1).
in(o1,o2).
end_mod(model(984)).

begin(model(989)).
neg(pos).
triangle(o2).
config(o2,up).
circle(o1).
in(o1,o2).
end_mod(model(989)).

begin(model(991)).
pos.
circle(o6).
square(o5).
in(o5,o6).
triangle(o4).
config(o4,down).
square(o3).
in(o3,o4).
triangle(o2).
config(o2,up).
triangle(o1).
config(o1,down).
in(o1,o2).
end_mod(model(991)).

begin(model(995)).
pos.
triangle(o6).
config(o6,up).
triangle(o5).
config(o5,up).
in(o5,o6).
square(o4).
square(o3).
in(o3,o4).
circle(o2).
circle(o1).
in(o1,o2).
end_mod(model(995)).

begin(model(997)).
neg(pos).
square(o3).
square(o2).
in(o2,o3).
triangle(o1).
config(o1,down).
end_mod(model(997)).

begin(model(1000)).
neg(pos).
square(o6).
triangle(o5).
config(o5,up).
in(o5,o6).
triangle(o4).
config(o4,up).
circle(o3).
in(o3,o4).
triangle(o2).
config(o2,down).
circle(o1).
in(o1,o2).
end_mod(model(1000)).
