/*
*  qm_commandlist.h
*  QUIMUP struct to pass commands to MPD
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/


#ifndef QM_COMMAND_H
#define QM_COMMAND_H


#define CMD_DEF 0 // default (none)
#define CMD_DEL 1 // delete
#define CMD_ADD 2 // append
#define CMD_INS 3 // insert at moveto
#define CMD_MOV 4 // move ID to moveto
#define CMD_POS 5 // move pos to moveto
#define CMD_DPL 6 // delete playlist
#define CMD_SCN 7 // rescan
#define CMD_UPD 8 // update


#include <QList>
#include <QTreeWidgetItem>
#include <QString>

typedef struct qm_mpd_command
{
    int cmd = 0;
    int song_pos = -1;
    int song_id  = -1;
    int moveto   = 0;
    QString uri = "";
    /*  below: these are used by the playlist when
    the library sends a commandlist to add items  */
    int time = 0;
    int type = -1;
    QString artist = "";
    QString album = "";
    QString title = "";
    QString track = "";
}
qm_mpd_command;


typedef QList<qm_mpd_command> qm_commandList;

#endif // QM_COMMAND_H
