/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.codegen;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.codegen.CliArgumentViewModel;
import com.intellij.swagger.core.codegen.SwCodeGeneratorType;
import com.intellij.swagger.core.codegen.SwJdkUtilsKt;
import com.intellij.swagger.core.codegen.SwaggerCodegenRunConfiguration;
import com.intellij.swagger.core.codegen.completion.CodegenMeta;
import com.intellij.swagger.core.codegen.completion.PropertyMeta;
import com.intellij.swagger.core.codegen.completion.SwaggerCodegenMetaProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u000f"}, d2={"checkSwaggerCodegenRunConfiguration", "", "configuration", "Lcom/intellij/swagger/core/codegen/SwaggerCodegenRunConfiguration;", "checkVersionConforms", "checkSpecificationPath", "text", "", "checkJre", "checkTextIsNotEmpty", "fieldName", "checkFileExists", "path", "checkLanguageSupportedByGenerator", "checkPropertiesSupportedByGenerator", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nRunConfigurationValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunConfigurationValidator.kt\ncom/intellij/swagger/core/codegen/RunConfigurationValidatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1557#2:68\n1628#2,3:69\n774#2:72\n865#2,2:73\n1755#2,3:75\n*S KotlinDebug\n*F\n+ 1 RunConfigurationValidator.kt\ncom/intellij/swagger/core/codegen/RunConfigurationValidatorKt\n*L\n62#1:68\n62#1:69,3\n63#1:72\n63#1:73,2\n63#1:75,3\n*E\n"})
public final class RunConfigurationValidatorKt {
    public static final void checkSwaggerCodegenRunConfiguration(@NotNull SwaggerCodegenRunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        RunConfigurationValidatorKt.checkJre(configuration);
        RunConfigurationValidatorKt.checkSpecificationPath(configuration.getSpecificationPath());
        RunConfigurationValidatorKt.checkVersionConforms(configuration);
        RunConfigurationValidatorKt.checkLanguageSupportedByGenerator(configuration);
        RunConfigurationValidatorKt.checkPropertiesSupportedByGenerator(configuration);
    }

    private static final void checkVersionConforms(SwaggerCodegenRunConfiguration configuration) {
        if (configuration.getGeneratorType() != SwCodeGeneratorType.SWAGGER_CODEGEN_V2) {
            return;
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(configuration.getSpecificationPath()), (boolean)false);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (SwSpecificationDetectionKt.detectSpecificationType(virtualFile2, project) instanceof SwSpecificationType.OPENAPI_3) {
            throw new RuntimeConfigurationWarning(SwaggerBundle.message("run.configuration.codegen.validation.generator.doesnt.conform", new Object[0]));
        }
    }

    private static final void checkSpecificationPath(String text) {
        RunConfigurationValidatorKt.checkFileExists(text, SwaggerBundle.message("run.configuration.codegen.specification.path", new Object[0]));
    }

    private static final void checkJre(SwaggerCodegenRunConfiguration configuration) {
        String jdkPath = SwJdkUtilsKt.findJdkPathByShortName(configuration.getJdkPath());
        if (StringsKt.isBlank((CharSequence)jdkPath) || !new File(jdkPath).exists()) {
            throw new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.no.jdk", new Object[0]));
        }
    }

    private static final void checkTextIsNotEmpty(String text, String fieldName) {
        if (StringsKt.isBlank((CharSequence)text)) {
            Object[] objectArray = new Object[]{fieldName};
            throw new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.unspecified.0.property", objectArray));
        }
    }

    private static final void checkFileExists(String path, String fieldName) {
        RunConfigurationValidatorKt.checkTextIsNotEmpty(path, fieldName);
        if (!new File(path).exists()) {
            Object[] objectArray = new Object[]{fieldName};
            throw new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.file.does.not.exist", objectArray));
        }
        if (!new File(path).isFile()) {
            Object[] objectArray = new Object[]{fieldName};
            throw new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.0.is.not.a.file", objectArray));
        }
    }

    private static final void checkLanguageSupportedByGenerator(SwaggerCodegenRunConfiguration configuration) {
        CodegenMeta codegenMeta = SwaggerCodegenMetaProvider.Companion.getInstance().getCodegenMetadata(configuration.getGeneratorType().getUniqueId());
        if (codegenMeta == null) {
            return;
        }
        CodegenMeta metadata = codegenMeta;
        String selectedLanguage = configuration.getLanguage();
        if (!metadata.getLanguages().contains(selectedLanguage)) {
            throw new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.unknown.language", new Object[0]));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkPropertiesSupportedByGenerator(SwaggerCodegenRunConfiguration configuration) {
        boolean anyUnknownPropertyFound;
        block8: {
            void $this$any$iv;
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            CodegenMeta codegenMeta = SwaggerCodegenMetaProvider.Companion.getInstance().getCodegenMetadata(configuration.getGeneratorType().getUniqueId());
            if (codegenMeta == null) {
                return;
            }
            CodegenMeta metadata = codegenMeta;
            String selectedLanguage = configuration.getLanguage();
            List list = metadata.getPropertiesByLanguage().get(selectedLanguage);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable = list;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PropertyMeta propertyMeta = (PropertyMeta)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPropertyName());
            }
            List propertiesForLanguage = (List)destination$iv$iv;
            Iterable $this$filter$iv = configuration.getGenerationParameters$intellij_swagger_core();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CliArgumentViewModel it = (CliArgumentViewModel)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it.getName();
                if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CliArgumentViewModel it = (CliArgumentViewModel)element$iv;
                    boolean bl = false;
                    if (!(!CollectionsKt.contains((Iterable)propertiesForLanguage, (Object)it.getName()))) continue;
                    v2 = true;
                    break block8;
                }
                v2 = anyUnknownPropertyFound = false;
            }
        }
        if (anyUnknownPropertyFound) {
            throw new RuntimeConfigurationError(SwaggerBundle.message("run.configuration.codegen.validation.unknown.property", new Object[0]));
        }
    }
}

