/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.variables.introspect;

import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u00a8\u0006\u0005"}, d2={"reformatIntrospectionText", "", "text", "removeColorCodecs", "coloredText", "intellij.jupyter.core"})
public final class JupyterIntrospectionManagerKt {
    @NotNull
    public static final String reformatIntrospectionText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = StringUtil.unescapeStringCharacters((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeStringCharacters(...)");
        String cleanText = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"\""), (CharSequence)"\"");
        return JupyterIntrospectionManagerKt.removeColorCodecs(cleanText);
    }

    @NotNull
    public static final String removeColorCodecs(@NotNull String coloredText) {
        Intrinsics.checkNotNullParameter((Object)coloredText, (String)"coloredText");
        Regex re = new Regex("\u001b\\[[;\\d]*m");
        return re.replace((CharSequence)coloredText, "");
    }
}

