/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.asynccontext;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.asynccontext.AsyncContextBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.HasPropertyCacheNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContext;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContextSnapshot;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContextVariable;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class AsyncContextBuiltins
extends JSBuiltinsContainer.SwitchEnum<AsyncContext> {
    public static final JSBuiltinsContainer BUILTINS = new AsyncContextBuiltins();

    protected AsyncContextBuiltins() {
        super(JSAsyncContext.NAMESPACE_NAME, AsyncContext.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, AsyncContext builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                if (construct) {
                    return newTarget ? AsyncContextBuiltinsFactory.ConstructAsyncContextSnapshotNodeGen.create(context2, builtin, true, AsyncContextBuiltins.args().newTarget().createArgumentNodes(context2)) : AsyncContextBuiltinsFactory.ConstructAsyncContextSnapshotNodeGen.create(context2, builtin, false, AsyncContextBuiltins.args().function().createArgumentNodes(context2));
                }
                return ConstructorBuiltins.createCallRequiresNew(context2, builtin);
            }
            case 1: {
                if (construct) {
                    return newTarget ? AsyncContextBuiltinsFactory.ConstructAsyncContextVariableNodeGen.create(context2, builtin, true, AsyncContextBuiltins.args().newTarget().fixedArgs(1).createArgumentNodes(context2)) : AsyncContextBuiltinsFactory.ConstructAsyncContextVariableNodeGen.create(context2, builtin, false, AsyncContextBuiltins.args().function().fixedArgs(1).createArgumentNodes(context2));
                }
                return ConstructorBuiltins.createCallRequiresNew(context2, builtin);
            }
        }
        return null;
    }

    public static enum AsyncContext implements BuiltinEnum<AsyncContext>
    {
        Snapshot(0),
        Variable(1);

        private final int length;

        private AsyncContext(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isConstructor() {
            return true;
        }

        @Override
        public boolean isNewTargetConstructor() {
            return true;
        }
    }

    public static abstract class ConstructAsyncContextSnapshotNode
    extends ConstructorBuiltins.ConstructWithNewTargetNode {
        public ConstructAsyncContextSnapshotNode(JSContext context2, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context2, builtin, isNewTargetCase);
        }

        @Specialization
        protected final JSObject construct(JSDynamicObject newTarget) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            return JSAsyncContextSnapshot.create(this.getContext(), realm, proto, realm.getAgent().getAsyncContextMapping());
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return this.getRealm().getAsyncContextSnapshotPrototype();
        }
    }

    @ImportStatic(value={Strings.class})
    public static abstract class ConstructAsyncContextVariableNode
    extends ConstructorBuiltins.ConstructWithNewTargetNode {
        public ConstructAsyncContextVariableNode(JSContext context2, JSBuiltin builtin, boolean isNewTargetCase) {
            super(context2, builtin, isNewTargetCase);
        }

        @Specialization
        protected final JSObject construct(JSDynamicObject newTarget, Object options, @Cached IsObjectNode isObject, @Cached JSToStringNode toString, @Cached(value="create(NAME, getContext())") HasPropertyCacheNode hasName, @Cached(value="create(NAME, getContext())") PropertyGetNode getName, @Cached(value="create(DEFAULT_VALUE, getContext())") PropertyGetNode getDefaultValue) {
            JSRealm realm = this.getRealm();
            JSDynamicObject proto = this.getPrototype(realm, newTarget);
            TruffleString nameStr = Strings.EMPTY_STRING;
            Object defaultValue = Undefined.instance;
            if (isObject.executeBoolean(options)) {
                if (hasName.hasProperty(options)) {
                    Object name = getName.getValue(options);
                    nameStr = toString.executeString(name);
                }
                defaultValue = getDefaultValue.getValue(options);
            }
            Symbol asyncContextKey = Symbol.create(nameStr);
            return JSAsyncContextVariable.create(this.getContext(), realm, proto, asyncContextKey, defaultValue);
        }

        @Override
        protected JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
            return this.getRealm().getAsyncContextVariablePrototype();
        }
    }
}

