/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetMethodNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class GetMethodNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode cacheNode;
    @Node.Child
    private IsCallableNode isCallableNode;

    protected GetMethodNode(JSContext context2, Object propertyKey) {
        this.cacheNode = PropertyGetNode.create(propertyKey, context2);
        this.isCallableNode = IsCallableNode.create();
    }

    @NeverDefault
    public static GetMethodNode create(JSContext ctx, Object key) {
        return GetMethodNodeGen.create(ctx, key);
    }

    public final Object getKey() {
        return this.cacheNode.getKey();
    }

    public abstract Object executeWithTarget(Object var1);

    @Specialization
    protected Object doGetMethod(Object target, @Cached InlinedConditionProfile undefinedOrNull, @Cached InlinedBranchProfile notCallableBranch) {
        Object method = this.cacheNode.getValue(target);
        if (this.isCallableNode.executeBoolean(method)) {
            return method;
        }
        if (undefinedOrNull.profile(this, method == Undefined.instance || method == Null.instance)) {
            return Undefined.instance;
        }
        notCallableBranch.enter(this);
        throw Errors.createTypeErrorNotAFunction(method, this);
    }
}

