/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Predicate;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SshException;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.util.io.Compressor;
import com.jetbrains.plugins.remotesdk.RemoteUploadKt;
import com.jetbrains.plugins.remotesdk.transport.SshUtil;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e\u0012\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*J.\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\u000bH\u0002J&\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010/\u001a\u00020\tH\u0002J&\u00106\u001a\u0002022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010,\u001a\u00020-2\u0006\u00107\u001a\u00020\tH\u0002J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\t09H\u0014J\u0010\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020<H\u0014J&\u0010=\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010,\u001a\u00020-2\u0006\u00107\u001a\u00020\tH\u0002J\u001e\u0010>\u001a\u00020\u000b2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\t092\u0006\u0010@\u001a\u00020\tH\u0002J0\u0010A\u001a\u0002022\u0006\u0010,\u001a\u00020-2\u0016\u0010B\u001a\u0012\u0012\u0004\u0012\u00020D0Cj\b\u0012\u0004\u0012\u00020D`E2\u0006\u0010/\u001a\u00020\tH\u0002J\b\u0010F\u001a\u00020\u000bH\u0014J\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020I0H2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/jetbrains/plugins/remotesdk/RemoteUpload;", "", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Ljava/awt/Component;", "title", "", "cancellable", "", "isModal", "pathsToUpload", "", "remotePath", "<init>", "(Lcom/intellij/remote/RemoteCredentials;Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Ljava/lang/String;ZZLjava/util/Collection;Ljava/lang/String;)V", "getCredentials", "()Lcom/intellij/remote/RemoteCredentials;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getComponent", "()Ljava/awt/Component;", "getTitle", "()Ljava/lang/String;", "relativePathsMap", "", "getRelativePathsMap", "()Ljava/util/Map;", "setRelativePathsMap", "(Ljava/util/Map;)V", "uploadOnSnapshot", "getUploadOnSnapshot", "()Z", "setUploadOnSnapshot", "(Z)V", "process", "Lcom/intellij/openapi/progress/Task;", "progressIndicator", "Lcom/intellij/openapi/progress/StandardProgressIndicator;", "upload", "Ljava/util/concurrent/Future;", "helpersUpdateNeeded", "connection", "Lcom/intellij/ssh/channels/SftpChannel;", "helpersRoots", "remoteHelpersRoot", "updateOnSnapshot", "doUploadFilesToRemote", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "localHelpersRoots", "uploadPerFile", "remoteDirectory", "createFileFilter", "Lcom/google/common/base/Predicate;", "onUploadError", "e", "Lcom/intellij/ssh/SshException;", "uploadCompressedTar", "applyFilter", "filter", "entryName", "uploadFiles", "files", "Ljava/util/ArrayList;", "Ljava/io/File;", "Lkotlin/collections/ArrayList;", "helpersArchiveCopyEnabled", "getExcludedHelpersPaths", "", "Lcom/jetbrains/plugins/webDeployment/config/ExcludedPath;", "helpersPaths", "intellij.remoteRun"})
@SourceDebugExtension(value={"SMAP\nRemoteUpload.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteUpload.kt\ncom/jetbrains/plugins/remotesdk/RemoteUpload\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1755#2,3:236\n*S KotlinDebug\n*F\n+ 1 RemoteUpload.kt\ncom/jetbrains/plugins/remotesdk/RemoteUpload\n*L\n65#1:236,3\n*E\n"})
public class RemoteUpload {
    @NotNull
    private final RemoteCredentials credentials;
    @Nullable
    private final Project project;
    @Nullable
    private final Component component;
    @NotNull
    private final String title;
    @NotNull
    private final Collection<String> pathsToUpload;
    @NotNull
    private final String remotePath;
    @Nullable
    private Map<String, String> relativePathsMap;
    private boolean uploadOnSnapshot;
    @NotNull
    private final Task process;
    @NotNull
    private final StandardProgressIndicator progressIndicator;

    public RemoteUpload(@NotNull RemoteCredentials credentials, @Nullable Project project, @Nullable Component component, @NlsContexts.ProgressTitle @NotNull String title, boolean cancellable, boolean isModal, @NotNull Collection<String> pathsToUpload, @NotNull String remotePath) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(pathsToUpload, (String)"pathsToUpload");
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        this.credentials = credentials;
        this.project = project;
        this.component = component;
        this.title = title;
        this.pathsToUpload = pathsToUpload;
        this.remotePath = remotePath;
        this.process = RemoteUploadKt.createTask(this.project, this.title, cancellable, isModal, arg_0 -> RemoteUpload.process$lambda$0(this, arg_0));
        this.progressIndicator = this.process instanceof Task.Backgroundable ? (StandardProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)this.process) : (StandardProgressIndicator)new EmptyProgressIndicator();
    }

    @NotNull
    public final RemoteCredentials getCredentials() {
        return this.credentials;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Component getComponent() {
        return this.component;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @Nullable
    public final Map<String, String> getRelativePathsMap() {
        return this.relativePathsMap;
    }

    public final void setRelativePathsMap(@Nullable Map<String, String> map) {
        this.relativePathsMap = map;
    }

    public final boolean getUploadOnSnapshot() {
        return this.uploadOnSnapshot;
    }

    public final void setUploadOnSnapshot(boolean bl) {
        this.uploadOnSnapshot = bl;
    }

    @NotNull
    public final Future<?> upload() {
        if (this.process instanceof Task.Backgroundable) {
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkNotNull((Object)progressManager, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.impl.ProgressManagerImpl");
            Future future = ((ProgressManagerImpl)progressManager).runProcessWithProgressAsynchronously((Task.Backgroundable)this.process, (ProgressIndicator)this.progressIndicator, null);
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"runProcessWithProgressAsynchronously(...)");
            return future;
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> RemoteUpload.upload$lambda$1(this));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"runAsync(...)");
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean helpersUpdateNeeded(SftpChannel connection, Collection<String> helpersRoots, String remoteHelpersRoot, boolean updateOnSnapshot) {
        boolean bl;
        PerformanceWatcher.Snapshot snapshot;
        block18: {
            snapshot = PerformanceWatcher.Companion.takeSnapshot();
            Iterable $this$any$iv = helpersRoots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String path = (String)element$iv;
                    boolean bl2 = false;
                    try {
                        RemoteFileObject versionFile;
                        String relativePath;
                        RemoteFileObject helpersDir = connection.file(remoteHelpersRoot);
                        if (!helpersDir.exists()) {
                            return true;
                        }
                        Map<String, String> map = this.relativePathsMap;
                        String string = relativePath = map != null ? map.get(path) : null;
                        if (relativePath != null) {
                            RemoteFileObject singleFile = helpersDir.child(relativePath);
                            if (!singleFile.exists()) {
                                return true;
                            }
                            if (!singleFile.isDir()) {
                                return false;
                            }
                        }
                        if ((versionFile = helpersDir.child("build.txt")).exists()) {
                            Closeable closeable = versionFile.inputStream();
                            Throwable throwable = null;
                            try {
                                InputStream it = (InputStream)closeable;
                                boolean bl3 = false;
                                char[] cArray = FileUtil.loadText((Reader)new InputStreamReader(it), (int)((int)versionFile.size()));
                                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"loadText(...)");
                                char[] cArray2 = cArray;
                                String content = new String(cArray2);
                                String localContent = RemoteUploadKt.access$getLocalVersion();
                                RemoteUploadKt.access$getLOG$p().info("Remote helpers version is " + content + ", local helpers version is " + localContent);
                                if (((CharSequence)content).length() > 0) {
                                    boolean bl4 = !Intrinsics.areEqual((Object)localContent, (Object)content) || StringsKt.endsWith$default((String)localContent, (String)".SNAPSHOT", (boolean)false, (int)2, null) && updateOnSnapshot;
                                    return bl4;
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        return true;
                    }
                    catch (Exception e) {
                        RemoteUploadKt.access$getLOG$p().info("Failed to retrieve helpers version file", (Throwable)e);
                        if (!true) continue;
                        bl = true;
                        break block18;
                    }
                }
                bl = false;
            }
        }
        boolean result = bl;
        snapshot.logResponsivenessSinceCreation("Helpers version check");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doUploadFilesToRemote(ProgressIndicator indicator, Collection<String> localHelpersRoots, String remoteHelpersRoot) {
        block9: {
            RemoteUploadKt.access$getLOG$p().info("Uploading helpers from " + localHelpersRoots + " to " + this.remotePath);
            try {
                indicator.setFraction(0.0);
                try (SftpChannel connection = ConnectionBuilder.openSftpChannel$default((ConnectionBuilder)RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)this.credentials, null, null, (boolean)false, null, (int)15, null), (int)0, (int)1, null);){
                    if (!this.helpersUpdateNeeded(connection, localHelpersRoots, remoteHelpersRoot, this.uploadOnSnapshot)) break block9;
                    PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.Companion.takeSnapshot();
                    try {
                        if (!this.helpersArchiveCopyEnabled() || !this.uploadCompressedTar(localHelpersRoots, connection, remoteHelpersRoot)) {
                            this.uploadPerFile(localHelpersRoots, connection, remoteHelpersRoot);
                        }
                        RemoteUploadKt.access$getLOG$p().info("Helpers upload successfully completed");
                    }
                    finally {
                        snapshot.logResponsivenessSinceCreation("Helpers uploaded");
                    }
                }
            }
            catch (SshException e) {
                this.onUploadError(e);
            }
        }
    }

    private final void uploadPerFile(Collection<String> pathsToUpload, SftpChannel connection, String remoteDirectory) {
        for (String root : pathsToUpload) {
            File file = new File(root);
            Map<String, String> map = this.relativePathsMap;
            if (map == null || (map = map.get(root)) == null) {
                map = "";
            }
            connection.uploadFileOrDir(file, remoteDirectory, (String)((Object)map));
        }
    }

    @NotNull
    protected Predicate<String> createFileFilter() {
        return RemoteUpload::createFileFilter$lambda$4;
    }

    protected void onUploadError(@NotNull SshException e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        RemoteUploadKt.access$getLOG$p().warn((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean uploadCompressedTar(Collection<String> pathsToUpload, SftpChannel connection, String remoteDirectory) {
        try {
            File file = FileUtil.createTempFile((String)"helpers.", (String)".tar.gz");
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File tarFile = file;
            try {
                Predicate<String> f = this.createFileFilter();
                Object[] objectArray = (Object[])new Compressor.Tar(tarFile, Compressor.Tar.Compression.GZIP);
                Throwable throwable = null;
                try {
                    Compressor.Tar it = (Compressor.Tar)objectArray;
                    boolean bl = false;
                    byte[] byArray = RemoteUploadKt.access$getLocalVersion().getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    it.addFile("build.txt", byArray);
                    it.filter((arg_0, arg_1) -> RemoteUpload.uploadCompressedTar$lambda$7$lambda$6((arg_0, arg_1) -> RemoteUpload.uploadCompressedTar$lambda$7$lambda$5(this, f, arg_0, arg_1), arg_0, arg_1));
                    for (String root : pathsToUpload) {
                        it.addDirectory(new File(root));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)objectArray, (Throwable)throwable);
                }
                objectArray = new File[]{tarFile};
                this.uploadFiles(connection, CollectionsKt.arrayListOf((Object[])objectArray), remoteDirectory);
                SshUtil.untar(this.credentials, RemoteFile.createRemoteFile((String)remoteDirectory, (String)tarFile.getName()).getPath(), remoteDirectory);
            }
            finally {
                tarFile.delete();
            }
            return true;
        }
        catch (Exception e) {
            RemoteUploadKt.access$getLOG$p().error("Couldn't upload helpers", (Throwable)e);
            return false;
        }
    }

    private final boolean applyFilter(Predicate<String> filter, String entryName) {
        String string;
        int p = -1;
        do {
            if ((p = StringsKt.indexOf$default((CharSequence)entryName, (char)'/', (int)(p + 1), (boolean)false, (int)4, null)) < 0) {
                return filter.apply((Object)entryName);
            }
            string = entryName.substring(0, p);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        } while (filter.apply((Object)string));
        return false;
    }

    private final void uploadFiles(SftpChannel connection, ArrayList<File> files, String remoteHelpersRoot) {
        Iterator<File> iterator = files.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<File> iterator2 = iterator;
        while (iterator2.hasNext()) {
            File file;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            connection.uploadFileOrDir(file, remoteHelpersRoot, string);
        }
    }

    protected boolean helpersArchiveCopyEnabled() {
        return false;
    }

    @NotNull
    protected List<ExcludedPath> getExcludedHelpersPaths(@NotNull Collection<String> helpersPaths) {
        Intrinsics.checkNotNullParameter(helpersPaths, (String)"helpersPaths");
        return CollectionsKt.emptyList();
    }

    private static final void process$lambda$0(RemoteUpload this$0, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this$0.doUploadFilesToRemote(indicator, this$0.pathsToUpload, this$0.remotePath);
    }

    private static final void upload$lambda$1(RemoteUpload this$0) {
        this$0.process.run((ProgressIndicator)new EmptyProgressIndicator());
    }

    private static final boolean createFileFilter$lambda$4(String it) {
        return true;
    }

    private static final boolean uploadCompressedTar$lambda$7$lambda$5(RemoteUpload this$0, Predicate $f, String entryName, Path path) {
        Intrinsics.checkNotNull((Object)entryName);
        return this$0.applyFilter((Predicate<String>)$f, entryName);
    }

    private static final boolean uploadCompressedTar$lambda$7$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        return (Boolean)$tmp0.invoke(p0, p1);
    }
}

