/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.plugin.java;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.projectView.actions.MarkRootsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.module.PyContentEntriesEditor;
import com.jetbrains.python.resourceRoots.ResourceRootProvider;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

final class PyPluginResourceRootProvider
extends ResourceRootProvider {
    PyPluginResourceRootProvider() {
    }

    @NotNull
    protected MultiMap<String, String> getResourceRoots(@NotNull Module module) {
        ContentEntry[] entries;
        if (module == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(0);
        }
        MultiMap roots = new MultiMap();
        for (ContentEntry entry : entries = ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            SmartList resourceRoots = new SmartList();
            List folders = entry.getSourceFolders((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
            for (SourceFolder folder : folders) {
                resourceRoots.add(folder.getUrl());
            }
            if (resourceRoots.isEmpty()) continue;
            roots.put((Object)entry.getUrl(), (Collection)resourceRoots);
        }
        MultiMap multiMap = roots;
        if (multiMap == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    protected void setResourceRoots(MultiMap<String, String> roots, @NotNull Module module) {
        if (module == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ModuleRootManager moduleManager = ModuleRootManager.getInstance((Module)module);
            ModifiableRootModel model = moduleManager.getModifiableModel();
            for (String entryUrl : roots.keySet()) {
                ContentEntry entry = PyPluginResourceRootProvider.findContentEntry(entryUrl, model);
                if (entry == null) continue;
                Collection fileUrls = roots.get((Object)entryUrl);
                for (String fileUrl : fileUrls) {
                    for (SourceFolder folder : entry.getSourceFolders()) {
                        if (!folder.getUrl().equals(fileUrl)) continue;
                        entry.removeSourceFolder(folder);
                        break;
                    }
                    entry.addSourceFolder(fileUrl, (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
                }
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                model.commit();
                if (model.isWritable()) {
                    model.dispose();
                }
            });
            SaveAndSyncHandler.getInstance().scheduleProjectSave(module.getProject());
            ProjectRootManagerEx.getInstanceEx((Project)module.getProject()).makeRootsChange(EmptyRunnable.INSTANCE, RootsChangeRescanningInfo.NO_RESCAN_NEEDED);
        });
    }

    @Nullable
    private static ContentEntry findContentEntry(String entryUrl, @NotNull ModifiableRootModel model) {
        if (model == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(3);
        }
        for (ContentEntry entry : model.getContentEntries()) {
            if (!Objects.equals(entryUrl, entry.getUrl())) continue;
            return entry;
        }
        return null;
    }

    protected void removeRoot(@NotNull VirtualFile selectedFile, @NotNull PyContentEntriesEditor editor, @NotNull ModifiableRootModel model) {
        if (selectedFile == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(5);
        }
        if (model == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(6);
        }
        super.removeRoot(selectedFile, editor, model);
        PyPluginResourceRootProvider.removeFromModel(selectedFile, model);
    }

    private static void removeFromModel(@NotNull VirtualFile selectedFile, @NotNull ModifiableRootModel model) {
        if (selectedFile == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(7);
        }
        if (model == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ContentEntry entry = MarkRootsManager.findContentEntry((ModuleRootModel)model, (VirtualFile)selectedFile);
            if (entry == null) {
                return;
            }
            for (SourceFolder folder : entry.getSourceFolders()) {
                if (!folder.getUrl().equals(selectedFile.getUrl())) continue;
                entry.removeSourceFolder(folder);
                break;
            }
        });
    }

    public void removeRoot(ContentEntry contentEntry, @NotNull VirtualFilePointer root, ModifiableRootModel model) {
        if (root == null) {
            PyPluginResourceRootProvider.$$$reportNull$$$0(9);
        }
        super.removeRoot(contentEntry, root, model);
        VirtualFile file = root.getFile();
        if (file != null) {
            PyPluginResourceRootProvider.removeFromModel(file, model);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/plugin/java/PyPluginResourceRootProvider";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/plugin/java/PyPluginResourceRootProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoots";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setResourceRoots";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findContentEntry";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeFromModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

