/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.providers;

import com.intellij.openapi.components.Service;
import com.intellij.scientific.tables.ColumnTreeNode;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.DSTableDataException;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DSTableDataProvider;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.FilterExpression;
import com.intellij.scientific.tables.api.TableStatisticsData;
import com.intellij.scientific.tables.api.TableVisualizationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.RowSorter;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0012\u001a\u00020\tH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0002J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u000e2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\tH\u0016J \u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\tH\u0016J:\u0010%\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010\t2\u0006\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011H\u0016J4\u0010*\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u000e2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010.\u001a\u00020\u0011H\u0016J\"\u0010/\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u0011H\u0016J\b\u00103\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/scientific/py/tables/providers/PyPysparkDataFrameProvider;", "Lcom/intellij/scientific/tables/api/DSTableDataProvider;", "<init>", "()V", "type", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "getType", "()Lcom/intellij/scientific/tables/api/DSTableDataType;", "pysparkShowStringSuffix", "", "tableHasSuffix", "", "lastRow", "splitTextToRawRows", "", "text", "getDelimiterCoordinates", "", "firstRawRow", "getColumnNames", "delimiterCoordinates", "extractRowValues", "startIndices", "row", "parseStaticTableToFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "parsePysparkTableToFrameInfo", "parseStaticTableToTableData", "Lcom/intellij/scientific/tables/DSTableRawData;", "id", "Lcom/intellij/scientific/tables/DataId;", "table", "loadDynamicTableDataFrameInfo", "commandExecutor", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "tableVariable", "textTableOutput", "loadDynamicTableData", "dataId", "format", "start", "end", "getSortingCommand", "sortKeys", "Ljavax/swing/RowSorter$SortKey;", "columns", "indexColumnWidth", "getFilteringCommand", "filters", "Lcom/intellij/scientific/tables/api/FilterExpression;", "tableColumnsNumber", "isFallbackToStaticTableSupported", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nPyPysparkDataFrameProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPysparkDataFrameProvider.kt\ncom/intellij/scientific/py/tables/providers/PyPysparkDataFrameProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n774#2:115\n865#2,2:116\n1863#2,2:134\n1872#2,3:137\n995#3,11:118\n1188#3,2:129\n1190#3:132\n1006#3:133\n1#4:131\n1#4:136\n*S KotlinDebug\n*F\n+ 1 PyPysparkDataFrameProvider.kt\ncom/intellij/scientific/py/tables/providers/PyPysparkDataFrameProvider\n*L\n37#1:115\n37#1:116,2\n51#1:134,2\n88#1:137,3\n41#1:118,11\n41#1:129,2\n41#1:132\n41#1:133\n41#1:131\n*E\n"})
public final class PyPysparkDataFrameProvider
implements DSTableDataProvider {
    @NotNull
    private final DSTableDataType type = DSTableDataType.PYSPARK_TABLE;
    @NonNls
    @NotNull
    private final String pysparkShowStringSuffix;

    public PyPysparkDataFrameProvider() {
        this.pysparkShowStringSuffix = "only showing top";
    }

    @NotNull
    public DSTableDataType getType() {
        return this.type;
    }

    private final boolean tableHasSuffix(String lastRow) {
        return StringsKt.startsWith$default((String)lastRow, (String)this.pysparkShowStringSuffix, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitTextToRawRows(String text) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getDelimiterCoordinates(String firstRawRow) {
        void $this$mapIndexedNotNullTo$iv$iv;
        CharSequence $this$mapIndexedNotNull$iv = firstRawRow;
        boolean $i$f$mapIndexedNotNull = false;
        CharSequence charSequence = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv$iv$iv.length(); ++i) {
            Integer it$iv$iv;
            void c;
            void element$iv$iv;
            char item$iv$iv$iv = $this$forEachIndexed$iv$iv$iv.charAt(i);
            int n = index$iv$iv$iv++;
            char c2 = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            void var15_15 = element$iv$iv;
            int index = index$iv$iv;
            boolean bl2 = false;
            if ((c == 43 ? Integer.valueOf(index) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> getColumnNames(String text, List<Integer> delimiterCoordinates) {
        return this.extractRowValues(delimiterCoordinates, text);
    }

    private final List<String> extractRowValues(List<Integer> startIndices, String row) {
        List rowValues = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)startIndices);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            int startIndex = ((Number)pair.component1()).intValue();
            int endIndex = ((Number)pair.component2()).intValue();
            String string = row.substring(startIndex + 1, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String substring = ((Object)StringsKt.trim((CharSequence)string)).toString();
            rowValues.add(substring);
        }
        return rowValues;
    }

    @NotNull
    public DSDataFrameInfo parseStaticTableToFrameInfo(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        DSDataFrameInfo dataFrameInfo = this.parsePysparkTableToFrameInfo(text);
        dataFrameInfo.setTableType(this.getType());
        dataFrameInfo.setDocumentationUrl(this.getType().getDocumentationUrl());
        return dataFrameInfo;
    }

    private final DSDataFrameInfo parsePysparkTableToFrameInfo(String text) {
        ArrayList<Object> arrayList;
        int indexColumnWidth = 0;
        List<String> rawRows = this.splitTextToRawRows(text);
        int rowsNumber = this.tableHasSuffix((String)CollectionsKt.last(rawRows)) ? rawRows.size() - 5 : rawRows.size() - 4;
        List<String> columnNames = this.getColumnNames(rawRows.get(1), this.getDelimiterCoordinates((String)CollectionsKt.first(rawRows)));
        Object[] objectArray = new Object[]{rowsNumber, columnNames.size() - indexColumnWidth};
        String dimensions = DSTableBundle.message((String)"ds.table.dimensions.info", (Object[])objectArray);
        int n = columnNames.size();
        List<String> list = columnNames;
        int n2 = indexColumnWidth;
        int n3 = rowsNumber;
        ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
        int n4 = 0;
        while (n4 < n) {
            int n5;
            int n6 = n5 = n4++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(null);
        }
        arrayList = arrayList2;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n7 = 992;
        TableVisualizationData tableVisualizationData = null;
        TableStatisticsData tableStatisticsData = null;
        ColumnTreeNode columnTreeNode = null;
        String string = null;
        DSTableDataType dSTableDataType = null;
        String string2 = dimensions;
        ArrayList<Object> arrayList3 = arrayList;
        List<String> list2 = list;
        int n8 = n2;
        int n9 = n3;
        return new DSDataFrameInfo(n9, n8, list2, arrayList3, string2, dSTableDataType, string, columnTreeNode, tableStatisticsData, tableVisualizationData, n7, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public DSTableRawData parseStaticTableToTableData(@NotNull DataId id, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        List<String> rawRows = this.splitTextToRawRows(table);
        List<Integer> delimiterCoordinates = this.getDelimiterCoordinates((String)CollectionsKt.first(rawRows));
        List<String> columnNames = this.getColumnNames(rawRows.get(1), delimiterCoordinates);
        int n = columnNames.size();
        ArrayList<List> arrayList = new ArrayList<List>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = n3 = n2++;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new ArrayList());
        }
        List columns = arrayList;
        int bottomRowsNumber = this.tableHasSuffix((String)CollectionsKt.last(rawRows)) ? 2 : 1;
        for (String row : CollectionsKt.dropLast((List)CollectionsKt.drop((Iterable)rawRows, (int)3), (int)bottomRowsNumber)) {
            List<String> rowValues = this.extractRowValues(delimiterCoordinates, row);
            Iterable $this$forEachIndexed$iv = rowValues;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void value2;
                int n5;
                if ((n5 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n5;
                boolean bl = false;
                ((List)columns.get(index)).add(value2);
            }
        }
        return new DSTableRawData(id, columns);
    }

    @NotNull
    public DSDataFrameInfo loadDynamicTableDataFrameInfo(@NotNull DSTableCommandExecutor commandExecutor, @NotNull String tableVariable, @NotNull String textTableOutput) throws DSTableDataException {
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)textTableOutput, (String)"textTableOutput");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public DSTableRawData loadDynamicTableData(@NotNull DSTableCommandExecutor commandExecutor, @NotNull DataId dataId, @NotNull String tableVariable, @Nullable String format, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public String getSortingCommand(@NotNull String tableVariable, @NotNull List<? extends RowSorter.SortKey> sortKeys, @NotNull List<String> columns, int indexColumnWidth) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public String getFilteringCommand(@NotNull String tableVariable, @Nullable FilterExpression filters, int tableColumnsNumber) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        throw new NotImplementedError(null, 1, null);
    }

    public boolean isFallbackToStaticTableSupported() {
        return true;
    }
}

