/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template;

import com.intellij.jinja.template.DjangoTemplateFileType;
import com.intellij.jinja.template.DjangoTemplateLanguage;
import com.intellij.jinja.template.psi.impl.DjangoTagElementImpl;
import com.intellij.jinja.template.psi.impl.Jinja2MemberExpressionImpl;
import com.intellij.jinja.template.psi.impl.Jinja2MemberNameImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateElementGenerator {
    private final Project myProject;

    public DjangoTemplateElementGenerator(Project project) {
        this.myProject = project;
    }

    public static DjangoTemplateElementGenerator getInstance(Project project) {
        return (DjangoTemplateElementGenerator)project.getService(DjangoTemplateElementGenerator.class);
    }

    @NotNull
    public Jinja2MemberExpressionImpl createLoadTagReference(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(0);
        }
        name = FileUtilRt.getNameWithoutExtension((String)name);
        PsiFile tempFile = this.createTempFile("{% load " + name + " %}");
        Jinja2MemberExpressionImpl jinja2MemberExpressionImpl = (Jinja2MemberExpressionImpl)((Object)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{Jinja2MemberExpressionImpl.class}).iterator().next());
        if (jinja2MemberExpressionImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(1);
        }
        return jinja2MemberExpressionImpl;
    }

    @NotNull
    public Jinja2MemberNameImpl createLoadedNameReference(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(2);
        }
        PsiFile tempFile = this.createTempFile("{% load " + name + " from foo %}");
        Jinja2MemberNameImpl jinja2MemberNameImpl = (Jinja2MemberNameImpl)((Object)PsiTreeUtil.collectElementsOfType((PsiElement)tempFile, (Class[])new Class[]{Jinja2MemberNameImpl.class}).iterator().next());
        if (jinja2MemberNameImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(3);
        }
        return jinja2MemberNameImpl;
    }

    @NotNull
    public ASTNode createNameIdentifier(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(4);
        }
        PsiFile tempFile = this.createTempFile("{% for " + name + " in books %}");
        ASTNode aSTNode = tempFile.getFirstChild().getFirstChild().getFirstChild().getNextSibling().getNextSibling().getNode().getFirstChildNode().getPsi().getNextSibling().getNextSibling().getNode();
        if (aSTNode == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(5);
        }
        return aSTNode;
    }

    @NotNull
    public Jinja2MemberExpressionImpl createMemberExpression(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(6);
        }
        PsiFile tempFile = this.createTempFile("{% url " + name + " %}");
        Jinja2MemberExpressionImpl jinja2MemberExpressionImpl = (Jinja2MemberExpressionImpl)PsiTreeUtil.findChildOfType((PsiElement)tempFile, Jinja2MemberExpressionImpl.class);
        if (jinja2MemberExpressionImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(7);
        }
        return jinja2MemberExpressionImpl;
    }

    @NotNull
    public Jinja2MemberNameImpl createMemberName(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(8);
        }
        PsiFile tempFile = this.createTempFile("{% url " + name + " %}");
        Jinja2MemberNameImpl jinja2MemberNameImpl = (Jinja2MemberNameImpl)PsiTreeUtil.findChildOfType((PsiElement)tempFile, Jinja2MemberNameImpl.class);
        if (jinja2MemberNameImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(9);
        }
        return jinja2MemberNameImpl;
    }

    @NotNull
    public DjangoTagElementImpl createTag(@NotNull String name) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(10);
        }
        DjangoTagElementImpl djangoTagElementImpl = this.createTag(name, null);
        if (djangoTagElementImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(11);
        }
        return djangoTagElementImpl;
    }

    @NotNull
    public DjangoTagElementImpl createTag(@NotNull String name, @Nullable String content) {
        if (name == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(12);
        }
        PsiFile tempFile = content == null || StringUtil.isEmptyOrSpaces((String)content) ? this.createTempFile("{% " + name + " %}") : this.createTempFile("{% " + name + " " + content + " %}");
        DjangoTagElementImpl djangoTagElementImpl = (DjangoTagElementImpl)PsiTreeUtil.findChildOfType((PsiElement)tempFile, DjangoTagElementImpl.class);
        if (djangoTagElementImpl == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(13);
        }
        return djangoTagElementImpl;
    }

    public static PsiElement createMember(@NotNull String fullName, @NotNull Project project) {
        if (fullName == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(14);
        }
        if (project == null) {
            DjangoTemplateElementGenerator.$$$reportNull$$$0(15);
        }
        if (fullName.contains(".")) {
            return DjangoTemplateElementGenerator.getInstance(project).createMemberExpression(fullName);
        }
        return DjangoTemplateElementGenerator.getInstance(project).createMemberName(fullName);
    }

    public PsiFile createTempFile(String contents) {
        return PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("temp." + DjangoTemplateFileType.INSTANCE.getDefaultExtension(), (Language)DjangoTemplateLanguage.INSTANCE, (CharSequence)contents);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7, 9, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/DjangoTemplateElementGenerator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/DjangoTemplateElementGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoadTagReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoadedNameReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNameIdentifier";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemberExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemberName";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLoadTagReference";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLoadedNameReference";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNameIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMemberExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createMemberName";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTag";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createMember";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7, 9, 11, 13 -> new IllegalStateException(string);
        };
    }
}

