/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/textmate/plist/XmlPlistReader;", "Lorg/jetbrains/plugins/textmate/plist/PlistReader;", "<init>", "()V", "read", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "inputStream", "Ljava/io/InputStream;", "Companion", "intellij.textmate.core"})
public final class XmlPlistReader
implements PlistReader {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Plist read(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return XmlPlistReader.Companion.internalRead(XmlDomReader.readXmlAsModel((InputStream)inputStream));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/textmate/plist/XmlPlistReader$Companion;", "", "<init>", "()V", "internalRead", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "root", "Lcom/intellij/util/xml/dom/XmlElement;", "readDict", "Lorg/jetbrains/plugins/textmate/plist/PListValue;", "dictElement", "readValue", "key", "", "valueElement", "readArray", "element", "readBasicValue", "type", "intellij.textmate.core"})
    @SourceDebugExtension(value={"SMAP\nXmlPlistReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlPlistReader.kt\norg/jetbrains/plugins/textmate/plist/XmlPlistReader$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1611#2,9:97\n1863#2:106\n1864#2:108\n1620#2:109\n1#3:107\n*S KotlinDebug\n*F\n+ 1 XmlPlistReader.kt\norg/jetbrains/plugins/textmate/plist/XmlPlistReader$Companion\n*L\n69#1:97,9\n69#1:106\n69#1:108\n69#1:109\n69#1:107\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Plist internalRead(XmlElement root) {
            XmlElement dictElement;
            if (root.children.isEmpty()) {
                return Plist.EMPTY_PLIST;
            }
            if (!Intrinsics.areEqual((Object)"plist", (Object)root.name)) {
                throw new IOException("Unknown xml format. Root element is '" + root.name + "'");
            }
            XmlElement xmlElement = dictElement = root.getChild("dict");
            return xmlElement != null ? this.readDict(xmlElement).getPlist() : Plist.EMPTY_PLIST;
        }

        private final PListValue readDict(XmlElement dictElement) {
            Map map;
            List children = dictElement.children;
            Map $this$readDict_u24lambda_u241 = map = MapsKt.createMapBuilder();
            boolean bl = false;
            for (int i = 0; i < children.size(); ++i) {
                PListValue value;
                XmlElement keyElement = (XmlElement)children.get(i);
                if (!Intrinsics.areEqual((Object)"key", (Object)keyElement.name)) continue;
                String attributeKey = keyElement.content;
                ++i;
                if (attributeKey == null) continue;
                if (Companion.readValue(attributeKey, (XmlElement)children.get(i)) == null) continue;
                boolean bl2 = false;
                $this$readDict_u24lambda_u241.put(attributeKey, value);
            }
            Map map2 = MapsKt.build((Map)map);
            return PListValue.Companion.value(new Plist(map2), PlistValueType.DICT);
        }

        private final PListValue readValue(String key, XmlElement valueElement) {
            String type = valueElement.name;
            return Intrinsics.areEqual((Object)type, (Object)"dict") ? this.readDict(valueElement) : (Intrinsics.areEqual((Object)type, (Object)"array") ? this.readArray(key, valueElement) : this.readBasicValue(type, valueElement));
        }

        /*
         * WARNING - void declaration
         */
        private final PListValue readArray(String key, XmlElement element) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = element.children;
            PListValue.Companion companion = PListValue.Companion;
            boolean $i$f$mapNotNull = false;
            void var5_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PListValue it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                XmlElement it = (XmlElement)element$iv$iv;
                boolean bl2 = false;
                if (Companion.readValue(key, it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return companion.value((List)destination$iv$iv, PlistValueType.ARRAY);
        }

        private final PListValue readBasicValue(String type, XmlElement valueElement) {
            String content = valueElement.content;
            return Intrinsics.areEqual((Object)"string", (Object)type) && content != null ? PListValue.Companion.value(content, PlistValueType.STRING) : (Intrinsics.areEqual((Object)"true", (Object)type) ? PListValue.Companion.value(true, PlistValueType.BOOLEAN) : (Intrinsics.areEqual((Object)"false", (Object)type) ? PListValue.Companion.value(false, PlistValueType.BOOLEAN) : (Intrinsics.areEqual((Object)"integer", (Object)type) && content != null ? PListValue.Companion.value(Integer.parseInt(content), PlistValueType.INTEGER) : (Intrinsics.areEqual((Object)"real", (Object)type) && content != null ? PListValue.Companion.value(Double.parseDouble(content), PlistValueType.REAL) : null))));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

