/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.ui.observables.DistinctObservablePropertyKt;
import com.intellij.notebooks.visualization.EditorNotebookExtension;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellEventListener;
import com.intellij.notebooks.visualization.ui.EditorNotebookKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.state.ObservableStateListener;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\"\u001a\u0004\u0018\u0001H#\"\b\b\u0000\u0010#*\u00020!2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0 \u00a2\u0006\u0002\u0010%J\u001c\u0010&\u001a\u00020'2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020'0)H\u0002J\u0016\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020\u001bJ\u000e\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020'H\u0016J\u0006\u00101\u001a\u00020'J\u000e\u00102\u001a\u00020'2\u0006\u00103\u001a\u000204J+\u00105\u001a\u00020'\"\b\b\u0000\u0010#*\u00020!2\f\u00106\u001a\b\u0012\u0004\u0012\u0002H#0 2\u0006\u00107\u001a\u0002H#\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u0004\u0018\u00010\n2\u0006\u0010:\u001a\u000204J\u0010\u0010;\u001a\u0004\u0018\u00010\n2\u0006\u0010:\u001a\u000204J\u001a\u0010<\u001a\u0004\u0018\u00010\n2\u0006\u0010:\u001a\u0002042\u0006\u0010=\u001a\u000204H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\u0015\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b0\u001a\u00a2\u0006\u0002\b\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030 \u0012\u0004\u0012\u00020!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorNotebook;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "_cells", "", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "cells", "", "getCells", "()Ljava/util/List;", "_readOnly", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "", "readOnly", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "getReadOnly", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "showCellToolbar", "getShowCellToolbar", "()Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "cellEventListeners", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/notebooks/visualization/ui/EditorCellEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "extensions", "", "Lkotlin/reflect/KClass;", "Lcom/intellij/notebooks/visualization/EditorNotebookExtension;", "getExtension", "T", "cls", "(Lkotlin/reflect/KClass;)Lcom/intellij/notebooks/visualization/EditorNotebookExtension;", "forEachExtension", "", "action", "Lkotlin/Function1;", "addCellEventsListener", "disposable", "listener", "addCell", "interval", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "dispose", "clear", "removeCell", "index", "", "addExtension", "type", "extension", "(Lkotlin/reflect/KClass;Lcom/intellij/notebooks/visualization/EditorNotebookExtension;)V", "getNextVisibleCellBelow", "ordinal", "getNextVisibleCellAbove", "getNextVisibleCellInDirection", "direction", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorNotebook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorNotebook.kt\ncom/intellij/notebooks/visualization/ui/EditorNotebook\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1863#2,2:138\n1863#2,2:140\n1863#2,2:142\n*S KotlinDebug\n*F\n+ 1 EditorNotebook.kt\ncom/intellij/notebooks/visualization/ui/EditorNotebook\n*L\n59#1:138,2\n78#1:140,2\n87#1:142,2\n*E\n"})
public final class EditorNotebook
implements Disposable {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private List<EditorCell> _cells;
    @NotNull
    private final ObservableMutableProperty<Boolean> _readOnly;
    @NotNull
    private final ObservableMutableProperty<Boolean> showCellToolbar;
    @NotNull
    private final EventDispatcher<EditorCellEventListener> cellEventListeners;
    @NotNull
    private final Map<KClass<?>, EditorNotebookExtension> extensions;

    public EditorNotebook(@NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this._cells = new ArrayList();
        this._readOnly = DistinctObservablePropertyKt.distinct((ObservableMutableProperty)new AtomicBooleanProperty(false));
        this.showCellToolbar = DistinctObservablePropertyKt.distinct((ObservableMutableProperty)new AtomicBooleanProperty(true));
        EventDispatcher eventDispatcher = EventDispatcher.create(EditorCellEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.cellEventListeners = eventDispatcher;
        this.extensions = new LinkedHashMap();
        EditorNotebookKt.access$getEDITOR_NOTEBOOK_KEY$p().set((UserDataHolder)this.editor, (Object)this);
        this.editor.getState().addPropertyChangeListener(new ObservableStateListener(){

            public void propertyChanged(ObservableStateListener.PropertyChangeEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"isViewer")) {
                    ObservableMutableProperty observableMutableProperty = _readOnly;
                    Object object = event.getNewValue();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                    observableMutableProperty.set((Object)((Boolean)object));
                }
            }
        }, (Disposable)this);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    @NotNull
    public final List<EditorCell> getCells() {
        return CollectionsKt.toList((Iterable)this._cells);
    }

    @NotNull
    public final ObservableProperty<Boolean> getReadOnly() {
        return (ObservableProperty)this._readOnly;
    }

    @NotNull
    public final ObservableMutableProperty<Boolean> getShowCellToolbar() {
        return this.showCellToolbar;
    }

    @Nullable
    public final <T extends EditorNotebookExtension> T getExtension(@NotNull KClass<T> cls) {
        Intrinsics.checkNotNullParameter(cls, (String)"cls");
        EditorNotebookExtension editorNotebookExtension = this.extensions.get(cls);
        return (T)(editorNotebookExtension instanceof EditorNotebookExtension ? editorNotebookExtension : null);
    }

    private final void forEachExtension(Function1<? super EditorNotebookExtension, Unit> action2) {
        Iterable $this$forEach$iv = this.extensions.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorNotebookExtension it = (EditorNotebookExtension)element$iv;
            boolean bl = false;
            action2.invoke((Object)it);
        }
    }

    public final void addCellEventsListener(@NotNull Disposable disposable, @NotNull EditorCellEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.cellEventListeners.addListener((EventListener)listener2, disposable);
    }

    public final void addCell(@NotNull NotebookIntervalPointer interval) {
        EditorCell editorCell;
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        EditorCell it = editorCell = new EditorCell(this, interval, this.editor);
        boolean bl = false;
        this.forEachExtension((Function1<? super EditorNotebookExtension, Unit>)((Function1)arg_0 -> EditorNotebook.addCell$lambda$2$lambda$1(it, arg_0)));
        Disposer.register((Disposable)this, (Disposable)it);
        EditorCell editorCell2 = editorCell;
        NotebookCellLines.Interval interval2 = interval.get();
        Intrinsics.checkNotNull((Object)interval2);
        this._cells.add(interval2.getOrdinal(), editorCell2);
        ((EditorCellEventListener)this.cellEventListeners.getMulticaster()).onEditorCellEvents(CollectionsKt.listOf((Object)new EditorCellEventListener.CellCreated(editorCell2)));
    }

    public void dispose() {
        Iterable $this$forEach$iv = this.extensions.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorNotebookExtension it = (EditorNotebookExtension)element$iv;
            boolean bl = false;
            if (!(it instanceof Disposable)) continue;
            Disposer.dispose((Disposable)((Disposable)it));
        }
        EditorNotebookKt.access$getEDITOR_NOTEBOOK_KEY$p().set((UserDataHolder)this.editor, null);
    }

    public final void clear() {
        Iterable $this$forEach$iv = this._cells;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EditorCell cell = (EditorCell)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)cell);
        }
        this._cells.clear();
    }

    public final void removeCell(int index) {
        EditorCell cell = this._cells.get(index);
        cell.onBeforeRemove();
        EditorCell removed = this._cells.remove(index);
        Disposer.dispose((Disposable)removed);
        ((EditorCellEventListener)this.cellEventListeners.getMulticaster()).onEditorCellEvents(CollectionsKt.listOf((Object)new EditorCellEventListener.CellRemoved(removed, index)));
    }

    public final <T extends EditorNotebookExtension> void addExtension(@NotNull KClass<T> type, @NotNull T extension) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        this.extensions.put(type, extension);
    }

    @Nullable
    public final EditorCell getNextVisibleCellBelow(int ordinal) {
        return this.getNextVisibleCellInDirection(ordinal, 1);
    }

    @Nullable
    public final EditorCell getNextVisibleCellAbove(int ordinal) {
        return this.getNextVisibleCellInDirection(ordinal, -1);
    }

    private final EditorCell getNextVisibleCellInDirection(int ordinal, int direction) {
        IntProgression range = direction > 0 ? (IntProgression)RangesKt.until((int)(ordinal + direction), (int)this._cells.size()) : RangesKt.reversed((IntProgression)((IntProgression)new IntRange(0, ordinal + direction)));
        int i = range.getFirst();
        int n = range.getLast();
        int n2 = range.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                EditorCell cell;
                if ((cell = this._cells.get(i)).isUnfolded().get().booleanValue()) {
                    return cell;
                }
                if (i == n) break;
                i += n2;
            }
        }
        return null;
    }

    private static final Unit addCell$lambda$2$lambda$1(EditorCell $it, EditorNotebookExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        extension.onCellCreated($it);
        return Unit.INSTANCE;
    }
}

