/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentContentRevision
implements ByteBackedContentRevision {
    protected FilePath myFile;

    public CurrentContentRevision(FilePath file) {
        this.myFile = file;
    }

    @Override
    @Nullable
    @NonNls
    public String getContent() {
        VirtualFile vFile = this.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        Document doc = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(vFile));
        return doc == null ? null : doc.getText();
    }

    @Override
    public byte @Nullable [] getContentAsBytes() throws VcsException {
        VirtualFile vFile = this.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        try {
            return vFile.contentsToByteArray();
        }
        catch (IOException e) {
            throw new VcsException(e);
        }
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile vFile = this.myFile.getVirtualFile();
        return vFile == null || !vFile.isValid() ? null : vFile;
    }

    @Override
    @NotNull
    public FilePath getFile() {
        FilePath filePath = this.myFile;
        if (filePath == null) {
            CurrentContentRevision.$$$reportNull$$$0(0);
        }
        return filePath;
    }

    @Override
    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber = VcsRevisionNumber.NULL;
        if (vcsRevisionNumber == null) {
            CurrentContentRevision.$$$reportNull$$$0(1);
        }
        return vcsRevisionNumber;
    }

    @NotNull
    public static ContentRevision create(@NotNull FilePath file) {
        if (file == null) {
            CurrentContentRevision.$$$reportNull$$$0(2);
        }
        if (file.getFileType().isBinary()) {
            return new CurrentBinaryContentRevision(file);
        }
        return new CurrentContentRevision(file);
    }

    @NonNls
    public String toString() {
        return "CurrentContentRevision:" + String.valueOf(this.myFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/CurrentContentRevision";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/CurrentContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

