/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.customElements.impl;

import com.intellij.model.Pointer;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolApiStatus;
import com.intellij.webSymbols.WebSymbolTypeSupport;
import com.intellij.webSymbols.context.WebSymbolsContext;
import com.intellij.webSymbols.customElements.CustomElementsJsonOrigin;
import com.intellij.webSymbols.customElements.CustomElementsSymbol;
import com.intellij.webSymbols.customElements.json.CustomElementsContribution;
import com.intellij.webSymbols.customElements.json.CustomElementsJsonUtilsKt;
import com.intellij.webSymbols.customElements.json.Type;
import com.intellij.webSymbols.impl.StaticWebSymbolsScopeBase;
import com.intellij.webSymbols.patterns.WebSymbolsPattern;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B!\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00000-H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0007\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0017\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\rR\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u0016\u0010 \u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006."}, d2={"Lcom/intellij/webSymbols/customElements/impl/CustomElementsContributionSymbol;", "T", "Lcom/intellij/webSymbols/customElements/json/CustomElementsContribution;", "Lcom/intellij/webSymbols/customElements/CustomElementsSymbol;", "Lcom/intellij/webSymbols/impl/StaticWebSymbolsScopeBase$StaticSymbolContributionAdapter;", "name", "", "contribution", "origin", "Lcom/intellij/webSymbols/customElements/CustomElementsJsonOrigin;", "<init>", "(Ljava/lang/String;Lcom/intellij/webSymbols/customElements/json/CustomElementsContribution;Lcom/intellij/webSymbols/customElements/CustomElementsJsonOrigin;)V", "getName", "()Ljava/lang/String;", "getContribution", "()Lcom/intellij/webSymbols/customElements/json/CustomElementsContribution;", "Lcom/intellij/webSymbols/customElements/json/CustomElementsContribution;", "getOrigin", "()Lcom/intellij/webSymbols/customElements/CustomElementsJsonOrigin;", "pattern", "Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;", "getPattern", "()Lcom/intellij/webSymbols/patterns/WebSymbolsPattern;", "framework", "Lcom/intellij/webSymbols/FrameworkId;", "getFramework", "apiStatus", "Lcom/intellij/webSymbols/WebSymbolApiStatus;", "getApiStatus", "()Lcom/intellij/webSymbols/WebSymbolApiStatus;", "description", "getDescription", "type", "", "getType", "()Ljava/lang/Object;", "withQueryExecutorContext", "Lcom/intellij/webSymbols/WebSymbol;", "queryExecutor", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "matchContext", "", "context", "Lcom/intellij/webSymbols/context/WebSymbolsContext;", "createPointer", "Lcom/intellij/model/Pointer;", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nCustomElementsContributionSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomElementsContributionSymbol.kt\ncom/intellij/webSymbols/customElements/impl/CustomElementsContributionSymbol\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n1#2:50\n*E\n"})
public abstract class CustomElementsContributionSymbol<T extends CustomElementsContribution>
implements CustomElementsSymbol,
StaticWebSymbolsScopeBase.StaticSymbolContributionAdapter {
    @NotNull
    private final String name;
    @NotNull
    private final T contribution;
    @NotNull
    private final CustomElementsJsonOrigin origin;

    protected CustomElementsContributionSymbol(@NotNull String name, @NotNull T contribution, @NotNull CustomElementsJsonOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(contribution, (String)"contribution");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        this.name = name;
        this.contribution = contribution;
        this.origin = origin;
    }

    @Override
    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    protected final T getContribution() {
        return this.contribution;
    }

    @Override
    @NotNull
    public final CustomElementsJsonOrigin getOrigin() {
        return this.origin;
    }

    @Override
    @Nullable
    public final WebSymbolsPattern getPattern() {
        return null;
    }

    @Override
    @Nullable
    public final String getFramework() {
        return null;
    }

    @Override
    @NotNull
    public final WebSymbolApiStatus getApiStatus() {
        WebSymbolApiStatus webSymbolApiStatus = CustomElementsJsonUtilsKt.toApiStatus(this.contribution.getDeprecated(), this.origin);
        if (webSymbolApiStatus == null) {
            webSymbolApiStatus = WebSymbolApiStatus.Stable;
        }
        return webSymbolApiStatus;
    }

    @Override
    @Nullable
    public final String getDescription() {
        String string;
        String string2;
        String string3;
        block6: {
            block5: {
                String string4;
                string3 = this.contribution.getDescription();
                if (string3 == null) break block5;
                String it = string4 = string3;
                boolean bl = false;
                string3 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
                if (string3 != null) break block6;
            }
            string3 = this.contribution.getSummary();
        }
        if ((string2 = string3) != null) {
            String it = string2;
            boolean bl = false;
            string = this.origin.renderDescription(it);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public Object getType() {
        Object object;
        Type type = this.contribution.getType();
        if (type != null) {
            Type it = type;
            boolean bl = false;
            WebSymbolTypeSupport webSymbolTypeSupport = this.origin.getTypeSupport();
            object = webSymbolTypeSupport != null ? webSymbolTypeSupport.resolve(CustomElementsJsonUtilsKt.mapToReferenceList(it)) : null;
        } else {
            object = null;
        }
        return object;
    }

    @Override
    @NotNull
    public final WebSymbol withQueryExecutorContext(@NotNull WebSymbolsQueryExecutor queryExecutor) {
        Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
        return this;
    }

    @Override
    public boolean matchContext(@NotNull WebSymbolsContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return CustomElementsSymbol.super.matchContext(context);
    }

    @NotNull
    public Pointer<? extends CustomElementsContributionSymbol<? extends T>> createPointer() {
        Pointer pointer = Pointer.hardPointer((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
        return pointer;
    }
}

