/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.psi.SassScssUseAtRule;

public class SassScssQualifierReference
extends PsiReferenceBase<PsiElement> {
    public SassScssQualifierReference(@NotNull PsiElement element) {
        if (element == null) {
            SassScssQualifierReference.$$$reportNull$$$0(0);
        }
        super(element, TextRange.from((int)0, (int)element.getTextLength()), false);
    }

    @Nullable
    public PsiElement resolve() {
        return SassScssQualifierReference.resolve(this.getElement(), this.getValue());
    }

    @Nullable
    public static PsiElement resolve(@NotNull PsiElement context, @NotNull String qualifier) {
        CssStylesheet stylesheet;
        if (context == null) {
            SassScssQualifierReference.$$$reportNull$$$0(1);
        }
        if (qualifier == null) {
            SassScssQualifierReference.$$$reportNull$$$0(2);
        }
        if ((stylesheet = (CssStylesheet)PsiTreeUtil.getParentOfType((PsiElement)context, CssStylesheet.class)) == null) {
            return null;
        }
        for (SassScssUseAtRule useAtRule : SASSSCSSLangUtil.getUseAtRules(stylesheet)) {
            String q;
            CssString urlElement;
            String url;
            PsiElement aliasElement = useAtRule.getAliasElement();
            if (aliasElement != null) {
                if (!qualifier.equals(aliasElement.getText())) continue;
                return aliasElement;
            }
            if (useAtRule.isAsterisk() || (url = (urlElement = useAtRule.getTargetUrl()) != null ? urlElement.getValue() : null) == null || url.isEmpty() || url.equals("sass:") || url.endsWith("/")) continue;
            if (url.startsWith("sass:")) {
                q = url.substring("sass:".length());
            } else {
                String fileName = PathUtil.getFileName((String)url);
                q = StringUtil.trimStart((String)FileUtil.getNameWithoutExtension((String)fileName), (String)"_");
            }
            if (q.isEmpty() || !q.equals(qualifier)) continue;
            return urlElement;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/scss/references/SassScssQualifierReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

