/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.DockerObject;
import com.github.dockerjava.api.model.SwarmNodePluginDescription;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.CheckForNull;

public class SwarmNodeEngineDescription
extends DockerObject
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="EngineVersion")
    private String engineVersion;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="Plugins")
    private SwarmNodePluginDescription[] plugins;

    @CheckForNull
    public String getEngineVersion() {
        return this.engineVersion;
    }

    public SwarmNodeEngineDescription withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    @CheckForNull
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public SwarmNodeEngineDescription withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    @CheckForNull
    public SwarmNodePluginDescription[] getPlugins() {
        return this.plugins;
    }

    public SwarmNodeEngineDescription withPlugins(SwarmNodePluginDescription[] plugins) {
        this.plugins = plugins;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwarmNodeEngineDescription)) {
            return false;
        }
        SwarmNodeEngineDescription other = (SwarmNodeEngineDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$engineVersion = this.getEngineVersion();
        String other$engineVersion = other.getEngineVersion();
        if (this$engineVersion == null ? other$engineVersion != null : !this$engineVersion.equals(other$engineVersion)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        return Arrays.deepEquals(this.getPlugins(), other.getPlugins());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SwarmNodeEngineDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $engineVersion = this.getEngineVersion();
        result2 = result2 * 59 + ($engineVersion == null ? 43 : $engineVersion.hashCode());
        Map<String, String> $labels = this.getLabels();
        result2 = result2 * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        result2 = result2 * 59 + Arrays.deepHashCode(this.getPlugins());
        return result2;
    }

    public String toString() {
        return "SwarmNodeEngineDescription(engineVersion=" + this.getEngineVersion() + ", labels=" + this.getLabels() + ", plugins=" + Arrays.deepToString(this.getPlugins()) + ")";
    }
}

