/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.IndicesKt;
import org.jetbrains.kotlinx.dataframe.api.SelectKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.impl.DataFrameSize;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a@\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0002\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0017\"\u00020\u0015H\u0086\u0002\u00a2\u0006\u0002\u0010\u0018\u001a-\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0002\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001aH\u0086\u0002\u001aX\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0002\"\u0004\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\u00022\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u00030\u001bj\u0002`\u001c2\"\u0010\u0016\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u00030\u001bj\u0002`\u001c0\u0017\"\n\u0012\u0002\b\u00030\u001bj\u0002`\u001cH\u0086\u0002\u00a2\u0006\u0002\u0010\u001d\u001a{\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0\u001f0\u001e\"\u0004\b\u0000\u0010\u0013\"\u0004\b\u0001\u0010 *\b\u0012\u0004\u0012\u0002H\u00130\u00022N\u0010!\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u00130#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H 0'0\"j\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H `(\u00a2\u0006\u0002\b)H\u0086\u0002\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\n\u0012\u0002\b\u00030\u0002j\u0002`\u0003\" \u0010\u0000\u001a\u00020\u0001*\n\u0012\u0002\b\u00030\u0002j\u0002`\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001c\u0010\u0006\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\" \u0010\u000b\u001a\u00020\u0007*\n\u0012\u0002\b\u00030\u0002j\u0002`\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\" \u0010\u000e\u001a\u00020\u000f*\n\u0012\u0002\b\u00030\u0002j\u0002`\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"indices", "Lkotlin/ranges/IntRange;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "getIndices", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;)Lkotlin/ranges/IntRange;", "ncol", "", "Lorg/jetbrains/kotlinx/dataframe/ColumnsContainer;", "getNcol", "(Lorg/jetbrains/kotlinx/dataframe/ColumnsContainer;)I", "nrow", "getNrow", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;)I", "size", "Lorg/jetbrains/kotlinx/dataframe/impl/DataFrameSize;", "getSize", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;)Lorg/jetbrains/kotlinx/dataframe/impl/DataFrameSize;", "get", "T", "first", "", "other", "", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "columnRange", "Lkotlin/ranges/ClosedRange;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "Lorg/jetbrains/kotlinx/dataframe/AnyColumnReference;", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;[Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "C", "columns", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lkotlin/ParameterName;", "name", "it", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "Lkotlin/ExtensionFunctionType;", "core"})
public final class DataFrameKt {
    @NotNull
    public static final <T, C> List<DataColumn<C>> get(@NotNull DataFrame<? extends T> $this$get, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> columns2) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return $this$get.get(columns2);
    }

    @NotNull
    public static final <T> DataFrame<T> get(@NotNull DataFrame<? extends T> $this$get, @NotNull ColumnReference<?> first2, ColumnReference<?> ... other) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(first2, (String)"first");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return SelectKt.select($this$get, (Function2)new Function2<ColumnsSelectionDsl<? extends T>, ColumnsSelectionDsl<? extends T>, ColumnsResolver<?>>(first2, other){
            final /* synthetic */ ColumnReference<?> $first;
            final /* synthetic */ ColumnReference<?>[] $other;
            {
                this.$first = $first;
                this.$other = $other;
                super(2);
            }

            @NotNull
            public final ColumnsResolver<?> invoke(@NotNull ColumnsSelectionDsl<? extends T> $this$select, @NotNull ColumnsSelectionDsl<? extends T> it) {
                Intrinsics.checkNotNullParameter($this$select, (String)"$this$select");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ConstructorsKt.toColumnSetColumnReference(CollectionsKt.plus((Collection)CollectionsKt.listOf(this.$first), (Object[])this.$other));
            }
        });
    }

    @NotNull
    public static final <T> DataFrame<T> get(@NotNull DataFrame<? extends T> $this$get, @NotNull String first2, String ... other) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)first2, (String)"first");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return SelectKt.select($this$get, (Function2)new Function2<ColumnsSelectionDsl<? extends T>, ColumnsSelectionDsl<? extends T>, ColumnsResolver<?>>(first2, other){
            final /* synthetic */ String $first;
            final /* synthetic */ String[] $other;
            {
                this.$first = $first;
                this.$other = $other;
                super(2);
            }

            @NotNull
            public final ColumnsResolver<?> invoke(@NotNull ColumnsSelectionDsl<? extends T> $this$select, @NotNull ColumnsSelectionDsl<? extends T> it) {
                Intrinsics.checkNotNullParameter($this$select, (String)"$this$select");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ConstructorsKt.toColumnSetString(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.$first), (Object[])this.$other));
            }
        });
    }

    @NotNull
    public static final <T> DataFrame<T> get(@NotNull DataFrame<? extends T> $this$get, @NotNull ClosedRange<String> columnRange) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(columnRange, (String)"columnRange");
        return SelectKt.select($this$get, (Function2)new Function2<ColumnsSelectionDsl<? extends T>, ColumnsSelectionDsl<? extends T>, ColumnsResolver<?>>(columnRange){
            final /* synthetic */ ClosedRange<String> $columnRange;
            {
                this.$columnRange = $columnRange;
                super(2);
            }

            @NotNull
            public final ColumnsResolver<?> invoke(@NotNull ColumnsSelectionDsl<? extends T> $this$select, @NotNull ColumnsSelectionDsl<? extends T> it) {
                Intrinsics.checkNotNullParameter($this$select, (String)"$this$select");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return $this$select.rangeTo((String)((Object)this.$columnRange.getStart()), (String)((Object)this.$columnRange.getEndInclusive()));
            }
        });
    }

    public static final int getNcol(@NotNull ColumnsContainer<?> $this$ncol) {
        Intrinsics.checkNotNullParameter($this$ncol, (String)"<this>");
        return $this$ncol.columnsCount();
    }

    public static final int getNrow(@NotNull DataFrame<?> $this$nrow) {
        Intrinsics.checkNotNullParameter($this$nrow, (String)"<this>");
        return $this$nrow.rowsCount();
    }

    @NotNull
    public static final IntRange getIndices(@NotNull DataFrame<?> $this$indices) {
        Intrinsics.checkNotNullParameter($this$indices, (String)"<this>");
        return IndicesKt.indices($this$indices);
    }

    @NotNull
    public static final DataFrameSize getSize(@NotNull DataFrame<?> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return DataFrameKt.size($this$size);
    }

    @NotNull
    public static final DataFrameSize size(@NotNull DataFrame<?> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return new DataFrameSize(DataFrameKt.getNcol((ColumnsContainer)$this$size), DataFrameKt.getNrow($this$size));
    }
}

