/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.amd;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.javascript.frameworks.amd.JSAmdIndexingHandler;
import com.intellij.lang.javascript.frameworks.amd.JSAmdModulesIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdRequirePathIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.index.JSCustomSingleEntriesIndex;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JSNonFileAmdModuleReference
extends PsiPolyVariantReferenceBase<PsiElement>
implements JSModuleBaseReference {
    private static final ResolveCache.PolyVariantResolver<JSNonFileAmdModuleReference> MY_RESOLVER = (ref2, incompleteCode) -> ref2.resolveInner();
    @NotNull
    private final String myName;

    public JSNonFileAmdModuleReference(@NotNull PsiElement host, @NotNull String name) {
        if (host == null) {
            JSNonFileAmdModuleReference.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSNonFileAmdModuleReference.$$$reportNull$$$0(1);
        }
        super(host, true);
        this.myName = name;
    }

    public final ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false);
        if (resolveResultArray == null) {
            JSNonFileAmdModuleReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    private ResolveResult[] resolveInner() {
        PsiElement element = this.getElement();
        GlobalSearchScope scope2 = JSResolveUtil.getResolveScope(element);
        HashMap pathAliases = new HashMap();
        StubIndex.getInstance().processElements(JSAmdRequirePathIndex.KEY, (Object)"jsRequirePathAliases", element.getProject(), scope2, JSImplicitElementProvider.class, provider -> {
            Collection<JSImplicitElement> elements;
            JSElementIndexingData data2 = provider.getIndexingData();
            Collection<JSImplicitElement> collection = elements = data2 != null ? data2.getImplicitElements() : null;
            if (elements != null) {
                for (JSImplicitElement element1 : elements) {
                    if (!"jsRequirePathAliases".equals(element1.getName()) || !"arp".equals(element1.getUserString())) continue;
                    pathAliases.put(provider.getContainingFile().getVirtualFile(), element1.getUserStringData());
                }
            }
            return true;
        });
        String moduleAlias = StringUtil.unquoteString((String)this.myName);
        VirtualFile contextVirtualFile = element.getContainingFile().getViewProvider().getVirtualFile();
        PsiManager manager = element.getManager();
        VirtualFile closest = null;
        SmartList candidateResults = new SmartList();
        for (Map.Entry entry : pathAliases.entrySet()) {
            Map<String, String> aliases;
            String alias;
            String serializedAliasesMap = (String)entry.getValue();
            if (!serializedAliasesMap.contains(moduleAlias)) continue;
            VirtualFile file = (VirtualFile)entry.getKey();
            boolean overwriteIfFound = false;
            if (closest != null) {
                int compare = JSAmdUtil.compareClosenessesToContext(file, closest, contextVirtualFile);
                if (compare < 0) {
                    overwriteIfFound = true;
                } else if (compare > 0) continue;
            }
            if ((alias = (aliases = JSAmdIndexingHandler.deserializeMap(serializedAliasesMap)).get(moduleAlias)) == null) continue;
            String path2 = alias + ".js";
            VirtualFile[] includingFilesArray = FileIncludeManager.getManager((Project)element.getProject()).getIncludingFiles(file, false);
            ArrayList<VirtualFile> includingFiles = new ArrayList<VirtualFile>(includingFilesArray.length + 1);
            includingFiles.add(file);
            includingFiles.addAll(Arrays.asList(includingFilesArray));
            for (VirtualFile includingFile : includingFiles) {
                PsiFile psiFile;
                VirtualFile referencedFile;
                if (!FileTypeRegistry.getInstance().isFileOfType(includingFile, (FileType)HtmlFileType.INSTANCE)) continue;
                Ref dataMainValue = Ref.create(null);
                FileBasedIndex.getInstance().processValues(JSCustomSingleEntriesIndex.INDEX_ID, (Object)"js.require.data.main", includingFile, (file1, value) -> {
                    dataMainValue.set(value);
                    return false;
                }, scope2);
                VirtualFile baseFileDir = includingFile.getParent();
                if (!dataMainValue.isNull()) {
                    String dataMainPath = (String)dataMainValue.get() + ".js";
                    VirtualFile mainFilePath = includingFile.getParent().findFileByRelativePath(dataMainPath);
                    if (mainFilePath != null) {
                        baseFileDir = mainFilePath.getParent();
                    }
                }
                if (baseFileDir == null || (referencedFile = baseFileDir.findFileByRelativePath(path2)) == null || (psiFile = manager.findFile(referencedFile)) == null) continue;
                closest = referencedFile;
                if (overwriteIfFound) {
                    candidateResults.clear();
                }
                candidateResults.add(psiFile);
            }
        }
        return (ResolveResult[])Stream.concat(candidateResults.stream(), JSAmdModulesIndex.findNamedAmdModules(element, this.myName, scope2).stream()).map(PsiElementResolveResult::new).toArray(ResolveResult[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/amd/JSNonFileAmdModuleReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/amd/JSNonFileAmdModuleReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

