/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public final class JSConstructorReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public JSConstructorReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element;
        if (p == null) {
            JSConstructorReferencesSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JSConstructorReferencesSearcher.$$$reportNull$$$0(1);
        }
        if (!JSResolveUtil.isConstructorFunction(element = p.getElementToSearch())) {
            return;
        }
        JSFunction constructorFunction = (JSFunction)element;
        JSClass containingClass = JSUtils.getMemberContainingClass(constructorFunction);
        if (containingClass == null) {
            return;
        }
        SearchScope searchScope = p.getEffectiveSearchScope();
        GlobalSearchScope resultScope = JSConstructorReferencesSearcher.getSearchScope(p.getProject(), containingClass, searchScope);
        JSClassSearch.searchClassInheritors(containingClass, false, resultScope).forEach(jsClass -> JSInheritanceUtil.processSuperCallsIn(jsClass, (Processor<? super JSCallExpression>)((Processor)jsCallExpression -> {
            if (PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)jsCallExpression)) {
                return consumer.process((Object)jsCallExpression.getMethodExpression().getReference());
            }
            return false;
        })));
        if ("constructor".equals(constructorFunction.getName())) {
            SearchRequestCollector optimizer = p.getOptimizer();
            ReferencesSearch.searchOptimized((PsiElement)containingClass, (SearchScope)searchScope, (boolean)p.isIgnoreAccessScope(), (SearchRequestCollector)optimizer, (boolean)true, (ref2, collector) -> {
                PsiElement refElement = ref2.getElement();
                if (refElement instanceof JSReferenceExpression && refElement.getParent() instanceof JSNewExpression) {
                    return consumer.process(ref2);
                }
                return true;
            });
        }
        SyntaxTraverser.psiTraverser((PsiElement)containingClass).filter(JSThisExpression.class).forEach(e -> {
            if (e.getParent() instanceof JSCallExpression && e.isReferenceTo(constructorFunction)) {
                consumer.process(e);
            }
        });
    }

    @NotNull
    private static GlobalSearchScope getSearchScope(@NotNull Project project, @NotNull JSClass containingClass, @NotNull SearchScope searchScope) {
        if (project == null) {
            JSConstructorReferencesSearcher.$$$reportNull$$$0(2);
        }
        if (containingClass == null) {
            JSConstructorReferencesSearcher.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            JSConstructorReferencesSearcher.$$$reportNull$$$0(4);
        }
        GlobalSearchScope useScope = JSClassSearch.getUseScope(containingClass);
        GlobalSearchScope globalSearchScope = useScope.intersectWith(GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)searchScope, (Project)project));
        if (globalSearchScope == null) {
            JSConstructorReferencesSearcher.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/search/JSConstructorReferencesSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/search/JSConstructorReferencesSearcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

