/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import kotlinx.serialization.json.internal.ArrayAsSequence;
import kotlinx.serialization.json.internal.InternalJsonReader;
import kotlinx.serialization.json.internal.ReaderJsonLexer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\b\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Lkotlinx/serialization/json/internal/ReaderJsonLexerWithComments;", "Lkotlinx/serialization/json/internal/ReaderJsonLexer;", "reader", "Lkotlinx/serialization/json/internal/InternalJsonReader;", "buffer", "", "<init>", "(Lkotlinx/serialization/json/internal/InternalJsonReader;[C)V", "consumeNextToken", "", "expected", "", "canConsumeValue", "", "", "peekNextToken", "handleComment", "Lkotlin/Pair;", "", "position", "prefetchWithinThreshold", "skipWhitespaces", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nCommentLexers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentLexers.kt\nkotlinx/serialization/json/internal/ReaderJsonLexerWithComments\n+ 2 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n*L\n1#1,219:1\n158#2:220\n*S KotlinDebug\n*F\n+ 1 CommentLexers.kt\nkotlinx/serialization/json/internal/ReaderJsonLexerWithComments\n*L\n204#1:220\n*E\n"})
public final class ReaderJsonLexerWithComments
extends ReaderJsonLexer {
    public ReaderJsonLexerWithComments(@NotNull InternalJsonReader reader, @NotNull char[] buffer) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        super(reader, buffer);
    }

    @Override
    public void consumeNextToken(char expected) {
        this.ensureHaveChars();
        ArrayAsSequence source = this.getSource();
        int current = this.skipWhitespaces();
        if (current >= source.length() || current == -1) {
            this.currentPosition = -1;
            this.unexpectedToken(expected);
        }
        char c = source.charAt(current);
        this.currentPosition = current + 1;
        if (c == expected) {
            return;
        }
        this.unexpectedToken(expected);
    }

    @Override
    public boolean canConsumeValue() {
        this.ensureHaveChars();
        int current = this.skipWhitespaces();
        if (current >= this.getSource().length() || current == -1) {
            return false;
        }
        return this.isValidValueStart(this.getSource().charAt(current));
    }

    @Override
    public byte consumeNextToken() {
        this.ensureHaveChars();
        ArrayAsSequence source = this.getSource();
        int cpos = this.skipWhitespaces();
        if (cpos >= source.length() || cpos == -1) {
            return 10;
        }
        this.currentPosition = cpos + 1;
        return AbstractJsonLexerKt.charToTokenClass(source.charAt(cpos));
    }

    @Override
    public byte peekNextToken() {
        this.ensureHaveChars();
        ArrayAsSequence source = this.getSource();
        int cpos = this.skipWhitespaces();
        if (cpos >= source.length() || cpos == -1) {
            return 10;
        }
        this.currentPosition = cpos;
        return AbstractJsonLexerKt.charToTokenClass(source.charAt(cpos));
    }

    private final Pair<Integer, Boolean> handleComment(int position) {
        int current = position;
        int startIndex = current + 2;
        switch (this.getSource().charAt(current + 1)) {
            case '/': {
                while (current != -1) {
                    current = StringsKt.indexOf$default((CharSequence)this.getSource(), '\n', startIndex, false, 4, null);
                    if (current == -1) {
                        startIndex = current = this.prefetchOrEof(this.getSource().length());
                        continue;
                    }
                    return TuplesKt.to(current + 1, true);
                }
                return TuplesKt.to(-1, true);
            }
            case '*': {
                boolean rareCaseHit = false;
                while (current != -1) {
                    current = StringsKt.indexOf$default((CharSequence)this.getSource(), "*/", startIndex, false, 4, null);
                    if (current != -1) {
                        return TuplesKt.to(current + 2, true);
                    }
                    if (this.getSource().charAt(this.getSource().length() - 1) != '*') {
                        startIndex = current = this.prefetchOrEof(this.getSource().length());
                        continue;
                    }
                    current = this.prefetchWithinThreshold(this.getSource().length() - 1);
                    if (rareCaseHit) break;
                    rareCaseHit = true;
                    startIndex = current;
                }
                this.currentPosition = this.getSource().length();
                AbstractJsonLexer.fail$default(this, "Expected end of the block comment: \"*/\", but had EOF instead", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
        }
        return TuplesKt.to(current, false);
    }

    private final int prefetchWithinThreshold(int position) {
        if (this.getSource().length() - position > this.threshold) {
            return position;
        }
        this.currentPosition = position;
        this.ensureHaveChars();
        if (this.currentPosition != 0 || ((CharSequence)this.getSource()).length() == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public int skipWhitespaces() {
        int current = this.currentPosition;
        while ((current = this.prefetchOrEof(current)) != -1) {
            char c = this.getSource().charAt(current);
            Object object = this;
            char $this$isWs$iv = c;
            boolean $i$f$isWs = false;
            if ($this$isWs$iv == ' ' || $this$isWs$iv == '\n' || $this$isWs$iv == '\r' || $this$isWs$iv == '\t') {
                ++current;
                continue;
            }
            if (c != '/' || current + 1 >= this.getSource().length()) break;
            object = this.handleComment(current);
            int n = ((Number)((Pair)object).component1()).intValue();
            boolean cont = (Boolean)((Pair)object).component2();
            current = n;
            if (cont) continue;
            break;
        }
        this.currentPosition = current;
        return current;
    }
}

