/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.audit;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.audit.AuditService;
import com.intellij.database.dataSource.connection.audit.JdbcObjectsListener;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.sql.SQLWarning;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001f2\u00020\u00012\u00060\u0002j\u0002`\u0003:\u0003\u001f !B\u0019\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u001b\u001a\u00020\u000fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\b\u0010\u001e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u0082\u0001\u0002\"#\u00a8\u0006$"}, d2={"Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "Lcom/intellij/database/dataSource/connection/audit/JdbcObjectsListener;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;)V", "getConnection", "()Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "getAuditService", "()Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "statementOpened", "", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "beforeStatementClosing", "resultsOpened", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "beforeResultsClosing", "printStatementWarnings", "printResultSetWarnings", "printConnectionWarnings", "isClosed", "", "close", "Companion", "Async", "Sync", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Async;", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Sync;", "intellij.database.core.impl"})
public abstract class JdbcWarningsListener
implements JdbcObjectsListener,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseConnectionCore connection;
    @NotNull
    private final ListenerAuditService auditService;

    private JdbcWarningsListener(DatabaseConnectionCore connection2, ListenerAuditService auditService) {
        this.connection = connection2;
        this.auditService = auditService;
    }

    @NotNull
    protected final DatabaseConnectionCore getConnection() {
        return this.connection;
    }

    @NotNull
    protected final ListenerAuditService getAuditService() {
        return this.auditService;
    }

    @Override
    public void statementOpened(@NotNull RemoteStatement statement2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.printStatementWarnings(statement2, mark2);
    }

    @Override
    public void beforeStatementClosing(@NotNull RemoteStatement statement2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.printStatementWarnings(statement2, mark2);
        this.printConnectionWarnings();
    }

    @Override
    public void resultsOpened(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.printResultSetWarnings(resultSet, mark2);
    }

    @Override
    public void beforeResultsClosing(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        this.printResultSetWarnings(resultSet, mark2);
    }

    public void printStatementWarnings(@NotNull RemoteStatement statement2, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        if (this.isClosed(statement2)) {
            return;
        }
        Companion.printAllWarnings((List)JdbcWarningsListener.Companion.runSafe(() -> JdbcWarningsListener.printStatementWarnings$lambda$0(statement2)), this.auditService, mark2);
    }

    public final void printResultSetWarnings(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        if (this.isClosed(resultSet)) {
            return;
        }
        Companion.printAllWarnings((List)JdbcWarningsListener.Companion.runSafe(() -> JdbcWarningsListener.printResultSetWarnings$lambda$1(resultSet)), this.auditService, mark2);
    }

    public final void printConnectionWarnings() {
        Companion.printAllWarnings((List)JdbcWarningsListener.Companion.runSafe(() -> JdbcWarningsListener.printConnectionWarnings$lambda$2(this)), this.auditService, null);
    }

    protected final boolean isClosed(@NotNull RemoteStatement statement2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
        try {
            bl = statement2.isClosed();
        }
        catch (Throwable t) {
            bl = true;
        }
        return bl;
    }

    protected final boolean isClosed(@NotNull RemoteResultSet resultSet) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        try {
            bl = resultSet.isClosed();
        }
        catch (Throwable t) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void close() {
    }

    private static final List printStatementWarnings$lambda$0(RemoteStatement $statement) {
        return $statement.getAllWarnings();
    }

    private static final List printResultSetWarnings$lambda$1(RemoteResultSet $resultSet) {
        return $resultSet.getAllWarnings();
    }

    private static final List printConnectionWarnings$lambda$2(JdbcWarningsListener this$0) {
        return this$0.connection.getRemoteConnection().getAllWarnings();
    }

    @JvmStatic
    @NotNull
    public static final JdbcWarningsListener listenFor(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService) {
        return Companion.listenFor(connection2, auditService);
    }

    public /* synthetic */ JdbcWarningsListener(DatabaseConnectionCore connection2, ListenerAuditService auditService, DefaultConstructorMarker $constructor_marker) {
        this(connection2, auditService);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\u0012H\u0016J\u0016\u0010\u001b\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0002J\u001e\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u001dH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Async;", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;)V", "statementsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "resultsLock", "statements", "", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "results", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "statementOpened", "", "statement", "mark", "printStatementWarnings", "beforeStatementClosing", "resultsOpened", "resultSet", "beforeResultsClosing", "close", "withStatementsLocked", "runnable", "Lkotlin/Function0;", "withResultsLocked", "locked", "lock", "Companion", "intellij.database.core.impl"})
    public static final class Async
    extends JdbcWarningsListener {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ReentrantLock statementsLock;
        @NotNull
        private final ReentrantLock resultsLock;
        @NotNull
        private final Map<RemoteStatement, SmartStatementMark> statements;
        @NotNull
        private final Map<RemoteResultSet, SmartStatementMark> results;
        @NotNull
        private static final Set<Async> ourWatchers;
        @Nullable
        private static ScheduledFuture<?> ourWarningsScheduledFuture;

        public Async(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            super(connection2, auditService, null);
            ((Collection)ourWatchers).add(this);
            Async.Companion.schedulePrintAllWarnings();
            this.statementsLock = new ReentrantLock();
            this.resultsLock = new ReentrantLock();
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
            this.statements = concurrentMap;
            ConcurrentMap concurrentMap2 = ContainerUtil.createConcurrentWeakMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentWeakMap(...)");
            this.results = concurrentMap2;
        }

        @Override
        public void statementOpened(@NotNull RemoteStatement statement2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.withStatementsLocked((Function0<Unit>)((Function0)() -> Async.statementOpened$lambda$0(this, statement2, mark2)));
        }

        @Override
        public void printStatementWarnings(@NotNull RemoteStatement statement2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.withStatementsLocked((Function0<Unit>)((Function0)() -> Async.printStatementWarnings$lambda$1(this, statement2, mark2)));
        }

        @Override
        public void beforeStatementClosing(@NotNull RemoteStatement statement2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            if (this.isClosed(statement2)) {
                return;
            }
            this.withStatementsLocked((Function0<Unit>)((Function0)() -> Async.beforeStatementClosing$lambda$2(this, statement2, mark2)));
        }

        @Override
        public void resultsOpened(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            this.withResultsLocked((Function0<Unit>)((Function0)() -> Async.resultsOpened$lambda$3(this, resultSet, mark2)));
        }

        @Override
        public void beforeResultsClosing(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
            if (this.isClosed(resultSet)) {
                return;
            }
            this.withResultsLocked((Function0<Unit>)((Function0)() -> Async.beforeResultsClosing$lambda$4(this, resultSet, mark2)));
        }

        @Override
        public void close() {
            this.statements.clear();
            this.results.clear();
            ((Collection)ourWatchers).remove(this);
            super.close();
        }

        private final void withStatementsLocked(Function0<Unit> runnable) {
            this.locked(this.statementsLock, runnable);
        }

        private final void withResultsLocked(Function0<Unit> runnable) {
            this.locked(this.resultsLock, runnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void locked(ReentrantLock lock, Function0<Unit> runnable) {
            lock.lock();
            try {
                runnable.invoke();
            }
            finally {
                lock.unlock();
            }
        }

        private static final Unit statementOpened$lambda$0(Async this$0, RemoteStatement $statement, SmartStatementMark $mark) {
            super.statementOpened($statement, $mark);
            this$0.statements.put($statement, $mark);
            return Unit.INSTANCE;
        }

        private static final Unit printStatementWarnings$lambda$1(Async this$0, RemoteStatement $statement, SmartStatementMark $mark) {
            super.printStatementWarnings($statement, $mark);
            return Unit.INSTANCE;
        }

        private static final Unit beforeStatementClosing$lambda$2(Async this$0, RemoteStatement $statement, SmartStatementMark $mark) {
            this$0.statements.remove($statement);
            super.beforeStatementClosing($statement, $mark);
            return Unit.INSTANCE;
        }

        private static final Unit resultsOpened$lambda$3(Async this$0, RemoteResultSet $resultSet, SmartStatementMark $mark) {
            super.resultsOpened($resultSet, $mark);
            this$0.results.put($resultSet, $mark);
            return Unit.INSTANCE;
        }

        private static final Unit beforeResultsClosing$lambda$4(Async this$0, RemoteResultSet $resultSet, SmartStatementMark $mark) {
            this$0.results.remove($resultSet);
            super.beforeResultsClosing($resultSet, $mark);
            return Unit.INSTANCE;
        }

        static {
            Set set = ConcurrentCollectionFactory.createConcurrentIdentitySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentIdentitySet(...)");
            ourWatchers = set;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002R@\u0010\u0004\u001a2\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b \n*\u0017\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\t\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Async$Companion;", "", "<init>", "()V", "ourWatchers", "", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Async;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "Ljava/util/Set;", "ourWarningsScheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "schedulePrintAllWarnings", "", "printAllWarnings", "intellij.database.core.impl"})
        public static final class Companion {
            private Companion() {
            }

            private final void schedulePrintAllWarnings() {
                ScheduledFuture scheduledFuture = ourWarningsScheduledFuture;
                if (scheduledFuture != null) {
                    scheduledFuture.cancel(false);
                }
                ourWarningsScheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().schedule(Companion::schedulePrintAllWarnings$lambda$0, 300L, TimeUnit.MILLISECONDS);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void printAllWarnings() {
                for (Object e : ourWatchers) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Async watcher = (Async)e;
                    if (watcher.statementsLock.tryLock()) {
                        try {
                            for (Map.Entry statement2 : watcher.statements.entrySet()) {
                                if (!((SmartStatementMark)statement2.getValue()).getRunning()) continue;
                                watcher.printStatementWarnings((RemoteStatement)statement2.getKey(), (SmartStatementMark)statement2.getValue());
                            }
                        }
                        finally {
                            watcher.statementsLock.unlock();
                        }
                    }
                    if (!watcher.resultsLock.tryLock()) continue;
                    try {
                        for (Map.Entry result2 : watcher.results.entrySet()) {
                            watcher.printResultSetWarnings((RemoteResultSet)result2.getKey(), (SmartStatementMark)result2.getValue());
                        }
                    }
                    finally {
                        watcher.resultsLock.unlock();
                    }
                }
                if (!((Collection)ourWatchers).isEmpty()) {
                    this.schedulePrintAllWarnings();
                }
            }

            private static final void schedulePrintAllWarnings$lambda$0() {
                Companion.printAllWarnings();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J*\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0004J#\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Companion;", "", "<init>", "()V", "listenFor", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "printAllWarnings", "", "warnings", "", "Ljava/sql/SQLWarning;", "service", "Lcom/intellij/database/dataSource/connection/audit/AuditService;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "runSafe", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JdbcWarningsListener listenFor(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            Dbms dbms = connection2.getDbms();
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            Dbms family = dbms;
            return Intrinsics.areEqual((Object)family, (Object)Dbms.POSTGRES) || Intrinsics.areEqual((Object)family, (Object)Dbms.GREENPLUM) || family.isMicrosoft() ? (JdbcWarningsListener)new Async(connection2, auditService) : (JdbcWarningsListener)new Sync(connection2, auditService);
        }

        protected final void printAllWarnings(@Nullable List<? extends SQLWarning> warnings, @NotNull AuditService service, @Nullable SmartStatementMark mark2) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            if (warnings == null) {
                return;
            }
            for (SQLWarning sQLWarning : warnings) {
                if (mark2 != null) {
                    service.warning(sQLWarning, mark2);
                    continue;
                }
                service.warning(sQLWarning);
            }
        }

        private final <T> T runSafe(Function0<? extends T> runnable) {
            try {
                return (T)runnable.invoke();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener$Sync;", "Lcom/intellij/database/dataSource/connection/audit/JdbcWarningsListener;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;)V", "intellij.database.core.impl"})
    public static final class Sync
    extends JdbcWarningsListener {
        public Sync(@NotNull DatabaseConnectionCore connection2, @NotNull ListenerAuditService auditService) {
            Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)auditService, (String)"auditService");
            super(connection2, auditService, null);
        }
    }
}

