/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionManager;
import com.intellij.database.dataSource.ui.DriverInstantiateComponent;
import com.intellij.database.util.Version;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent;", "", "configurable", "Lcom/intellij/database/dataSource/DataSourceConfigurable;", "<init>", "(Lcom/intellij/database/dataSource/DataSourceConfigurable;)V", "getConfigurable", "()Lcom/intellij/database/dataSource/DataSourceConfigurable;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "statusIcon", "Ljavax/swing/JLabel;", "statusText", "Lcom/intellij/ui/components/labels/LinkLabel;", "getInfo", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestInfo;", "showDetails", "", "info", "update", "GrayLabel", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceTestConnectionComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceTestConnectionComponent.kt\ncom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class DataSourceTestConnectionComponent {
    @NotNull
    private final DataSourceConfigurable configurable;
    @NotNull
    private final JComponent component;
    @NotNull
    private final JLabel statusIcon;
    @NotNull
    private final LinkLabel<?> statusText;

    public DataSourceTestConnectionComponent(@NotNull DataSourceConfigurable configurable) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        this.configurable = configurable;
        Ref.ObjectRef iconLbl = new Ref.ObjectRef();
        Ref.ObjectRef statusLbl = new Ref.ObjectRef();
        this.component = (JComponent)BuilderKt.panel(arg_0 -> DataSourceTestConnectionComponent._init_$lambda$7(this, iconLbl, statusLbl, arg_0));
        Object object = iconLbl.element;
        Intrinsics.checkNotNull((Object)object);
        this.statusIcon = (JLabel)object;
        Object object2 = statusLbl.element;
        Intrinsics.checkNotNull((Object)object2);
        this.statusText = (LinkLabel)object2;
        ((DialogPanel)this.component).setBorder(DriverInstantiateComponent.Companion.getTopPanelBorder());
        this.update(this.getInfo());
    }

    @NotNull
    public final DataSourceConfigurable getConfigurable() {
        return this.configurable;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    private final DataSourceTestConnectionManager.TestInfo getInfo() {
        return this.configurable.getTestConnectionManager().getInfo(null);
    }

    private final void showDetails(DataSourceTestConnectionManager.TestInfo info2) {
        DataSourceTestConnectionManager dataSourceTestConnectionManager = this.configurable.getTestConnectionManager();
        RelativePoint relativePoint = RelativePoint.getNorthWestOf((JComponent)((JComponent)this.statusText));
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"getNorthWestOf(...)");
        dataSourceTestConnectionManager.showDetails(relativePoint, info2);
    }

    public final void update(@NotNull DataSourceTestConnectionManager.TestInfo info2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        DataSourceInfo dbi = this.configurable.getDatabaseInfo();
        this.statusIcon.setIcon(info2.getIcon());
        Object it = object = StringKt.nullize$default((String)dbi.getDatabaseVersion().name, (boolean)false, (int)1, null);
        boolean bl = false;
        Object object2 = Intrinsics.areEqual((Object)dbi.getDbms(), (Object)Dbms.UNKNOWN) || dbi.getDbms() == null ? object : null;
        if (object2 == null) {
            Dbms dbms = dbi.getDbms();
            object2 = dbms != null ? dbms.getDisplayName() : null;
            if (object2 == null) {
                object2 = "";
            }
        }
        String name2 = object2;
        it = object = dbi.getExactVersion();
        boolean bl2 = false;
        Object version = !Intrinsics.areEqual((Object)it, (Object)Version.ZERO) ? object : null;
        Object object3 = version;
        if (object3 == null) {
            object3 = "";
        }
        this.statusText.setText(name2 + " " + object3);
        if (info2.getStatus() != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.showDetails(info2);
        }
    }

    private static final Unit lambda$7$lambda$6$lambda$0(DataSourceTestConnectionComponent this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CoroutineScope coroutineScope = this$0.configurable.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)ModalityKt.asContextElement((ModalityState)modalityState), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ DataSourceTestConnectionComponent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getConfigurable().getTestConnectionManager().testConnection(null, true, (Continuation<Object>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$lambda$6$lambda$1(Ref.ObjectRef $iconLbl, JLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $iconLbl.element = $this$applyToComponent;
        return Unit.INSTANCE;
    }

    private static final void lambda$7$lambda$6$lambda$2(DataSourceTestConnectionComponent this$0, LinkLabel linkLabel, Object object) {
        this$0.showDetails(this$0.getInfo());
    }

    private static final Unit lambda$7$lambda$6$lambda$3(Ref.ObjectRef $statusLbl, GrayLabel $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyToComponent), (String)"$this$applyToComponent");
        $statusLbl.element = $this$applyToComponent;
        return Unit.INSTANCE;
    }

    private static final Unit lambda$7$lambda$6(DataSourceTestConnectionComponent this$0, Ref.ObjectRef $iconLbl, Ref.ObjectRef $statusLbl, Row $this$row) {
        ActionToolbar actionToolbar;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DatabaseBundle.message("DataSourceTestConnectionPanel.test.connection", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.link(string, arg_0 -> DataSourceTestConnectionComponent.lambda$7$lambda$6$lambda$0(this$0, arg_0)).gap(RightGap.SMALL);
        Icon icon = AllIcons.RunConfigurations.TestPassed;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TestPassed");
        $this$row.icon(icon).applyToComponent(arg_0 -> DataSourceTestConnectionComponent.lambda$7$lambda$6$lambda$1($iconLbl, arg_0)).gap(RightGap.SMALL);
        $this$row.cell((JComponent)((Object)new GrayLabel("", null, (LinkListener<Object>)((LinkListener)(arg_0, arg_1) -> DataSourceTestConnectionComponent.lambda$7$lambda$6$lambda$2(this$0, arg_0, arg_1))))).applyToComponent(arg_0 -> DataSourceTestConnectionComponent.lambda$7$lambda$6$lambda$3($statusLbl, arg_0));
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction anAction = this$0.configurable.getController().createResetAction(this$0.configurable);
        if (anAction != null) {
            AnAction it = anAction;
            boolean bl = false;
            group.add(it);
        }
        ActionToolbar $this$lambda_u247_u24lambda_u246_u24lambda_u245 = actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)group, true);
        boolean bl = false;
        $this$lambda_u247_u24lambda_u246_u24lambda_u245.setMiniMode(true);
        $this$lambda_u247_u24lambda_u246_u24lambda_u245.setTargetComponent(this$0.configurable.getPreferredFocusedComponent());
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar toolbar = actionToolbar2;
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        $this$row.cell(jComponent).align((Align)AlignX.RIGHT.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(DataSourceTestConnectionComponent this$0, Ref.ObjectRef $iconLbl, Ref.ObjectRef $statusLbl, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DataSourceTestConnectionComponent.lambda$7$lambda$6(this$0, $iconLbl, $statusLbl, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B0\u0012\r\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0014J\b\u0010\u000f\u001a\u00020\rH\u0014J\b\u0010\u0010\u001a\u00020\rH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionComponent$GrayLabel;", "Lcom/intellij/ui/components/labels/LinkLabel;", "", "text", "", "Lcom/intellij/openapi/util/NlsContexts$LinkLabel;", "icon", "Ljavax/swing/Icon;", "aListener", "Lcom/intellij/ui/components/labels/LinkListener;", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/ui/components/labels/LinkListener;)V", "getActive", "Ljava/awt/Color;", "getNormal", "getHover", "getVisited", "intellij.database.impl"})
    public static final class GrayLabel
    extends LinkLabel<Object> {
        public GrayLabel(@Nullable String text2, @Nullable Icon icon, @Nullable LinkListener<Object> aListener) {
            super(text2, icon, aListener);
            this.setFocusable(true);
        }

        @NotNull
        protected Color getActive() {
            return this.getNormal();
        }

        @NotNull
        protected Color getNormal() {
            Color color = JBUI.CurrentTheme.Label.disabledForeground((boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"disabledForeground(...)");
            return color;
        }

        @NotNull
        protected Color getHover() {
            Color color = JBUI.CurrentTheme.Label.foreground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground(...)");
            return color;
        }

        @NotNull
        protected Color getVisited() {
            return this.getNormal();
        }
    }
}

