/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.FormatTestResult;
import com.intellij.database.data.types.FormatTester;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dialects.base.BasePredicatesHelper;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/db2/Db2PredicatesHelper;", "Lcom/intellij/database/dialects/base/BasePredicatesHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "supportsInOperator", "", "getSupportsInOperator", "()Z", "getFormatTester", "Lcom/intellij/database/data/types/FormatTester;", "columnRef", "Lcom/intellij/database/data/types/ColumnRef;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "version", "Lcom/intellij/database/util/Version;", "intellij.database.dialects.db2"})
public final class Db2PredicatesHelper
extends BasePredicatesHelper {
    public Db2PredicatesHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Override
    public boolean getSupportsInOperator() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    protected FormatTester getFormatTester(@NotNull ColumnRef columnRef, @Nullable Domain domain, @Nullable Version version) {
        FormatTester formatTester;
        String string;
        Intrinsics.checkNotNullParameter((Object)columnRef, (String)"columnRef");
        Domain domain2 = domain;
        String string2 = string = domain2 != null ? domain2.simpleName() : null;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 3026845: {
                    if (!string.equals("blob")) break;
                    n = 1;
                    break;
                }
                case -1324184425: {
                    if (!string.equals("varchar for bit data")) break;
                    n = 2;
                    break;
                }
                case -1388966911: {
                    if (!string.equals("binary")) break;
                    n = 1;
                    break;
                }
                case 1978925278: {
                    if (!string.equals("char for bit data")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    formatTester = new FormatTester(true, false, (Function1<? super String, ? extends FormatTestResult>)((Function1)Db2PredicatesHelper::getFormatTester$lambda$0));
                    return formatTester;
                }
                case 2: {
                    formatTester = new FormatTester(true, false, (Function1<? super String, ? extends FormatTestResult>)((Function1)Db2PredicatesHelper::getFormatTester$lambda$1));
                    return formatTester;
                }
            }
        }
        formatTester = super.getFormatTester(columnRef, domain, version);
        return formatTester;
    }

    private static final FormatTestResult getFormatTester$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringUtil.startsWithIgnoreCase((String)it, (String)"blob(") && StringsKt.endsWith$default((String)it, (String)")", (boolean)false, (int)2, null) || StringUtil.startsWithIgnoreCase((String)it, (String)"bx'") && StringsKt.endsWith$default((String)it, (String)"'", (boolean)false, (int)2, null) ? FormatTestResult.NOT_QUOTE : FormatTestResult.NOT_MATCHED;
    }

    private static final FormatTestResult getFormatTester$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringUtil.startsWithIgnoreCase((String)it, (String)"blob(") && StringsKt.endsWith$default((String)it, (String)")", (boolean)false, (int)2, null) || StringUtil.startsWithIgnoreCase((String)it, (String)"x'") && StringsKt.endsWith$default((String)it, (String)"'", (boolean)false, (int)2, null) ? FormatTestResult.NOT_QUOTE : FormatTestResult.NOT_MATCHED;
    }
}

