/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.pgpass;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dialects.postgresbase.pgpass.PgPassEntry;
import com.intellij.database.dialects.postgresbase.pgpass.PgPassFile;
import com.intellij.database.view.DatabaseCoreUiService;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.PathMacroUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0006H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0017J$\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010!\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u000bH\u0016J$\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010\b2\u0006\u0010'\u001a\u00020\u0006H\u0002J\u001e\u0010(\u001a\u00020\u00062\u0014\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010*H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\f\u001a\u00020\rH\u0002R/\u0010\u0004\u001a#\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b0\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "<init>", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassFile;", "Lorg/jetbrains/annotations/NotNull;", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getId", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "getDisplayName", "loadAuthConfig", "", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "external", "saveAuthConfig", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "data", "createWidget", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$AuthWidget;", "project", "Lcom/intellij/openapi/project/Project;", "getFile", "path", "getLocation", "vmEnv", "", "getCredentials", "Lcom/intellij/credentialStore/Credentials;", "Companion", "intellij.database.dialects.postgresbase"})
@SourceDebugExtension(value={"SMAP\nPgPassAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgPassAuthProvider.kt\ncom/intellij/database/dialects/postgresbase/pgpass/PgPassAuthProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n19#2:106\n1#3:107\n*S KotlinDebug\n*F\n+ 1 PgPassAuthProvider.kt\ncom/intellij/database/dialects/postgresbase/pgpass/PgPassAuthProvider\n*L\n64#1:106\n*E\n"})
public final class PgPassAuthProvider
implements DatabaseAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<String, PgPassFile> cache;
    @NotNull
    public static final String ID = "pgpass";

    public PgPassAuthProvider() {
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.create(arg_0 -> PgPassAuthProvider.cache$lambda$1(PgPassAuthProvider::cache$lambda$0, arg_0), ContainerUtil::createConcurrentSoftValueMap);
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"create(...)");
        this.cache = concurrentMap;
    }

    @Override
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto2, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        DatabaseCredentialsAuthProvider.Companion.applyCredentials(proto2, this.getCredentials(proto2), false);
        return Boxing.boxBoolean((boolean)true);
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @Override
    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (!point.getDbms().isPostgres()) {
            return DatabaseAuthProvider.ApplicabilityLevel.Result.NOT_APPLICABLE;
        }
        if (level == DatabaseAuthProvider.ApplicabilityLevel.DEFAULT) {
            Object object = point.getDatabaseDriver();
            if (object == null || (object = object.getVmEnv()) == null) {
                object = MapsKt.emptyMap();
            }
            Map<String, String> map2 = point.getDataSource().getVmEnv();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"getVmEnv(...)");
            File hasPgPass = new File(this.getLocation(MapsKt.plus((Map)object, map2)));
            if (hasPgPass.exists()) {
                return DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT;
            }
        }
        return DatabaseAuthProvider.ApplicabilityLevel.Result.APPLICABLE;
    }

    @Override
    @NlsSafe
    @NotNull
    public String getDisplayName() {
        return ID;
    }

    @Override
    @Nullable
    public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (external) {
            return null;
        }
        return StringUtil.nullize((String)LocalDataSource.getUsername(point));
    }

    @Override
    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (external) {
            return;
        }
        Object $this$asSafely$iv = data;
        boolean $i$f$asSafely = false;
        Object object = $this$asSafely$iv;
        if (!(object instanceof String)) {
            object = null;
        }
        LocalDataSource.setUsername(config, (String)object);
    }

    @Override
    @Nullable
    public DatabaseAuthProvider.AuthWidget createWidget(@Nullable Project project, @NotNull DatabaseCredentials credentials, @NotNull DatabaseConnectionConfig config) {
        DatabaseAuthProvider.AuthWidget authWidget;
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        AuthWidgetBuilder authWidgetBuilder = DatabaseCoreUiService.getInstance().createAuthWidgetBuilder();
        if (authWidgetBuilder != null) {
            AuthWidgetBuilder $this$createWidget_u24lambda_u242 = authWidgetBuilder;
            boolean bl = false;
            $this$createWidget_u24lambda_u242.addUserField();
            authWidget = $this$createWidget_u24lambda_u242.build(project, credentials, config);
        } else {
            authWidget = null;
        }
        return authWidget;
    }

    private final PgPassFile getFile(String path) {
        String string = PathManager.getAbsolutePath((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String absolutePath = string;
        PgPassFile res2 = (PgPassFile)this.cache.get(absolutePath);
        if (res2 != null && res2.getStamp() != new File(absolutePath).lastModified()) {
            this.cache.remove(absolutePath);
            return (PgPassFile)this.cache.get(absolutePath);
        }
        return res2;
    }

    private final String getLocation(Map<String, String> vmEnv) {
        String string;
        if (vmEnv != null && (string = vmEnv.get("PGPASSFILE")) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        string = EnvironmentUtil.getValue((String)"PGPASSFILE");
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        if (SystemInfo.isWindows) {
            return EnvironmentUtil.getValue((String)"APPDATA") + "\\postgresql\\pgpass.conf";
        }
        return PathMacroUtil.getUserHomePath() + "/.pgpass";
    }

    private final Credentials getCredentials(DatabaseConnectionInterceptor.ProtoConnection proto2) {
        String string;
        String db;
        String path = this.getLocation(proto2.getVmEnv());
        PgPassFile pgPassFile = this.getFile(path);
        if (pgPassFile == null) {
            throw new RuntimeException("No pgpass file at `" + path + "`");
        }
        PgPassFile file = pgPassFile;
        JdbcUrlParser jdbcUrlParser = JdbcUrlParserUtil.parsed(proto2.getConnectionPoint(), proto2.getUrl());
        if (jdbcUrlParser == null) {
            throw new RuntimeException("Unable to parse `" + proto2.getUrl() + "`");
        }
        JdbcUrlParser props = jdbcUrlParser;
        String string2 = props.getParameter("host");
        if (string2 == null) {
            throw new RuntimeException("Host not found in `" + proto2.getUrl() + "`");
        }
        String host = string2;
        String string3 = props.getParameter("port");
        if (string3 == null) {
            throw new RuntimeException("Port not found in `" + proto2.getUrl() + "`");
        }
        String port = string3;
        String string4 = props.getParameter("database");
        if (string4 == null) {
            string4 = db = "postgres";
        }
        if ((string = DatabaseCredentialsAuthProvider.Companion.getUser(proto2)) == null && (string = StringUtil.nullize((String)props.getParameter("user"))) == null) {
            String string5 = proto2.getConnectionPoint().getDataSource().getUsername();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getUsername(...)");
        }
        String user = string;
        PgPassEntry pgPassEntry = file.entry(host, port, db, user);
        if (pgPassEntry == null) {
            throw new RuntimeException("No matching entry for `" + proto2.getUrl() + "` found in `" + path + "`");
        }
        PgPassEntry it = pgPassEntry;
        boolean bl = false;
        return new Credentials(user, it.getPass());
    }

    private static final PgPassFile cache$lambda$0(String path) {
        return PgPassFile.Companion.parse(new File(path));
    }

    private static final PgPassFile cache$lambda$1(Function1 $tmp0, Object p0) {
        return (PgPassFile)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/postgresbase/pgpass/PgPassAuthProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.database.dialects.postgresbase"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

