/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColumnAction
extends DumbAwareAction
implements UserDataHolder {
    final UserDataHolderBase context = new UserDataHolderBase();

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ColumnAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            ColumnAction.$$$reportNull$$$0(1);
        }
        return (T)this.context.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            ColumnAction.$$$reportNull$$$0(2);
        }
        this.context.putUserData(key, value);
    }

    protected boolean availableInTable() {
        return false;
    }

    protected abstract void actionPerformed(DataGrid var1, List<ModelIndex<GridColumn>> var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            ColumnAction.$$$reportNull$$$0(3);
        }
        if ((dataGrid = GridUtil.getDataGrid(e.getDataContext())) == null) {
            return;
        }
        List<ModelIndex<GridColumn>> columns = ColumnAction.getSelectedColumns(dataGrid, e.getDataContext(), this.availableInTable());
        if (columns.isEmpty()) {
            return;
        }
        this.actionPerformed(dataGrid, columns);
    }

    @NotNull
    private static List<ModelIndex<GridColumn>> getSelectedColumns(@Nullable DataGrid dataGrid, @NotNull DataContext dataContext, boolean allowInTable) {
        if (dataContext == null) {
            ColumnAction.$$$reportNull$$$0(4);
        }
        PsiElement[] selectedPsi = (PsiElement[])PlatformCoreDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        if (allowInTable && dataGrid != null && dataGrid.getContextColumn().asInteger() != -1) {
            List<ModelIndex<GridColumn>> list = Collections.singletonList(dataGrid.getContextColumn());
            if (list == null) {
                ColumnAction.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (selectedPsi == null) {
            List list = allowInTable && dataGrid != null ? dataGrid.getSelectionModel().getSelectedColumns().asIterable().map(c -> c).toList() : Collections.emptyList();
            if (list == null) {
                ColumnAction.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<ModelIndex<GridColumn>> result = new ArrayList<ModelIndex<GridColumn>>(selectedPsi.length);
        for (PsiElement element : selectedPsi) {
            DataGridPomTarget.Cell cell;
            DataGridPomTarget.Column target = DataGridPomTarget.unwrapColumn(element);
            if (target != null && target.dataGrid == dataGrid) {
                result.add(target.column);
                continue;
            }
            DataGridPomTarget.Cell cell2 = cell = allowInTable ? DataGridPomTarget.unwrapCell(element) : null;
            if (cell == null || cell.dataGrid != dataGrid) continue;
            cell.columns.asIterable().map(c -> c).addAllTo(result);
        }
        ArrayList<ModelIndex<GridColumn>> arrayList = result;
        if (arrayList == null) {
            ColumnAction.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ColumnAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ColumnAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumns";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedColumns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    public static class SortReset
    extends SortAction {
        public SortReset() {
            super(RowSortOrder.Type.UNSORTED, false);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SortReset.$$$reportNull$$$0(0);
            }
            super.update(e);
            DataGrid dataGrid = GridUtil.getDataGrid(e.getDataContext());
            if (dataGrid == null) {
                return;
            }
            List<ModelIndex<GridColumn>> selectedColumns = ColumnAction.getSelectedColumns(dataGrid, e.getDataContext(), this.availableInTable());
            List<ModelIndex<GridColumn>> columns = SortReset.getNotInserted(dataGrid, selectedColumns);
            boolean sameOrder = ContainerUtil.all(columns, column -> dataGrid.getSortOrder((ModelIndex<GridColumn>)column) == this.mySortOrder);
            e.getPresentation().setEnabled(!sameOrder);
        }

        @Override
        protected void actionPerformed(DataGrid dataGrid, List<ModelIndex<GridColumn>> columns) {
            dataGrid.sortColumns(SortReset.getNotInserted(dataGrid, columns), this.mySortOrder, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ColumnAction$SortReset", "update"));
        }
    }

    public static class SortAddDesc
    extends SortAction {
        public SortAddDesc() {
            super(RowSortOrder.Type.DESC, true, DataGridBundle.messagePointer((String)"action.Console.TableResult.ColumnSortDesc.text", (Object[])new Object[0]));
        }
    }

    public static class SortDesc
    extends SortAction {
        public SortDesc() {
            super(RowSortOrder.Type.DESC, false);
        }
    }

    public static class SortAddAsc
    extends SortAction {
        public SortAddAsc() {
            super(RowSortOrder.Type.ASC, true, DataGridBundle.messagePointer((String)"action.Console.TableResult.ColumnSortAsc.text", (Object[])new Object[0]));
        }
    }

    public static class SortAsc
    extends SortAction {
        public SortAsc() {
            super(RowSortOrder.Type.ASC, false);
        }
    }

    @ApiStatus.Internal
    public static abstract class SortAction
    extends ColumnAction {
        protected final RowSortOrder.Type mySortOrder;
        private final boolean myAdditive;
        private final Supplier<@Nls String> myMenuText;

        SortAction(@NotNull RowSortOrder.Type sortOrder, boolean additive) {
            if (sortOrder == null) {
                SortAction.$$$reportNull$$$0(0);
            }
            this(sortOrder, additive, null);
        }

        SortAction(@NotNull RowSortOrder.Type sortOrder, boolean additive, @Nullable Supplier<@Nls String> menuText) {
            if (sortOrder == null) {
                SortAction.$$$reportNull$$$0(1);
            }
            this.mySortOrder = sortOrder;
            this.myAdditive = additive;
            this.myMenuText = menuText;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean otherColumnsSorted;
            DataGrid dataGrid;
            if (e == null) {
                SortAction.$$$reportNull$$$0(2);
            }
            if ((dataGrid = GridUtil.getDataGrid(e.getDataContext())) == null || !GridHelper.get(dataGrid).isSortingApplicable() || dataGrid.getResultView().isTransposed() && !dataGrid.isSortViaOrderBy()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            List<ModelIndex<GridColumn>> selectedColumns = ColumnAction.getSelectedColumns(dataGrid, e.getDataContext(), this.availableInTable());
            List<ModelIndex<GridColumn>> columns = SortAction.getNotInserted(dataGrid, selectedColumns);
            if (columns.isEmpty()) {
                e.getPresentation().setVisible(!selectedColumns.isEmpty());
                e.getPresentation().setEnabled(false);
                return;
            }
            if (ContainerUtil.exists(selectedColumns, colIdx -> !GridHelper.get(dataGrid).isSortingApplicable((ModelIndex)colIdx))) {
                e.getPresentation().setVisible(true);
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setVisible(true);
            boolean newOrder = !ContainerUtil.all(columns, column -> dataGrid.getSortOrder((ModelIndex<GridColumn>)column) == this.mySortOrder);
            boolean bl = otherColumnsSorted = !GridUtil.areOnlySortedColumns(columns, dataGrid);
            if (this.myAdditive) {
                GridHelper gridHelper = GridHelper.get(dataGrid);
                GridSortingModel model2 = dataGrid.getDataHookup().getSortingModel();
                if (model2 != null && !gridHelper.canSortTogether(dataGrid, ContainerUtil.map((Collection)model2.getAppliedOrdering(), order -> (ModelIndex)order.getColumn()), columns)) {
                    e.getPresentation().setEnabled(false);
                } else if (model2 == null || !model2.isSortingEnabled() || model2.supportsAdditiveSorting()) {
                    e.getPresentation().setEnabled(newOrder && otherColumnsSorted);
                } else {
                    e.getPresentation().setEnabledAndVisible(false);
                }
            } else {
                e.getPresentation().setEnabled(newOrder || otherColumnsSorted);
            }
            if (e.getPlace().equals("popup") && this.myMenuText != null) {
                e.getPresentation().setText(this.myMenuText.get());
            } else {
                e.getPresentation().setText(this.getTemplateText());
            }
            this.updateShortcutText(dataGrid);
        }

        @NotNull
        protected static List<ModelIndex<GridColumn>> getNotInserted(@Nullable DataGrid dataGrid, @NotNull List<ModelIndex<GridColumn>> columns) {
            GridMutator.ColumnsMutator<GridRow, GridColumn> mutator;
            if (columns == null) {
                SortAction.$$$reportNull$$$0(3);
            }
            List list = (mutator = GridUtil.getColumnsMutator(dataGrid)) == null ? columns : ContainerUtil.filter(columns, column -> !mutator.isInsertedColumn(column));
            if (list == null) {
                SortAction.$$$reportNull$$$0(4);
            }
            return list;
        }

        private void updateShortcutText(@NotNull DataGrid grid) {
            if (grid == null) {
                SortAction.$$$reportNull$$$0(5);
            }
            if (this.mySortOrder == RowSortOrder.Type.UNSORTED) {
                return;
            }
            ModelIndex<GridColumn> contextColumn = grid.getContextColumn();
            if (contextColumn.asInteger() == -1 || grid.getSortOrder(contextColumn) != RowSortOrder.Type.UNSORTED || this.getShortcutSet().hasShortcuts()) {
                this.putUserData(PopupListElementRenderer.CUSTOM_KEY_STROKE_TEXT, null);
                return;
            }
            DataGridSettings settings = GridUtil.getSettings(grid);
            boolean useAltKey = this.myAdditive == (settings == null || settings.isAddToSortViaAltClick());
            MouseShortcut shortcut = new MouseShortcut(1, useAltKey ? 512 : 0, this.mySortOrder == RowSortOrder.Type.ASC ? 1 : 2);
            @NlsSafe String mouseShortcut = KeymapUtil.getMouseShortcutText((MouseShortcut)shortcut);
            this.putUserData(PopupListElementRenderer.CUSTOM_KEY_STROKE_TEXT, mouseShortcut);
        }

        @Override
        protected boolean availableInTable() {
            return true;
        }

        @Override
        protected void actionPerformed(DataGrid dataGrid, List<ModelIndex<GridColumn>> columns) {
            dataGrid.sortColumns(SortAction.getNotInserted(dataGrid, columns), this.mySortOrder, this.myAdditive);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortOrder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ColumnAction$SortAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ColumnAction$SortAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotInserted";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getNotInserted";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "updateShortcutText";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class Visibility
    extends ColumnAction {
        public void update(@NotNull AnActionEvent e) {
            List<ModelIndex<GridColumn>> columns;
            if (e == null) {
                Visibility.$$$reportNull$$$0(0);
            }
            DataGrid dataGrid = GridUtil.getDataGrid(e.getDataContext());
            boolean enabled = false;
            if (dataGrid != null && !(columns = ColumnAction.getSelectedColumns(dataGrid, e.getDataContext(), this.availableInTable())).isEmpty()) {
                enabled = Visibility.isEnabled(dataGrid, columns, e);
            }
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        private static boolean isEnabled(DataGrid dataGrid, List<ModelIndex<GridColumn>> columns, AnActionEvent e) {
            boolean toShow = Visibility.toShow(dataGrid, columns);
            boolean single = columns.size() == 1;
            e.getPresentation().setText((toShow ? DataGridBundle.message((String)"action.ColumnAction.Visibility.show.text", (Object[])new Object[0]) : DataGridBundle.message((String)"action.ColumnAction.Visibility.hide.text", (Object[])new Object[0])) + " " + (single ? DataGridBundle.message((String)"action.ColumnAction.Visibility.column.text", (Object[])new Object[0]) : DataGridBundle.message((String)"action.ColumnAction.Visibility.columns.text", (Object[])new Object[0])));
            return true;
        }

        @Override
        protected void actionPerformed(DataGrid dataGrid, List<ModelIndex<GridColumn>> columns) {
            boolean toShow = Visibility.toShow(dataGrid, columns);
            for (ModelIndex<GridColumn> c : columns) {
                dataGrid.setColumnEnabled(c, toShow);
            }
        }

        private static boolean toShow(DataGrid dataGrid, List<ModelIndex<GridColumn>> columns) {
            ModelIndex column = (ModelIndex)ContainerUtil.getFirstItem(columns);
            return column != null && !dataGrid.isColumnEnabled(column);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/actions/ColumnAction$Visibility", "update"));
        }
    }
}

