/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.communicator;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathResolver;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.marketplace.IdeCompatibleUpdate;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.settingsSync.core.RestartForPluginInstall;
import com.intellij.settingsSync.core.SettingsSyncBundle;
import com.intellij.settingsSync.core.SettingsSyncEventListener;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.SettingsSyncLocalSettings;
import com.intellij.settingsSync.core.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.core.SettingsSyncSettings;
import com.intellij.settingsSync.core.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.core.communicator.RemoteCommunicatorHolder;
import com.intellij.settingsSync.core.communicator.SettingsSyncCommunicatorProvider;
import com.intellij.settingsSync.core.communicator.SettingsSyncUserData;
import java.awt.Component;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003'()B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0006\u0010\u0017\u001a\u00020\u000fJ$\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\n\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u001e\u001a\u00020\u0011H\u0002J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0 J\b\u0010\"\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010$\u001a\u00020\u0007J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130 J\n\u0010&\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder;", "Lcom/intellij/settingsSync/core/SettingsSyncEventListener;", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "DEFAULT_PROVIDER_CODE", "", "DEFAULT_USER_ID", "currentCommunicator", "Lcom/intellij/settingsSync/core/SettingsSyncRemoteCommunicator;", "getRemoteCommunicator", "getAuthService", "Lcom/intellij/settingsSync/core/auth/SettingsSyncAuthService;", "isAvailable", "", "invalidateCommunicator", "", "getCurrentUserData", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncUserData;", "loginStateChanged", "enabledStateChanged", "syncEnabled", "isPendingAction", "createRemoteCommunicator", "provider", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncCommunicatorProvider;", "userId", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "resetLoginData", "getAvailableProviders", "", "getExternalProviders", "getDefaultProvider", "getProvider", "providerCode", "getAvailableUserAccounts", "getCurrentProvider", "DummyAuthService", "DummyDefaultCommunicatorProvider", "DelegatingDefaultCommunicatorProvider", "intellij.settingsSync.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRemoteCommunicatorHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteCommunicatorHolder.kt\ncom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,286:1\n774#2:287\n865#2,2:288\n774#2:291\n865#2,2:292\n1368#2:294\n1454#2,5:295\n1#3:290\n15#4:300\n*S KotlinDebug\n*F\n+ 1 RemoteCommunicatorHolder.kt\ncom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder\n*L\n144#1:287\n144#1:288,2\n152#1:291\n152#1:292,2\n164#1:294\n164#1:295,5\n41#1:300\n*E\n"})
public final class RemoteCommunicatorHolder
implements SettingsSyncEventListener {
    @NotNull
    public static final RemoteCommunicatorHolder INSTANCE = new RemoteCommunicatorHolder();
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String DEFAULT_PROVIDER_CODE = "jba";
    @NotNull
    public static final String DEFAULT_USER_ID = "jba";
    @Nullable
    private static volatile SettingsSyncRemoteCommunicator currentCommunicator;

    private RemoteCommunicatorHolder() {
    }

    @Nullable
    public final SettingsSyncRemoteCommunicator getRemoteCommunicator() {
        SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator = currentCommunicator;
        if (settingsSyncRemoteCommunicator == null) {
            RemoteCommunicatorHolder $this$getRemoteCommunicator_u24lambda_u240 = this;
            boolean bl = false;
            settingsSyncRemoteCommunicator = currentCommunicator = $this$getRemoteCommunicator_u24lambda_u240.createRemoteCommunicator();
        }
        return settingsSyncRemoteCommunicator;
    }

    @Nullable
    public final SettingsSyncAuthService getAuthService() {
        SettingsSyncCommunicatorProvider settingsSyncCommunicatorProvider = this.getCurrentProvider();
        return settingsSyncCommunicatorProvider != null ? settingsSyncCommunicatorProvider.getAuthService() : null;
    }

    public final boolean isAvailable() {
        return currentCommunicator != null;
    }

    public final void invalidateCommunicator() {
        SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator = currentCommunicator;
        if (settingsSyncRemoteCommunicator != null) {
            SettingsSyncRemoteCommunicator it = settingsSyncRemoteCommunicator;
            boolean bl = false;
            logger.info("Invalidating remote communicator");
            if (it instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)it));
            }
        }
        currentCommunicator = null;
    }

    @Nullable
    public final SettingsSyncUserData getCurrentUserData() {
        String string = SettingsSyncLocalSettings.Companion.getInstance().getUserId();
        if (string == null) {
            RemoteCommunicatorHolder $this$getCurrentUserData_u24lambda_u242 = this;
            boolean bl = false;
            logger.warn("No current userId. Returning null user data");
            return null;
        }
        String userId = string;
        SettingsSyncCommunicatorProvider settingsSyncCommunicatorProvider = this.getCurrentProvider();
        if (settingsSyncCommunicatorProvider == null) {
            RemoteCommunicatorHolder $this$getCurrentUserData_u24lambda_u243 = this;
            boolean bl = false;
            logger.warn("No active provider. Returning null user data");
            return null;
        }
        SettingsSyncCommunicatorProvider provider = settingsSyncCommunicatorProvider;
        return provider.getAuthService().getUserData(userId);
    }

    @Override
    public void loginStateChanged() {
        this.invalidateCommunicator();
    }

    @Override
    public void enabledStateChanged(boolean syncEnabled) {
        if (!syncEnabled) {
            this.invalidateCommunicator();
        }
    }

    public final boolean isPendingAction() {
        if (!SettingsSyncSettings.Companion.getInstance().getSyncEnabled()) {
            return false;
        }
        String string = SettingsSyncLocalSettings.Companion.getInstance().getUserId();
        if (string == null) {
            return false;
        }
        String userId = string;
        Object object = this.getCurrentProvider();
        return (object != null && (object = object.getAuthService()) != null ? object.getPendingUserAction(userId) : null) != null;
    }

    @Nullable
    public final SettingsSyncRemoteCommunicator createRemoteCommunicator(@NotNull SettingsSyncCommunicatorProvider provider, @NotNull String userId, @Nullable Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator = provider.createCommunicator(userId);
        if (settingsSyncRemoteCommunicator == null) {
            return null;
        }
        SettingsSyncRemoteCommunicator communicator = settingsSyncRemoteCommunicator;
        if (parentDisposable != null && communicator instanceof Disposable) {
            Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)communicator));
        }
        return communicator;
    }

    public static /* synthetic */ SettingsSyncRemoteCommunicator createRemoteCommunicator$default(RemoteCommunicatorHolder remoteCommunicatorHolder, SettingsSyncCommunicatorProvider settingsSyncCommunicatorProvider, String string, Disposable disposable, int n, Object object) {
        if ((n & 4) != 0) {
            disposable = null;
        }
        return remoteCommunicatorHolder.createRemoteCommunicator(settingsSyncCommunicatorProvider, string, disposable);
    }

    private final SettingsSyncRemoteCommunicator createRemoteCommunicator() {
        SettingsSyncCommunicatorProvider settingsSyncCommunicatorProvider = this.getCurrentProvider();
        if (settingsSyncCommunicatorProvider == null) {
            RemoteCommunicatorHolder $this$createRemoteCommunicator_u24lambda_u244 = this;
            boolean bl = false;
            logger.warn("Attempting to create remote communicator without active provider");
            $this$createRemoteCommunicator_u24lambda_u244.resetLoginData();
            return null;
        }
        SettingsSyncCommunicatorProvider provider = settingsSyncCommunicatorProvider;
        String string = SettingsSyncLocalSettings.Companion.getInstance().getUserId();
        if (string == null) {
            RemoteCommunicatorHolder $this$createRemoteCommunicator_u24lambda_u245 = this;
            boolean bl = false;
            logger.warn("Empty current userId. Communicator will not be created.");
            $this$createRemoteCommunicator_u24lambda_u245.resetLoginData();
            return null;
        }
        String userId = string;
        SettingsSyncUserData settingsSyncUserData = provider.getAuthService().getUserData(userId);
        if (settingsSyncUserData == null) {
            RemoteCommunicatorHolder $this$createRemoteCommunicator_u24lambda_u246 = this;
            boolean bl = false;
            logger.warn("Cannot find user data for user '" + userId + "' in provider '" + provider.getProviderCode() + ". Resetting the data'");
            $this$createRemoteCommunicator_u24lambda_u246.resetLoginData();
            return null;
        }
        SettingsSyncUserData currentUserData = settingsSyncUserData;
        SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator = provider.createCommunicator(currentUserData.getId());
        if (settingsSyncRemoteCommunicator == null) {
            RemoteCommunicatorHolder $this$createRemoteCommunicator_u24lambda_u247 = this;
            boolean bl = false;
            logger.warn("Provider '" + provider.getProviderCode() + "' returned empty communicator");
            return null;
        }
        SettingsSyncRemoteCommunicator communicator = settingsSyncRemoteCommunicator;
        return communicator;
    }

    private final void resetLoginData() {
        logger.warn("Backup & Sync will be disabled.");
        SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
        SettingsSyncLocalSettings.Companion.getInstance().setProviderCode(null);
        SettingsSyncLocalSettings.Companion.getInstance().setUserId(null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SettingsSyncCommunicatorProvider> getAvailableProviders() {
        Object v0;
        ArrayList<DelegatingDefaultCommunicatorProvider> extensionList;
        block3: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            extensionList = new ArrayList<DelegatingDefaultCommunicatorProvider>();
            Iterable iterable = SettingsSyncCommunicatorProvider.PROVIDER_EP.getExtensionList();
            ArrayList<DelegatingDefaultCommunicatorProvider> arrayList = extensionList;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SettingsSyncCommunicatorProvider it = (SettingsSyncCommunicatorProvider)element$iv$iv;
                boolean bl = false;
                if (!it.isAvailable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            arrayList.addAll((List)destination$iv$iv);
            Iterable iterable2 = extensionList;
            for (Object t : iterable2) {
                SettingsSyncCommunicatorProvider it = (SettingsSyncCommunicatorProvider)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProviderCode(), (Object)"jba")) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if (v0 == null) {
            extensionList.add(DelegatingDefaultCommunicatorProvider.INSTANCE);
        }
        return extensionList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SettingsSyncCommunicatorProvider> getExternalProviders() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getAvailableProviders();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SettingsSyncCommunicatorProvider it = (SettingsSyncCommunicatorProvider)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getProviderCode(), (Object)"jba"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final SettingsSyncCommunicatorProvider getDefaultProvider() {
        return this.getProvider("jba");
    }

    @Nullable
    public final SettingsSyncCommunicatorProvider getProvider(@NotNull String providerCode) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)providerCode, (String)"providerCode");
            Iterable iterable = this.getAvailableProviders();
            for (Object t : iterable) {
                SettingsSyncCommunicatorProvider it = (SettingsSyncCommunicatorProvider)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProviderCode(), (Object)providerCode)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SettingsSyncUserData> getAvailableUserAccounts() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getAvailableProviders();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SettingsSyncCommunicatorProvider it = (SettingsSyncCommunicatorProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getAuthService().getAvailableUserAccounts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final SettingsSyncCommunicatorProvider getCurrentProvider() {
        String string = SettingsSyncLocalSettings.Companion.getInstance().getProviderCode();
        if (string == null) {
            return null;
        }
        String providerCode = string;
        return this.getProvider(providerCode);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteCommunicatorHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RemoteCommunicatorHolder.logger = logger;
        SettingsSyncEvents.Companion.getInstance().addListener(INSTANCE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DelegatingDefaultCommunicatorProvider;", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncCommunicatorProvider;", "<init>", "()V", "providerCode", "", "getProviderCode", "()Ljava/lang/String;", "delegate", "getDelegate", "()Lcom/intellij/settingsSync/core/communicator/SettingsSyncCommunicatorProvider;", "setDelegate", "(Lcom/intellij/settingsSync/core/communicator/SettingsSyncCommunicatorProvider;)V", "authService", "Lcom/intellij/settingsSync/core/auth/SettingsSyncAuthService;", "getAuthService", "()Lcom/intellij/settingsSync/core/auth/SettingsSyncAuthService;", "createCommunicator", "Lcom/intellij/settingsSync/core/SettingsSyncRemoteCommunicator;", "userId", "intellij.settingsSync.core"})
    private static final class DelegatingDefaultCommunicatorProvider
    implements SettingsSyncCommunicatorProvider {
        @NotNull
        public static final DelegatingDefaultCommunicatorProvider INSTANCE = new DelegatingDefaultCommunicatorProvider();
        @NotNull
        private static final String providerCode = "jba";
        @NotNull
        private static SettingsSyncCommunicatorProvider delegate = DummyDefaultCommunicatorProvider.INSTANCE;

        private DelegatingDefaultCommunicatorProvider() {
        }

        @Override
        @NotNull
        public String getProviderCode() {
            return providerCode;
        }

        @NotNull
        public final SettingsSyncCommunicatorProvider getDelegate() {
            return delegate;
        }

        public final void setDelegate(@NotNull SettingsSyncCommunicatorProvider settingsSyncCommunicatorProvider) {
            Intrinsics.checkNotNullParameter((Object)settingsSyncCommunicatorProvider, (String)"<set-?>");
            delegate = settingsSyncCommunicatorProvider;
        }

        @Override
        @NotNull
        public SettingsSyncAuthService getAuthService() {
            return delegate.getAuthService();
        }

        @Override
        @Nullable
        public SettingsSyncRemoteCommunicator createCommunicator(@NotNull String userId) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            return delegate.createCommunicator(userId);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DummyAuthService;", "Lcom/intellij/settingsSync/core/auth/SettingsSyncAuthService;", "<init>", "()V", "providerCode", "", "getProviderCode", "()Ljava/lang/String;", "providerName", "getProviderName", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "login", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncUserData;", "parentComponent", "Ljava/awt/Component;", "(Ljava/awt/Component;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getJars", "", "Ljava/nio/file/Path;", "basePath", "getUserData", "userId", "getAvailableUserAccounts", "intellij.settingsSync.core"})
    @SourceDebugExtension(value={"SMAP\nRemoteCommunicatorHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteCommunicatorHolder.kt\ncom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DummyAuthService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,286:1\n1#2:287\n1317#3,2:288\n*S KotlinDebug\n*F\n+ 1 RemoteCommunicatorHolder.kt\ncom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DummyAuthService\n*L\n253#1:288,2\n*E\n"})
    private static final class DummyAuthService
    implements SettingsSyncAuthService {
        @NotNull
        public static final DummyAuthService INSTANCE = new DummyAuthService();
        @NotNull
        private static final String providerCode = "jba";
        @NotNull
        private static final String providerName = "JetBrains";
        @NotNull
        private static final Icon icon;

        private DummyAuthService() {
        }

        @Override
        @NotNull
        public String getProviderCode() {
            return providerCode;
        }

        @Override
        @NotNull
        public String getProviderName() {
            return providerName;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return icon;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object login(@Nullable Component var1_1, @NotNull Continuation<? super SettingsSyncUserData> $completion) {
            if (!($completion instanceof login.1)) ** GOTO lbl-1000
            var14_3 = $completion;
            if ((var14_3.label & -2147483648) != 0) {
                var14_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    /* synthetic */ Object result;
                    final /* synthetic */ DummyAuthService this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.login(null, (Continuation<? super SettingsSyncUserData>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = PluginId.getId((String)"com.intellij.marketplace");
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getId(...)");
                    marketplacePluginId = v0;
                    v1 = PluginId.getId((String)"com.intellij.settingsSync");
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getId(...)");
                    settingsSyncPluginId = v1;
                    downloaders = new HashMap<PluginId, PluginDownloader>();
                    v2 = ModalTaskOwner.guess();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"guess(...)");
                    $continuation.L$0 = parentComponent;
                    $continuation.L$1 = marketplacePluginId;
                    $continuation.L$2 = settingsSyncPluginId;
                    $continuation.L$3 = downloaders;
                    $continuation.label = 1;
                    v3 = TasksKt.withModalProgress((ModalTaskOwner)v2, (String)SettingsSyncBundle.INSTANCE.message("settings.jba.plugin.download", new Object[0]), (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.cancellable()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(marketplacePluginId, settingsSyncPluginId, downloaders, null){
                        int label;
                        final /* synthetic */ PluginId $marketplacePluginId;
                        final /* synthetic */ PluginId $settingsSyncPluginId;
                        final /* synthetic */ HashMap<PluginId, PluginDownloader> $downloaders;
                        {
                            this.$marketplacePluginId = $marketplacePluginId;
                            this.$settingsSyncPluginId = $settingsSyncPluginId;
                            this.$downloaders = $downloaders;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    PluginId[] pluginIdArray = new PluginId[]{this.$marketplacePluginId, this.$settingsSyncPluginId};
                                    List pluginUpdates = MarketplaceRequests.Companion.getLastCompatiblePluginUpdate$default((MarketplaceRequests.Companion)MarketplaceRequests.Companion, (Set)SetsKt.setOf((Object[])pluginIdArray), null, (boolean)false, (int)6, null);
                                    for (IdeCompatibleUpdate update : pluginUpdates) {
                                        PluginNode pluginDescriptor = MarketplaceRequests.Companion.loadPluginDescriptor$default((MarketplaceRequests.Companion)MarketplaceRequests.Companion, (String)update.getPluginId(), (IdeCompatibleUpdate)update, null, (int)4, null);
                                        PluginDownloader pluginDownloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)((IdeaPluginDescriptor)pluginDescriptor));
                                        Intrinsics.checkNotNullExpressionValue((Object)pluginDownloader, (String)"createDownloader(...)");
                                        PluginDownloader downloader = pluginDownloader;
                                        if (!downloader.prepareToInstall(null)) continue;
                                        ((Map)this.$downloaders).put(downloader.getId(), downloader);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v3 == var15_5) {
                        return var15_5;
                    }
                    ** GOTO lbl37
                }
                case 1: {
                    downloaders = (HashMap<PluginId, PluginDownloader>)$continuation.L$3;
                    settingsSyncPluginId = (PluginId)$continuation.L$2;
                    marketplacePluginId = (PluginId)$continuation.L$1;
                    parentComponent = (Component)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl37:
                    // 2 sources

                    $continuation.L$0 = parentComponent;
                    $continuation.L$1 = null;
                    $continuation.L$2 = null;
                    $continuation.L$3 = null;
                    $continuation.label = 2;
                    v4 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(marketplacePluginId, downloaders, settingsSyncPluginId, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ PluginId $marketplacePluginId;
                        final /* synthetic */ HashMap<PluginId, PluginDownloader> $downloaders;
                        final /* synthetic */ PluginId $settingsSyncPluginId;
                        {
                            this.$marketplacePluginId = $marketplacePluginId;
                            this.$downloaders = $downloaders;
                            this.$settingsSyncPluginId = $settingsSyncPluginId;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    Object targetFile;
                                    ResultKt.throwOnFailure((Object)object);
                                    CoroutineScope $this$withContext = (CoroutineScope)this.L$0;
                                    if (!PluginManagerCore.isPluginInstalled((PluginId)this.$marketplacePluginId)) {
                                        PluginDownloader pluginDownloader = this.$downloaders.get(this.$marketplacePluginId);
                                        if (pluginDownloader == null) {
                                            CoroutineScope coroutineScope = $this$withContext;
                                            PluginId pluginId = this.$marketplacePluginId;
                                            boolean bl = false;
                                            RemoteCommunicatorHolder.access$getLogger$p().error("Cannot download plugin '" + pluginId.getIdString() + "' from marketplace!");
                                            return Boxing.boxBoolean((boolean)false);
                                        }
                                        PluginDownloader marketplacePluginDownloader = pluginDownloader;
                                        Path path = marketplacePluginDownloader.getFilePath();
                                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getFilePath(...)");
                                        Path marketplacePluginFile = path;
                                        Path path2 = PluginInstaller.unpackPlugin((Path)marketplacePluginFile, (Path)Path.of(PathManager.getPluginsPath(), new String[0]));
                                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"unpackPlugin(...)");
                                        targetFile = path2;
                                        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptor((Path)targetFile, (boolean)false, (PathResolver)PluginXmlPathResolver.DEFAULT_PATH_RESOLVER);
                                        if (ideaPluginDescriptorImpl == null) {
                                            boolean bl = false;
                                            RemoteCommunicatorHolder.access$getLogger$p().error("No descriptor found in marketplace plugin");
                                            return Boxing.boxBoolean((boolean)false);
                                        }
                                        IdeaPluginDescriptorImpl targetDescriptor = ideaPluginDescriptorImpl;
                                        Path path3 = targetFile.getParent();
                                        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
                                        targetDescriptor.jarFiles = DummyAuthService.access$getJars(DummyAuthService.INSTANCE, path3);
                                        if (!DynamicPlugins.loadPlugin$default((DynamicPlugins)DynamicPlugins.INSTANCE, (IdeaPluginDescriptorImpl)targetDescriptor, null, (int)2, null)) {
                                            RemoteCommunicatorHolder.access$getLogger$p().error("Cannot load marketplace plugin");
                                            return Boxing.boxBoolean((boolean)false);
                                        }
                                        SettingsSyncEvents.Companion.getInstance().fireRestartRequired(new RestartForPluginInstall(SetsKt.setOf((Object)marketplacePluginDownloader.getPluginName())));
                                    }
                                    if (!PluginManagerCore.isPluginInstalled((PluginId)this.$settingsSyncPluginId)) {
                                        PluginDownloader pluginDownloader = this.$downloaders.get(this.$settingsSyncPluginId);
                                        if (pluginDownloader == null) {
                                            targetFile = $this$withContext;
                                            PluginId pluginId = this.$settingsSyncPluginId;
                                            boolean bl = false;
                                            RemoteCommunicatorHolder.access$getLogger$p().error("Cannot download plugin '" + pluginId.getIdString() + "' from marketplace!");
                                            return Boxing.boxBoolean((boolean)false);
                                        }
                                        PluginDownloader syncPluginDownloader = pluginDownloader;
                                        Path path = syncPluginDownloader.getFilePath();
                                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getFilePath(...)");
                                        Path syncPluginFile = path;
                                        IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromArtifact((Path)syncPluginFile, null);
                                        if (ideaPluginDescriptorImpl == null) {
                                            CoroutineScope coroutineScope = $this$withContext;
                                            PluginId pluginId = this.$settingsSyncPluginId;
                                            boolean bl = false;
                                            RemoteCommunicatorHolder.access$getLogger$p().error("Cannot load plugin descriptor for " + pluginId.getIdString());
                                            return Boxing.boxBoolean((boolean)false);
                                        }
                                        IdeaPluginDescriptorImpl syncPluginDescriptor = ideaPluginDescriptorImpl;
                                        if (!PluginInstaller.installAndLoadDynamicPlugin((Path)syncPluginFile, null, (IdeaPluginDescriptorImpl)syncPluginDescriptor)) {
                                            RemoteCommunicatorHolder.access$getLogger$p().error("Cannot load plugin " + this.$settingsSyncPluginId.getIdString());
                                            return Boxing.boxBoolean((boolean)false);
                                        }
                                    }
                                    return Boxing.boxBoolean((boolean)true);
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v4 == var15_5) {
                        return var15_5;
                    }
                    ** GOTO lbl50
                }
                case 2: {
                    parentComponent = (Component)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl50:
                    // 2 sources

                    if (!(installSuccessful = ((Boolean)v4).booleanValue())) {
                        if (parentComponent != null) {
                            Messages.showInfoMessage((Component)parentComponent, (String)SettingsSyncBundle.INSTANCE.message("settings.jba.plugin.required.text", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("settings.jba.plugin.required.title", new Object[0]));
                        } else {
                            Messages.showInfoMessage((String)SettingsSyncBundle.INSTANCE.message("settings.jba.plugin.required.text", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("settings.jba.plugin.required.title", new Object[0]));
                        }
                        return null;
                    }
                    var8_10 = SettingsSyncCommunicatorProvider.PROVIDER_EP.getExtensionList();
                    for (T var10_12 : var8_10) {
                        it = (SettingsSyncCommunicatorProvider)var10_12;
                        $i$a$-find-RemoteCommunicatorHolder$DummyAuthService$login$defaultProvider$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getProviderCode(), (Object)"jba")) continue;
                        v5 = var10_12;
                        ** GOTO lbl64
                    }
                    v5 = null;
lbl64:
                    // 2 sources

                    v6 = v5;
                    if (v6 == null) {
                        return null;
                    }
                    defaultProvider = v6;
                    DelegatingDefaultCommunicatorProvider.INSTANCE.setDelegate(defaultProvider);
                    $continuation.L$0 = null;
                    $continuation.label = 3;
                    v7 = defaultProvider.getAuthService().login(parentComponent, (Continuation<? super SettingsSyncUserData>)$continuation);
                    if (v7 == var15_5) {
                        return var15_5;
                    }
                    ** GOTO lbl78
                }
                case 3: {
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl78:
                    // 2 sources

                    return v7;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final List<Path> getJars(Path basePath) {
            ArrayList<Path> jars = new ArrayList<Path>();
            File file = basePath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)file, null, (int)1, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (!it.isFile() || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"jar")) continue;
                jars.add(it.toPath());
            }
            return jars;
        }

        @Override
        @Nullable
        public SettingsSyncUserData getUserData(@NotNull String userId) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            return null;
        }

        @Override
        @NotNull
        public List<SettingsSyncUserData> getAvailableUserAccounts() {
            return CollectionsKt.emptyList();
        }

        public static final /* synthetic */ List access$getJars(DummyAuthService $this, Path basePath) {
            return $this.getJars(basePath);
        }

        static {
            Icon icon = AllIcons.Ultimate.IdeaUltimatePromo;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"IdeaUltimatePromo");
            DummyAuthService.icon = icon;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DummyDefaultCommunicatorProvider;", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncCommunicatorProvider;", "<init>", "()V", "providerCode", "", "getProviderCode", "()Ljava/lang/String;", "authService", "Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DummyAuthService;", "getAuthService", "()Lcom/intellij/settingsSync/core/communicator/RemoteCommunicatorHolder$DummyAuthService;", "createCommunicator", "Lcom/intellij/settingsSync/core/SettingsSyncRemoteCommunicator;", "userId", "intellij.settingsSync.core"})
    private static final class DummyDefaultCommunicatorProvider
    implements SettingsSyncCommunicatorProvider {
        @NotNull
        public static final DummyDefaultCommunicatorProvider INSTANCE = new DummyDefaultCommunicatorProvider();
        @NotNull
        private static final DummyAuthService authService = DummyAuthService.INSTANCE;

        private DummyDefaultCommunicatorProvider() {
        }

        @Override
        @NotNull
        public String getProviderCode() {
            return "jba";
        }

        @Override
        @NotNull
        public DummyAuthService getAuthService() {
            return authService;
        }

        @Override
        @Nullable
        public SettingsSyncRemoteCommunicator createCommunicator(@NotNull String userId) {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            return null;
        }
    }
}

