/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.ide.ui.IdeUiService;
import com.intellij.internal.statistic.eventLog.ExternalEventLogSettings;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.request.StatsProxyInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogAppConnectionSettings
implements EventLogConnectionSettings {
    private static final StatsProxyInfo NO_PROXY = new StatsProxyInfo(Proxy.NO_PROXY, null);

    @Override
    @NotNull
    public String getUserAgent() {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            String version = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
            String string = productName + "/" + version;
            if (string == null) {
                EventLogAppConnectionSettings.$$$reportNull$$$0(0);
            }
            return string;
        }
        return "IntelliJ";
    }

    @Override
    @NotNull
    public StatsProxyInfo selectProxy(@NotNull String url) {
        Proxy proxy;
        Application app;
        if (url == null) {
            EventLogAppConnectionSettings.$$$reportNull$$$0(1);
        }
        if ((app = ApplicationManager.getApplication()) != null && !app.isDisposed() && (proxy = EventLogAppConnectionSettings.findProxy(url)) != Proxy.NO_PROXY) {
            return new StatsProxyInfo(proxy, EventLogAppConnectionSettings.getAuthProvider());
        }
        StatsProxyInfo statsProxyInfo = NO_PROXY;
        if (statsProxyInfo == null) {
            EventLogAppConnectionSettings.$$$reportNull$$$0(2);
        }
        return statsProxyInfo;
    }

    @Override
    @Nullable
    public SSLContext getSSLContext() {
        return IdeUiService.getInstance().getSslContext();
    }

    @Override
    @NotNull
    public Map<String, String> getExtraHeaders() {
        ExternalEventLogSettings externalEventLogSettings = StatisticsEventLogProviderUtil.getExternalEventLogSettings();
        if (externalEventLogSettings != null) {
            Map<String, String> map = externalEventLogSettings.getExtraLogUploadHeaders();
            if (map == null) {
                EventLogAppConnectionSettings.$$$reportNull$$$0(3);
            }
            return map;
        }
        Map<String, String> map = Collections.emptyMap();
        if (map == null) {
            EventLogAppConnectionSettings.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Nullable
    private static StatsProxyInfo.StatsProxyAuthProvider getAuthProvider() {
        if (IdeUiService.getInstance().isProxyAuth()) {
            return EventLogAppProxyAuth.INSTANCE;
        }
        return null;
    }

    @NotNull
    private static Proxy findProxy(@NotNull String url) {
        Proxy proxy;
        if (url == null) {
            EventLogAppConnectionSettings.$$$reportNull$$$0(5);
        }
        try {
            List proxies = IdeUiService.getInstance().getProxyList(new URL(url));
            proxy = !proxies.isEmpty() ? (Proxy)proxies.get(0) : Proxy.NO_PROXY;
        }
        catch (MalformedURLException malformedURLException) {
            Proxy proxy2 = Proxy.NO_PROXY;
            if (proxy2 == null) {
                EventLogAppConnectionSettings.$$$reportNull$$$0(7);
            }
            return proxy2;
        }
        if (proxy == null) {
            EventLogAppConnectionSettings.$$$reportNull$$$0(6);
        }
        return proxy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogAppConnectionSettings";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAgent";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogAppConnectionSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "selectProxy";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraHeaders";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findProxy";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectProxy";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findProxy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5 -> new IllegalArgumentException(string);
        };
    }

    private static final class EventLogAppProxyAuth
    implements StatsProxyInfo.StatsProxyAuthProvider {
        private static final EventLogAppProxyAuth INSTANCE = new EventLogAppProxyAuth();

        private EventLogAppProxyAuth() {
        }

        @Override
        @Nullable
        public String getProxyLogin() {
            return IdeUiService.getInstance().getProxyLogin();
        }

        @Override
        @Nullable
        public String getProxyPassword() {
            return IdeUiService.getInstance().getPlainProxyPassword();
        }
    }
}

