//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: Debug.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef Debug_hpp
#define Debug_hpp
//==============================================================================
// Includes
#include <iostream>
#include "dbg.h"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================

//==============================================================================
//! Get error stream
//------------------------------------------------------------------------------
inline std::ostream &dbgError (void)
{
	#ifdef DBG_ENABLED
		return dbg::out (dbg::error) << dbg::indent (dbg::error);
	#else
		return cerr;
	#endif
}
//==============================================================================

//==============================================================================
//! Get warning stream
//------------------------------------------------------------------------------
inline std::ostream &dbgWarning (void)
{
	#ifdef DBG_ENABLED
		return dbg::out (dbg::warning) << dbg::indent (dbg::warning);
	#else
		return cout;
	#endif
}
//==============================================================================

//==============================================================================
//! Get info stream
//------------------------------------------------------------------------------
inline std::ostream &dbgInfo (void)
{
	#ifdef DBG_ENABLED
		return dbg::out (dbg::info) << dbg::indent (dbg::info);
	#else
		return cout;
	#endif
}
//==============================================================================

//==============================================================================
//! Get named error stream
//------------------------------------------------------------------------------
inline std::ostream &dbgError (dbg::dbg_source src)
{
	#ifdef DBG_ENABLED
		dbg::enable (dbg::all, src, true);
		return dbg::out (dbg::error, src) << dbg::indent (dbg::error) << src << ": ";
	#else
		return cout;
	#endif
}
//==============================================================================

//==============================================================================
//! Get named warning stream
//------------------------------------------------------------------------------
inline std::ostream &dbgWarning (dbg::dbg_source src)
{
	#ifdef DBG_ENABLED
		dbg::enable (dbg::all, src, true);
		return dbg::out (dbg::warning, src) << dbg::indent (dbg::warning) << src << ": ";
	#else
		return cout;
	#endif

}
//==============================================================================

//==============================================================================
//! Get named info stream
//------------------------------------------------------------------------------
inline std::ostream &dbgInfo (dbg::dbg_source src)
{
	#ifdef DBG_ENABLED
		dbg::enable (dbg::all, src, true);
		return dbg::out (dbg::info, src) << dbg::indent (dbg::info) << src << ": ";
	#else
		return cout;
	#endif

}
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // Debug_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
