//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cIdentifiable.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cIdentifiable_hpp
#define cIdentifiable_hpp
//==============================================================================
// Includes
#include "Types.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//==============================================================================
//! Every identifiable object has an unique ID
//------------------------------------------------------------------------------
class cIdentifiable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cIdentifiable (void);
		//! Destructor
		~cIdentifiable (void);
	
	// Copy constructor
	private:
		//! Copy constructor
		//cIdentifiable (cIdentifiable &copy);
	
	// Public methods
	public:
		//! Returns the ID of this object
		ObjectID GetID (void) const { return mID; };
	
	// Member variables
	private:
		ObjectID mID;	//!< Unique ID
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cIdentifiable_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
