//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cHud.cpp
// Project: Shooting Star
// Author: Tuomas Peippo
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cRandomND.hpp"
#include <stdlib.h>
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================

//! Constructor
cRandomND::cRandomND (){

/* Normal distribution calculated by Normaalijakauma
   by 2ndpoint ry, http://www.2ndpoint.fi

   variables:
   iso = 16777216.000000, e = 2.718282
   pii = 3.141593
   hattu = 5.000000, tarkk = 0.000010
   kert = 256.000439 
*/

};

//! Destructor
cRandomND::~cRandomND (void)
{

};

double cRandomND::RandND (void)
{
double distTable[256]=
{0.000000,	0.007250,	0.014515,	0.021765,	0.029030,	
 0.036295,	0.043545,	0.050810,	0.058074,	0.065339,	
 0.072604,	0.079869,	0.087149,	0.094413,	0.101693,	
 0.108973,	0.116253,	0.123532,	0.130812,	0.138106,	
 0.145401,	0.152695,	0.159990,	0.167299,	0.174594,	
 0.181918,	0.189227,	0.196551,	0.203876,	0.211200,	
 0.218539,	0.225878,	0.233232,	0.240571,	0.247939,	
 0.255293,	0.262662,	0.270045,	0.277429,	0.284812,	
 0.292210,	0.299623,	0.307037,	0.314450,	0.321878,	
 0.329320,	0.336763,	0.344206,	0.351678,	0.359151,	
 0.366623,	0.374110,	0.381613,	0.389115,	0.396631,	
 0.404163,	0.411710,	0.419256,	0.426818,	0.434379,	
 0.441970,	0.449561,	0.457167,	0.464788,	0.472408,	
 0.480059,	0.487709,	0.495374,	0.503069,	0.510764,	
 0.518473,	0.526198,	0.533922,	0.541677,	0.549445,	
 0.557229,	0.565028,	0.572841,	0.580670,	0.588513,	
 0.596371,	0.604258,	0.612146,	0.620063,	0.627995,	
 0.635942,	0.643918,	0.651895,	0.659901,	0.667922,	
 0.675973,	0.684038,	0.692118,	0.700228,	0.708353,	
 0.716493,	0.724662,	0.732861,	0.741060,	0.749303,	
 0.757561,	0.765849,	0.774152,	0.782484,	0.790831,	
 0.799223,	0.807630,	0.816051,	0.824517,	0.832997,	
 0.841522,	0.850062,	0.858632,	0.867231,	0.875845,	
 0.884504,	0.893192,	0.901910,	0.910672,	0.919449,	
 0.928256,	0.937107,	0.945988,	0.954899,	0.963854,	
 0.972838,	0.981853,	0.990912,	1.000000,	1.009133,	
 1.018310,	1.027517,	1.036769,	1.046050,	1.055391,	
 1.064761,	1.074176,	1.083635,	1.093138,	1.102687,	
 1.112279,	1.121916,	1.131613,	1.141339,	1.151124,	
 1.160968,	1.170858,	1.180791,	1.190799,	1.200836,	
 1.210948,	1.221104,	1.231319,	1.241608,	1.251942,	
 1.262335,	1.272803,	1.283329,	1.293915,	1.304575,	
 1.315295,	1.326088,	1.336956,	1.347883,	1.358899,	
 1.369989,	1.381153,	1.392391,	1.403704,	1.415120,	
 1.426610,	1.438175,	1.449843,	1.461600,	1.473446,	
 1.485381,	1.497420,	1.509563,	1.521795,	1.534145,	
 1.546599,	1.559157,	1.571833,	1.584628,	1.597542,	
 1.610574,	1.623725,	1.637009,	1.650427,	1.663993,	
 1.677692,	1.691525,	1.705521,	1.719666,	1.733973,	
 1.748428,	1.763062,	1.777873,	1.792863,	1.808030,	
 1.823405,	1.838972,	1.854733,	1.870715,	1.886920,	
 1.903348,	1.920012,	1.936929,	1.954098,	1.971534,	
 1.989251,	2.007250,	2.025546,	2.044167,	2.063100,	
 2.082389,	2.102034,	2.122064,	2.142480,	2.163311,	
 2.184572,	2.206307,	2.228517,	2.251231,	2.274493,	
 2.298334,	2.322782,	2.347883,	2.373666,	2.400190,	
 2.427515,	2.455670,	2.484759,	2.514826,	2.545976,	
 2.578283,	2.611864,	2.646839,	2.683356,	2.721563,	
 2.761683,	2.803938,	2.848594,	2.895994,	2.946551,	
 3.000786,	3.059379,	3.123162,	3.193304,	3.271439,	
 3.359862,	3.462163,	3.584198,	3.736775,	3.943616,	
 4.277829};
 
	double randSign(1);
	if ( int(rand()/(RAND_MAX + 1.0f)))
		randSign = -1;
	
	return randSign * distTable[ int (256.0f * rand()/(RAND_MAX + 1.0f) )];
	
	
}

//==============================================================================
// EOF
//==============================================================================
