//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cBloodPool.cpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cBloodPool.hpp"
#include "cAnimationManager.hpp"
#include <stdlib.h>
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cBloodPool::cBloodPool (void)
{
	mAnimation.SetAnimation (cAnimationManager::GetInstance ().LoadAnimation ("bloodpool"));
	mAnimation.SetNumberOfFrames (4);
	mAnimation.SetCurrentFrame (int (3.0f * rand () / (RAND_MAX + 1.0f)));
	mAnimation.SetFrameDelay (999999);

	SetLayer (-30);
	SetRotation (360.0f * rand () / (RAND_MAX + 1.0f));
};

//! Destructor
cBloodPool::~cBloodPool (void)
{
	// Empty
};

//==============================================================================
// EOF
//==============================================================================
